/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapcommon;

import java.io.Serializable;
import oracle.sdovis.JSDOGeometry;

public class GeocoderAddress
implements Cloneable,
Serializable {
    static final long serialVersionUID = -1671644427210214498L;
    public int id;
    public String matchMode = "DEFAULT";
    public String srsName = "SDO:8265";
    public int nMultiMatch = 4;
    public String name = null;
    public String street = null;
    public String intersectStreet = null;
    public String secUnit = null;
    public String builtUpArea = null;
    public String order8 = null;
    public String order2 = null;
    public String order1 = null;
    public String country = null;
    public String postalCode = null;
    public String postalAddonCode = null;
    public String lastline = null;
    public String houseNumber = null;
    public String baseName = null;
    public String streetType = null;
    public String streetPrefix = null;
    public String streetSuffix = null;
    public int rangeFrom = 0;
    public int rangeTo = 1;
    public char side = (char)32;
    public double percent = 0.0;
    public int dca = 0;
    public int edgeId = 0;
    public double[] coordinates = null;
    public JSDOGeometry edgeGeometry = null;
    public int matchCode = 0;
    public StringBuffer errorMessage = null;
    public int matchSequence = 0;
    public int stringScore = 0;

    public GeocoderAddress() {
    }

    public GeocoderAddress(String inName, String inStreet, String inIntersectingStreet, String inBuiltUpArea, String inOrder8, String inOrder2, String inOrder1, String inCountry, String inPostalCode, String inPostalAddonCode) {
        this.setName(inName);
        this.setStreet(inStreet);
        this.setIntersectStreet(inIntersectingStreet);
        this.setBuiltUpArea(inBuiltUpArea);
        this.setOrder8(inOrder8);
        this.setOrder2(inOrder2);
        this.setOrder1(inOrder1);
        this.setCountry(inCountry);
        this.setPostalCode(inPostalCode);
        this.setPostalAddonCode(inPostalAddonCode);
    }

    public GeocoderAddress(double inX, double inY) {
        if (this.coordinates == null) {
            this.coordinates = new double[2];
        }
        this.coordinates[0] = inX;
        this.coordinates[1] = inY;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int inId) {
        this.id = inId;
    }

    public void setCoordinates(double inX, double inY) {
        if (this.coordinates == null) {
            this.coordinates = new double[2];
        }
        this.coordinates[0] = inX;
        this.coordinates[1] = inY;
    }

    public double[] getCoordinates() {
        return this.coordinates;
    }

    public String getMatchMode() {
        return this.matchMode;
    }

    public synchronized void setMatchMode(String inMatchMode) {
        if (inMatchMode == null || inMatchMode.equals("")) {
            this.matchMode = "DEFAULT";
        }
        this.matchMode = !(inMatchMode = inMatchMode.toUpperCase()).equals("EXACT") && !inMatchMode.equals("RELAX_STREET_TYPE") && !inMatchMode.equals("RELAX_HOUSE_NUMBER") && !inMatchMode.equals("RELAX_BASE_NAME") && !inMatchMode.equals("RELAX_POSTAL_CODE") && !inMatchMode.equals("RELAX_BUILTUP_AREA") && !inMatchMode.equals("ADMIN_BOUND") && !inMatchMode.equals("POSTALCODE") && !inMatchMode.equals("RELAX_ALL") && !inMatchMode.equals("RELAX_POI_NAME") && !inMatchMode.equals("DEFAULT") ? "DEFAULT" : inMatchMode.toUpperCase();
    }

    public int getNMultiMatch() {
        return this.nMultiMatch;
    }

    public void setNMultiMatch(int inNMultiMatch) {
        if (inNMultiMatch <= 32) {
            this.nMultiMatch = inNMultiMatch;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String inName) {
        if (inName != null) {
            this.name = inName.toUpperCase();
        }
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String inStreet) {
        if (inStreet != null) {
            this.street = inStreet.toUpperCase();
        }
    }

    public String getIntersectStreet() {
        return this.intersectStreet;
    }

    public void setIntersectStreet(String inIntersectStreet) {
        if (inIntersectStreet != null) {
            this.intersectStreet = inIntersectStreet.toUpperCase();
        }
    }

    public String getSecUnit() {
        return this.secUnit;
    }

    public void setSecUnit(String inSecUnit) {
        if (inSecUnit != null) {
            this.secUnit = inSecUnit.toUpperCase();
        }
    }

    public String getBuiltUpArea() {
        return this.builtUpArea;
    }

    public void setBuiltUpArea(String inBuiltUpArea) {
        if (inBuiltUpArea != null) {
            this.builtUpArea = inBuiltUpArea.toUpperCase();
        }
    }

    public String getOrder8() {
        return this.order8;
    }

    public void setOrder8(String inOrder8) {
        if (inOrder8 != null) {
            this.order8 = inOrder8.toUpperCase();
        }
    }

    public String getOrder2() {
        return this.order2;
    }

    public void setOrder2(String inOrder2) {
        if (inOrder2 != null) {
            this.order2 = inOrder2.toUpperCase();
        }
    }

    public String getOrder1() {
        return this.order1;
    }

    public void setOrder1(String inOrder1) {
        if (inOrder1 != null) {
            this.order1 = inOrder1.toUpperCase();
        }
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String inCountry) {
        if (inCountry != null) {
            this.country = inCountry.toUpperCase();
        }
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String inPostalCode) {
        if (inPostalCode != null) {
            this.postalCode = inPostalCode.toUpperCase();
        }
    }

    public String getPostalAddonCode() {
        return this.postalAddonCode;
    }

    public void setPostalAddonCode(String inPostalAddonCode) {
        if (inPostalAddonCode != null) {
            this.postalAddonCode = inPostalAddonCode.toUpperCase();
        }
    }

    public Object clone() {
        try {
            GeocoderAddress loc = (GeocoderAddress)super.clone();
            loc.errorMessage = new StringBuffer(this.errorMessage.toString());
            if (this.coordinates == null) {
                loc.coordinates = null;
            } else {
                loc.coordinates = new double[2];
                loc.coordinates[0] = this.coordinates[0];
                loc.coordinates[1] = this.coordinates[1];
            }
            loc.edgeGeometry = this.edgeGeometry == null ? null : (JSDOGeometry)this.edgeGeometry.clone();
            return loc;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        String s = "id = " + this.id + "\n";
        s = s + " seq = " + this.matchSequence + "\n";
        s = s + " name = " + this.name + "\n";
        s = s + " street = " + this.street + "\n";
        s = s + " (houseNumber = " + this.houseNumber + " streetPrefix = " + this.streetPrefix + " baseName = " + this.baseName;
        s = s + " streetType = " + this.streetType + " streetSuffix = " + this.streetSuffix + " apt = " + this.secUnit + ")\n";
        s = s + " intersecting_street = " + this.intersectStreet + "\n";
        s = s + " builtUpArea = " + this.builtUpArea + "\n";
        s = s + " order8_area = " + this.order8 + "\n";
        s = s + " order2_area = " + this.order2 + "\n";
        s = s + " order1_area = " + this.order1 + "\n";
        s = s + " country = " + this.country + "\n";
        s = s + " postalCode = " + this.postalCode + "\n";
        s = s + " postalAddOnCode = " + this.postalAddonCode + "\n";
        s = s + " edgeId = " + this.edgeId + " side = " + this.side + " percent = " + this.percent + "\n";
        s = s + " rangeFrom = " + this.rangeFrom + " rangeTo = " + this.rangeTo + "\n";
        if (this.coordinates != null) {
            s = s + " longitude = " + this.coordinates[0] + "\n";
            s = s + " latitude = " + this.coordinates[1] + "\n";
        } else {
            s = s + "Null Coords\n";
        }
        s = s + " matchCode = " + this.matchCode + "\n";
        s = s + " errorMessage = " + this.errorMessage + "\n";
        s = s + " dca = " + this.dca;
        return s;
    }
}

