/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.io.Serializable;

public class SizeDefinition
implements Serializable {
    private double value = 5.0;
    private String unit = null;

    public SizeDefinition() {
    }

    public SizeDefinition(double value, String unit) {
        this.value = value;
        this.setUnit(unit);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit == null ? null : unit.toLowerCase();
    }

    public static final SizeDefinition parse(String valueWithunit) {
        if (valueWithunit == null || valueWithunit.trim().length() == 0) {
            return null;
        }
        String value = valueWithunit.trim();
        String numvalue = "";
        String numunit = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isDigit(c) || c == '-' && i == 0) {
                numvalue = numvalue + c;
                continue;
            }
            if (c == '.') {
                if (!Character.isDigit(value.charAt(i + 1))) continue;
                numvalue = numvalue + c;
                continue;
            }
            numunit = value.substring(i, value.length()).trim();
            break;
        }
        try {
            return new SizeDefinition(Double.parseDouble(numvalue), numunit);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final boolean isPixelUnit() {
        return this.unit == null || this.unit.equals("pt") || this.unit.equals("px");
    }
}

