/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.mapcache;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.mapviewer.share.mapcache.TileDefinition;
import oracle.mapviewer.share.util.LogFactory;

public abstract class MapSourceAdapter {
    public static final int DEFAULT_TIMEOUT = 15000;
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SHARE);
    private String mapServiceURL = null;
    private Properties props = null;
    private String httpMethod = "POST";
    private int timeOut = 15000;
    private int proxyPort = 80;
    private String proxyHost = null;
    transient HttpURLConnection mHttp = null;

    public abstract String getMapTileRequest(TileDefinition var1);

    public byte[] getTileImageBytes(TileDefinition tile) throws Exception {
        String request = this.getMapTileRequest(tile);
        log.finer(request);
        if (request == null) {
            throw new Exception("Null map tile request string in map source adapter!");
        }
        if (request.indexOf("?&?") == 0) {
            return request.getBytes();
        }
        Properties sysprops = System.getProperties();
        Proxy proxy = null;
        boolean noProxy = "NONE".equalsIgnoreCase(this.getProxyHost());
        if (this.getProxyHost() != null && !noProxy) {
            InetSocketAddress addr = new InetSocketAddress(this.proxyHost, this.proxyPort);
            proxy = new Proxy(Proxy.Type.HTTP, addr);
        }
        PrintWriter wr = null;
        BufferedInputStream bis = null;
        try {
            String urlStr = this.mapServiceURL;
            if ("GET".equalsIgnoreCase(this.httpMethod)) {
                urlStr = this.mapServiceURL.indexOf(63) > 0 ? (!this.mapServiceURL.endsWith("&") ? this.mapServiceURL + "&" + request : this.mapServiceURL + request) : (this.mapServiceURL.endsWith("/") ? this.mapServiceURL.substring(0, this.mapServiceURL.length() - 1) + "?" + request : this.mapServiceURL + "?" + request);
            }
            log.finest("http " + this.httpMethod + ": " + urlStr);
            URL url = new URL(urlStr);
            URLConnection conn = proxy != null ? url.openConnection(proxy) : (noProxy ? url.openConnection(Proxy.NO_PROXY) : url.openConnection());
            conn.setConnectTimeout(this.timeOut);
            if ("GET".equalsIgnoreCase(this.httpMethod)) {
                conn.connect();
            } else {
                conn.setDoOutput(true);
                wr = new PrintWriter(conn.getOutputStream());
                wr.print(request);
                wr.flush();
                wr.close();
                wr = null;
            }
            bis = new BufferedInputStream(conn.getInputStream());
            byte[] result = this.toBytes(bis);
            bis.close();
            bis = null;
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception ioe) {
            throw new Exception("Failed to fetch external map tile.", ioe);
        }
        finally {
            if (bis != null) {
                bis.close();
                bis = null;
            }
            if (wr != null) {
                wr.close();
                wr = null;
            }
        }
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setHTTPMethod(String method) {
        this.httpMethod = method;
    }

    public String getHTTPMethod() {
        return this.httpMethod;
    }

    public void setProxyHost(String host) {
        if (host != null && host.trim().length() > 0) {
            this.proxyHost = host;
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String port) {
        try {
            this.proxyPort = Integer.parseInt(port);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setMapServiceURL(String url) {
        this.mapServiceURL = url;
    }

    public String getMapServiceURL() {
        return this.mapServiceURL;
    }

    public void setConnectionTimeout(int timeout) {
        this.timeOut = timeout;
    }

    public int getConnectionTimeout() {
        return this.timeOut;
    }

    private byte[] toBytes(BufferedInputStream bis) throws IOException {
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int len = 0;
        while (0 < (len = bis.read(buffer))) {
            baos.write(buffer, 0, len);
        }
        baos.close();
        return baos.toByteArray();
    }
}

