/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;

public class AreaStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = -7936230043110821340L;
    public static final int AREA_STYLE_COLOR = 1;
    public static final int AREA_STYLE_TEXTURE = 2;
    public static final int AREA_STYLE_GRADIENT_COLOR = 3;
    int areaStyleType = 1;
    float borderWidth = 1.0f;
    Color borderColor = Color.gray;
    String borderStyleName = null;
    Color fillColor = new Color(128, 128, 128, 128);
    byte[] fillPatternImage = null;
    boolean repeatFillPattern = true;

    public AreaStyleModel() {
        this.type = 4;
    }

    @Override
    public Object clone() {
        AreaStyleModel obj = (AreaStyleModel)super.clone();
        return obj;
    }

    @Override
    public String getTypeName() {
        return "AREA";
    }

    @Override
    public String toXMLString() {
        String res = "<?xml version=\"1.0\" standalone=\"yes\"?>\n";
        res = res + "<svg width=\"1in\" height=\"1in\">\n";
        res = res + "  <desc></desc>\n";
        res = res + "  <g class=\"area\" ";
        if (this.borderStyleName != null || this.borderColor != null) {
            if (this.borderStyleName != null) {
                res = res + " style=\"line-style:" + XMLUtil.replaceXMLEntities(this.borderStyleName);
            } else if (this.borderColor != null) {
                String sw = ";stroke-width:" + this.borderWidth;
                if (this.borderWidth == 1.0f) {
                    sw = "";
                }
                String opa = this.borderColor.getAlpha() < 255 ? ";stroke-opacity:" + this.borderColor.getAlpha() : "";
                res = res + " style=\"stroke:" + StyleUtils.getHexidecimalString(this.borderColor) + opa + sw;
            }
            if (this.fillColor != null) {
                res = res + ";fill:" + StyleUtils.getHexidecimalString(this.fillColor);
                int alpha = this.fillColor.getAlpha();
                if (alpha < 255) {
                    res = res + ";fill-opacity:" + alpha;
                }
            }
            res = res + "\"";
        } else if (this.fillColor != null) {
            res = res + " style=\"fill:" + StyleUtils.getHexidecimalString(this.fillColor);
            int alpha = this.fillColor.getAlpha();
            if (alpha < 255) {
                res = res + ";fill-opacity:" + alpha;
            }
            res = res + "\"";
        }
        res = res + " >\n";
        if (!this.isRepeatFillPattern()) {
            res = res + " <fill-pattern repeat=\"false\"/>\n";
        }
        res = res + "    <image x=\"0\" y=\"0\" width=\"9999\" height=\"9999\" type=\"gif\" href=\"dummy.gif\"/>";
        res = res + "\n  </g>\n</svg>";
        return res;
    }

    public void setAreaStyleType(int t) {
        if (t != 1 && t != 2 && t != 3) {
            throw new IllegalArgumentException("Invalid area style sub-type code.");
        }
        this.areaStyleType = t;
        if (t == 1 && this.fillColor == null) {
            this.fillColor = new Color(128, 128, 128, 128);
        }
    }

    public int getAreaStyleType() {
        return this.areaStyleType;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        if (borderColor != null) {
            this.borderStyleName = null;
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderStyleName(String borderStyleName) {
        this.borderStyleName = borderStyleName;
        if (borderStyleName != null) {
            this.borderColor = null;
        }
    }

    public String getBorderStyleName() {
        return this.borderStyleName;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        if (fillColor != null) {
            this.areaStyleType = 1;
            this.fillPatternImage = null;
        }
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillPatternImage(byte[] fillPatternImage) {
        this.fillPatternImage = fillPatternImage;
        if (fillPatternImage != null) {
            this.areaStyleType = 2;
            this.fillColor = null;
        }
    }

    public byte[] getFillPatternImage() {
        return this.fillPatternImage;
    }

    public boolean isRepeatFillPattern() {
        return this.repeatFillPattern;
    }

    public void setRepeatFillPattern(boolean repeatFillPattern) {
        this.repeatFillPattern = repeatFillPattern;
    }

    @Override
    public String[] getStyleDependency() {
        String[] deps = null;
        if (this.borderStyleName != null) {
            deps = new String[]{this.borderStyleName};
        }
        return deps;
    }
}

