/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BaseMap;
import oracle.sdovis.BasemapStore;

public class BasemapCache {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected BasemapStore basemapStore;
    protected String dsName;
    protected Hashtable basemaps;
    protected int maxSize = 9999;
    private Hashtable editedBasemaps = null;

    public BasemapCache(String dataSrc, BasemapStore store) {
        this.dsName = dataSrc;
        this.basemaps = new Hashtable(17);
        this.basemapStore = store;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setBasemapStore(BasemapStore store) {
        this.basemapStore = store;
    }

    public BasemapStore getBasemapStore() {
        return this.basemapStore;
    }

    public synchronized BaseMap getOrLoadBasemap(String basemapName) {
        basemapName = basemapName.toUpperCase();
        BaseMap bmap = null;
        if (this.editedBasemaps != null && (bmap = (BaseMap)this.editedBasemaps.get(basemapName)) != null) {
            return bmap;
        }
        CacheEntry ce = (CacheEntry)this.basemaps.get(basemapName);
        if (ce != null) {
            ce.mark();
            return ce.basemap;
        }
        BaseMap basemap = null;
        try {
            basemap = this.basemapStore.loadBasemapDefinition(basemapName);
            if (basemap != null) {
                this.putBasemapDefinition(basemapName, basemap);
            }
            return basemap;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "[datasource:" + this.dsName + "] cannot load basemap " + basemapName, e);
            return null;
        }
    }

    public BaseMap getBasemap(String basemapName) {
        basemapName = basemapName.toUpperCase();
        BaseMap bmap = null;
        if (this.editedBasemaps != null && (bmap = (BaseMap)this.editedBasemaps.get(basemapName)) != null) {
            return bmap;
        }
        CacheEntry ce = (CacheEntry)this.basemaps.get(basemapName);
        if (ce != null) {
            ce.mark();
            return ce.basemap;
        }
        return null;
    }

    public void putBasemapDefinition(String basemapName, BaseMap map) {
        basemapName = basemapName.toUpperCase();
        if (this.basemaps.size() > this.maxSize) {
            this.purge();
        }
        CacheEntry ce = new CacheEntry(map);
        this.basemaps.put(basemapName, ce);
    }

    public void remove(String basemapName) {
        basemapName = basemapName.toUpperCase();
        this.basemaps.remove(basemapName);
    }

    public void removeAll() {
        this.basemaps.clear();
    }

    private void purge() {
    }

    public boolean addBasemapToEditedList(String name, BaseMap m) {
        if (name == null || m == null) {
            return false;
        }
        if (this.editedBasemaps == null) {
            this.editedBasemaps = new Hashtable();
        }
        this.editedBasemaps.put(name.toUpperCase(), m);
        return true;
    }

    public boolean removeBasemapFromEditedList(String name) {
        if (name == null || this.editedBasemaps == null) {
            return false;
        }
        this.editedBasemaps.remove(name.toUpperCase());
        return true;
    }

    public void clearBasemapEditedList() {
        if (this.editedBasemaps != null) {
            this.editedBasemaps.clear();
        }
    }

    public String[] getCachedBasemapNames() {
        if (this.basemaps == null) {
            return new String[0];
        }
        String[] res = new String[this.basemaps.size()];
        int i = 0;
        Enumeration e = this.basemaps.keys();
        while (e.hasMoreElements()) {
            res[i++] = (String)e.nextElement();
        }
        return res;
    }

    static class CacheEntry {
        BaseMap basemap;
        long lastUsed;

        public CacheEntry(BaseMap _bm) {
            this.basemap = _bm;
            this.lastUsed = System.currentTimeMillis();
        }

        public void mark() {
            this.lastUsed = System.currentTimeMillis();
        }
    }
}

