/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.lbs.mapcache.cache.MapCache;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CustomGeomTheme;
import oracle.sdovis.CustomImageRenderer;
import oracle.sdovis.CustomLogo;
import oracle.sdovis.DataException;
import oracle.sdovis.GeoRasterTheme;
import oracle.sdovis.GlobalVisContext;
import oracle.sdovis.ImageTheme;
import oracle.sdovis.Legend;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.RenderingEngine;
import oracle.sdovis.SRS;
import oracle.sdovis.ShadedReliefTheme;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeList;
import oracle.sdovis.VisConstants;
import oracle.sdovis.VisContext;
import oracle.sdovis.VisException;
import oracle.sdovis.WMSMapTheme;
import oracle.sdovis.WMTSTheme;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.theme.CustomGeomThemeDefinition;
import oracle.sdovis.theme.GeoRasterThemeProducer;
import oracle.sdovis.theme.ImageThemeDefinition;
import oracle.sdovis.theme.ImageThemeProducer;
import oracle.sdovis.theme.WMSMapThemeProducer;
import oracle.sdovis.theme.WMTSThemeProducer;
import oracle.sdovis.util.GIFMaker;
import oracle.sdovis.util.Util;

public class MapMaker
implements VisConstants {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static String[] POSITIONS = new String[]{"NORTH", "EAST", "SOUTH", "WEST", "NORTH_EAST", "SOUTH_EAST", "SOUTH_WEST", "NORTH_WEST", "CENTER"};
    static String MAP_TABLE = "USER_SDO_MAPS";
    static String THEME_TABLE = "USER_SDO_THEMES";
    static String STYLE_TABLE = "USER_SDO_STYLES";
    static final int STYLE_CACHE_LIMIT = 9999;
    public static final AffineTransform idTransform = new AffineTransform();
    protected VisContext vc = null;
    RenderingEngine mRenderEng;
    StyleCache defaultStyleCache = new StyleCache(null, 999);

    public MapMaker() {
        this.vc = new VisContext();
        this.vc.setSrs(new SRS());
        try {
            this.vc.setDeviceWindow(new Rectangle2D.Double(0.0, 0.0, 500.0, 375.0));
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.mRenderEng = new RenderingEngine();
        this.mRenderEng.setMapper(this);
    }

    public String getMasterDataSource() {
        return this.vc.getMasterDataSourceName();
    }

    public void setMasterDataSource(String dsrc) {
        this.vc.setMasterDataSourceName(dsrc);
    }

    public int getMasterSrid() {
        return this.vc.getMasterSRID();
    }

    public void setMasterSRID(int s) {
        this.vc.setMasterSRID(s);
    }

    public RenderingEngine getRenderingEngine() {
        return this.mRenderEng;
    }

    public void setInterrupted(boolean interrupted) {
        this.vc.setInterrupted(interrupted);
    }

    public boolean isInterrupted() {
        return this.vc.isInterrupted();
    }

    public String getMapTitle() {
        return this.vc.getTitle();
    }

    public void setMapTitle(String t) {
        this.vc.setTitle(t);
    }

    public Style getMapTitleStyle() {
        return this.vc.getTitleStyle();
    }

    public String getMapTitlePosition() {
        return this.vc.getTitlePos();
    }

    public static void setGlobalMapTitle(String t) {
        GlobalVisContext.setGlobalMapTitle(t);
    }

    public static String getGlobalMapTitle() {
        return GlobalVisContext.getGlobalMapTitle();
    }

    public static void setGlobalMapTitleFont(String name) {
        GlobalVisContext.setGlobalMapTitleFont(name);
    }

    public static String getGlobalMaptitleFont() {
        return GlobalVisContext.getGlobalMaptitleFont();
    }

    public static void setGlobalMapTitlePos(String pos) {
        GlobalVisContext.setGlobalMapTitlePos(pos);
    }

    public static String getGlobalMapTitlePos() {
        return GlobalVisContext.getGlobalMapTitlePos();
    }

    public static void setGlobalMapFootnote(String t) {
        GlobalVisContext.setGlobalMapFootnote(t);
    }

    public static String getGlobalMapFootnote() {
        return GlobalVisContext.getGlobalMapFootnote();
    }

    public static void setGlobalMapFootnoteFont(String name) {
        GlobalVisContext.setGlobalMapFootnoteFont(name);
    }

    public static String getGlobalMapFootnoteFont() {
        return GlobalVisContext.getGlobalMapFootnoteFont();
    }

    public static void setGlobalMapFootnotePos(String pos) {
        GlobalVisContext.setGlobalMapFootnotePos(pos);
    }

    public static String getGlobalMapFootnotePos() {
        return GlobalVisContext.getGlobalMapFootnotePos();
    }

    public VisContext getVisContext() {
        return this.vc;
    }

    public void setMapTitleStyle(StyleText style, String pos) {
        this.vc.setTitleStyle(style);
        this.vc.setTitlePos(pos);
    }

    public void setMapTitleStyleName(String name) {
        this.vc.setTitleStyleName(name);
    }

    public void setMapTitlePosition(String pos) {
        this.vc.setTitlePos(pos);
    }

    public static boolean isValidPosition(String pos) {
        for (int i = 0; i < POSITIONS.length; ++i) {
            if (!POSITIONS[i].equals(pos)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        this.vc.reset();
    }

    public String getMapFootNote() {
        return this.vc.getFootnote();
    }

    public Style getMapFootNoteStyle() {
        return this.vc.getFootnoteStyle();
    }

    public String getMapFootNotePosition() {
        return this.vc.getFootnotePos();
    }

    public void setMapFootNote(String footnote) {
        this.vc.setFootnote(footnote);
    }

    public void setMapFootNoteStyleName(String name) {
        this.vc.setFootnoteStyleName(name);
    }

    public void setMapFootNoteStyle(StyleText style, String pos) {
        this.vc.setFootnoteStyle(style);
        this.vc.setFootnotePos(pos);
    }

    public void setMapFootNotePosition(String pos) {
        this.vc.setFootnotePos(pos);
    }

    public static void setGlobalCustomLogo(String file, String position) {
        try {
            GlobalVisContext.setLogo(new CustomLogo(file, position));
        }
        catch (Exception e) {
            log.severe("error setting global logo");
        }
    }

    public static Image getGlobalCustomLogo() {
        CustomLogo logo = GlobalVisContext.getLogo();
        return logo != null ? logo.getLogo() : null;
    }

    public static String getGlobalCustomLogoPosition() {
        CustomLogo logo = GlobalVisContext.getLogo();
        return logo != null ? logo.getPositionHint() : null;
    }

    public Color getBackgroundColor() {
        return this.vc.getBgColor();
    }

    public void setBackgroundColor(Color c) {
        this.vc.setBgColor(c);
    }

    public Image getBackgroundImage() {
        return this.vc.getBgImage();
    }

    public void setBackgroundImage(Image i) {
        this.vc.setBgImage(i);
    }

    public static boolean getGeomReoriented() {
        return GlobalVisContext.getReorientGeomOridnates();
    }

    public static void setGeomReoriented(boolean v) {
        GlobalVisContext.setReorientGeomOrdinates(v);
    }

    public static double computeScale(double dataWindowSize, int deviceSize, double dpi) {
        double inches = (double)deviceSize / dpi;
        return dataWindowSize / inches;
    }

    public void setQueryWindow(double xl, double yl, double xh, double yh) {
        this.vc.setQueryWindow(new Rectangle2D.Double(xl, yl, xh - xl, yh - yl));
    }

    public void setFullExtent() {
        this.vc.setQueryWindow(new Rectangle2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    public Rectangle2D getQueryWindow() {
        return this.vc.getQueryWindow();
    }

    public Point2D getCenter() {
        Rectangle2D mQueryWin = this.vc.getQueryWindow();
        return mQueryWin != null ? new Point2D.Double(mQueryWin.getMinX() + mQueryWin.getWidth() / 2.0, mQueryWin.getMinY() + mQueryWin.getHeight() / 2.0) : null;
    }

    public void setAntiAliasing(boolean v) {
        this.vc.setAntialiasing(v);
    }

    public void setImageScaling(boolean v) {
        this.vc.setImageScaling(v);
    }

    public boolean getImageScaling() {
        return this.vc.getImageScaling();
    }

    public boolean getAntiAliasing() {
        return this.vc.getAntialiasing();
    }

    public void setTextAntialiasing(boolean v) {
        this.vc.setTextAntialiasing(v);
    }

    public boolean getTextAntialiasing() {
        return this.vc.getTextAntialiasing();
    }

    public boolean getTransparent() {
        return this.vc.getTransparent();
    }

    public void setTransparent(boolean v) {
        this.vc.setTransparent(v);
    }

    public boolean getBBox() {
        return this.vc.getBBox();
    }

    public void setBBox(boolean v) {
        this.vc.setBBox(v);
    }

    public void setImageType(int imgType) {
        try {
            this.vc.setImageType(imgType);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public int getImageType() {
        return this.vc.getImageType();
    }

    public int getDeviceWidth() {
        Rectangle2D r2d = this.vc.getDeviceWindow();
        double w = r2d.getWidth();
        return (int)w;
    }

    public int getDeviceHeight() {
        return (int)this.vc.getDeviceWindow().getHeight();
    }

    public void setDeviceSize(double xl, double yl, double xh, double yh) {
        int w = (int)(xh - xl);
        int h = (int)(yh - yl);
        try {
            this.vc.setDeviceWindow(new Rectangle2D.Double(xl, yl, w, h));
        }
        catch (VisException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setDeviceSize2(double xl, double yl, double xh, double yh) throws VisException {
        int w = (int)(xh - xl);
        int h = (int)(yh - yl);
        this.vc.setDeviceWindow(new Rectangle2D.Double(xl, yl, w, h));
    }

    public void setNoQuery(boolean v) {
        this.vc.setNoQuery(v);
    }

    public boolean getNoQuery() {
        return this.vc.getNoQuery();
    }

    public void setLegend(Legend l) {
        this.vc.setLegend(l);
    }

    public Legend getLegend() {
        return this.vc.getLegend();
    }

    public int addTheme(Theme t) {
        return this.vc.getThemeList().addTheme(t);
    }

    public void addTheme(Theme t, int pos) {
        this.vc.getThemeList().addTheme(t, pos);
    }

    public void removeTheme(int pos) {
        this.vc.getThemeList().removeTheme(pos);
    }

    public void removeAllThemes() {
        this.vc.getThemeList().clear();
    }

    public Theme getTheme(int pos) {
        return this.vc.getThemeList().getTheme(pos);
    }

    public Theme getTheme(String name) {
        return this.vc.getThemeList().getTheme(name);
    }

    public Vector getThemes() {
        return this.vc.getThemeList().getThemes();
    }

    public void setThemes(Collection c) {
        this.vc.getThemeList().setThemes(c);
    }

    public int getNumThemes() {
        return this.vc.getThemeList().size();
    }

    public void moveThemeUp(int pos) {
        this.vc.getThemeList().moveThemeUp(pos);
    }

    public void moveThemeDown(int pos) {
        this.vc.getThemeList().moveThemeDown(pos);
    }

    public void zoomIn(double factor, Graphics2D g2) throws DataException {
        Rectangle2D mQueryWin = this.vc.getQueryWindow();
        if (mQueryWin == null) {
            return;
        }
        double xl = mQueryWin.getMinX();
        double yl = mQueryWin.getMinY();
        double xh = mQueryWin.getMaxX();
        double yh = mQueryWin.getMaxY();
        if (MapMaker.isSpecial(mQueryWin)) {
            return;
        }
        if (factor <= 1.0) {
            return;
        }
        double cx = mQueryWin.getCenterX();
        double cy = mQueryWin.getCenterY();
        double halfWidth = mQueryWin.getWidth() / (factor * 2.0);
        double halfHeight = mQueryWin.getHeight() / (factor * 2.0);
        xl = cx - halfWidth;
        xh = cx + halfWidth;
        yl = cy - halfHeight;
        yh = cy + halfHeight;
        Theme t = this.vc.getThemeList().getTheme(0);
        if (t != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        mQueryWin = this.vc.getSrs().getOptimalQueryWindow(xl, yl, xh, yh, this.vc.getDeviceWindow(), this.vc);
        this.vc.setQueryWindow(mQueryWin);
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        if (g2 == null) {
            g2 = (Graphics2D)this.vc.getMapImage().getGraphics();
            this.renderEm(g2);
            g2.dispose();
        } else {
            this.renderEm(g2);
        }
    }

    public Image zoomIn(double factor) throws DataException {
        this.zoomIn(factor, null);
        return this.vc.getMapImage();
    }

    public void zoomIn(double factor, int deviceX, int deviceY, Graphics2D g2) throws DataException {
        Rectangle2D mQueryWin = this.vc.getQueryWindow();
        Rectangle2D mDeviceWin = this.vc.getDeviceWindow();
        if (mQueryWin == null || mDeviceWin == null) {
            return;
        }
        double xl = mQueryWin.getMinX();
        double yl = mQueryWin.getMinY();
        double xh = mQueryWin.getMaxX();
        double yh = mQueryWin.getMaxY();
        double dev_xl = mDeviceWin.getMinX();
        double dev_yl = mDeviceWin.getMinY();
        double dev_xh = mDeviceWin.getMaxX();
        double dev_yh = mDeviceWin.getMaxY();
        if (MapMaker.isSpecial(mQueryWin)) {
            return;
        }
        if ((double)deviceX < dev_xl || (double)deviceY < dev_yl || (double)deviceX > dev_xh || (double)deviceY > dev_yh) {
            return;
        }
        int[] dc = new int[]{deviceX, deviceY};
        double[] dataC = new double[2];
        if (!this.inverse(dc, dataC)) {
            log.severe("Could not inverse a device coordinate.");
            return;
        }
        double qw = (xh - xl) / 2.0;
        double qh = (yh - yl) / 2.0;
        mQueryWin = new Rectangle2D.Double(dataC[0] - qw, dataC[1] - qh, xh - xl, yh - yl);
        this.vc.setQueryWindow(mQueryWin);
        this.zoomIn(factor, g2);
    }

    public Image zoomIn(double factor, int deviceX, int deviceY) throws DataException {
        this.zoomIn(factor, deviceX, deviceY, null);
        return this.vc.getMapImage();
    }

    public void zoomOut(double factor, Graphics2D g2) throws DataException {
        Rectangle2D mQueryWin = this.vc.getQueryWindow();
        Rectangle2D mDeviceWin = this.vc.getDeviceWindow();
        if (mQueryWin == null) {
            return;
        }
        double xl = mQueryWin.getMinX();
        double yl = mQueryWin.getMinY();
        double xh = mQueryWin.getMaxX();
        double yh = mQueryWin.getMaxY();
        if (MapMaker.isSpecial(mQueryWin)) {
            return;
        }
        if (factor <= 1.0) {
            return;
        }
        double cx = mQueryWin.getCenterX();
        double cy = mQueryWin.getCenterY();
        double halfWidth = (xh - xl) * factor / 2.0;
        double halfHeight = (yh - yl) * factor / 2.0;
        xl = cx - halfWidth;
        xh = cx + halfWidth;
        yl = cy - halfHeight;
        yh = cy + halfHeight;
        Theme t = this.vc.getThemeList().getTheme(0);
        if (t != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        mQueryWin = this.vc.getSrs().getOptimalQueryWindow(xl, yl, xh, yh, mDeviceWin, this.vc);
        this.vc.setQueryWindow(mQueryWin);
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        if (g2 == null) {
            g2 = (Graphics2D)this.vc.getMapImage().getGraphics();
            this.renderEm(g2);
            g2.dispose();
        } else {
            this.renderEm(g2);
        }
    }

    public Image zoomOut(double factor) throws DataException {
        this.zoomOut(factor, null);
        return this.vc.getMapImage();
    }

    public void zoomOut(double factor, int deviceX, int deviceY, Graphics2D g2) throws DataException {
        Rectangle2D mQueryWin = this.vc.getQueryWindow();
        Rectangle2D mDeviceWin = this.vc.getDeviceWindow();
        if (mQueryWin == null || mDeviceWin == null) {
            return;
        }
        double xl = mQueryWin.getMinX();
        double yl = mQueryWin.getMinY();
        double xh = mQueryWin.getMaxX();
        double yh = mQueryWin.getMaxY();
        double dev_xl = mDeviceWin.getMinX();
        double dev_yl = mDeviceWin.getMinY();
        double dev_xh = mDeviceWin.getMaxX();
        double dev_yh = mDeviceWin.getMaxY();
        if (MapMaker.isSpecial(mQueryWin)) {
            return;
        }
        if ((double)deviceX < dev_xl || (double)deviceY < dev_yl || (double)deviceX > dev_xh || (double)deviceY > dev_yh) {
            return;
        }
        int[] dc = new int[]{deviceX, deviceY};
        double[] dataC = new double[2];
        if (!this.inverse(dc, dataC)) {
            log.severe("Could not inverse a device coordinate.");
            return;
        }
        double qw = (xh - xl) / 2.0;
        double qh = (yh - yl) / 2.0;
        mQueryWin = new Rectangle2D.Double(dataC[0] - qw, dataC[1] - qh, xh - xl, yh - yl);
        this.vc.setQueryWindow(mQueryWin);
        this.zoomOut(factor, g2);
    }

    public Image zoomOut(double factor, int deviceX, int deviceY) throws DataException {
        this.zoomOut(factor, deviceX, deviceY, null);
        return this.vc.getMapImage();
    }

    public void pan(int deviceX, int deviceY, Graphics2D g2) throws DataException {
        Rectangle2D mQueryWin = this.vc.getQueryWindow();
        Rectangle2D mDeviceWin = this.vc.getDeviceWindow();
        if (mQueryWin == null || mDeviceWin == null) {
            return;
        }
        double xl = mQueryWin.getMinX();
        double yl = mQueryWin.getMinY();
        double xh = mQueryWin.getMaxX();
        double yh = mQueryWin.getMaxY();
        double dev_xl = mDeviceWin.getMinX();
        double dev_yl = mDeviceWin.getMinY();
        double dev_xh = mDeviceWin.getMaxX();
        double dev_yh = mDeviceWin.getMaxY();
        if (MapMaker.isSpecial(mQueryWin)) {
            return;
        }
        int[] dc = new int[]{deviceX, deviceY};
        double[] dataC = new double[2];
        if (!this.inverse(dc, dataC)) {
            log.severe("Could not inverse a device coordinate.");
            return;
        }
        double qw = (xh - xl) / 2.0;
        double qh = (yh - yl) / 2.0;
        Theme t = this.vc.getThemeList().getTheme(0);
        if (t != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        mQueryWin = this.vc.getSrs().getOptimalQueryWindow(dataC[0] - qw, dataC[1] - qh, dataC[0] + qw, dataC[1] + qh, mDeviceWin, this.vc);
        this.vc.setQueryWindow(mQueryWin);
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        if (g2 == null) {
            g2 = (Graphics2D)this.vc.getMapImage().getGraphics();
            this.renderEm(g2);
            g2.dispose();
        } else {
            this.renderEm(g2);
        }
    }

    public Image pan(int deviceX, int deviceY) throws DataException {
        this.pan(deviceX, deviceY, null);
        return this.vc.getMapImage();
    }

    StyleCache pickStyleCache(String dataSrc) {
        if (this.vc.getTemporaryStyleCache() != null) {
            return this.vc.getTemporaryStyleCache();
        }
        DataSourceI ds = DSManager.get(dataSrc);
        if (ds == null) {
            return this.defaultStyleCache;
        }
        return ds.getStyleCache();
    }

    public HashMap getCachedStyles() {
        StyleCache mStyleCache = this.pickStyleCache(this.vc.getMasterDataSourceName());
        return new HashMap(mStyleCache.getAllStyles());
    }

    public void removeAllCachedStyles() {
        StyleCache sc = this.pickStyleCache(this.vc.getMasterDataSourceName());
        if (sc != null) {
            sc.removeAll();
        }
    }

    public void addStyleToCache(Style sty, String name) {
        StyleCache mStyleCache = this.pickStyleCache(this.vc.getMasterDataSourceName());
        if (mStyleCache != null) {
            mStyleCache.put(name, sty);
        }
    }

    public void deleteStyleFromCache(String name) {
        StyleCache mStyleCache = this.pickStyleCache(this.vc.getMasterDataSourceName());
        if (mStyleCache != null) {
            mStyleCache.remove(name);
        }
    }

    public Style getStyleWithName(String name) {
        if (name == null) {
            return null;
        }
        Style sty = this.vc.getDynamicStyle(name);
        if (sty != null) {
            return sty;
        }
        StyleCache mStyleCache = this.pickStyleCache(this.vc.getMasterDataSourceName());
        if (mStyleCache != null) {
            sty = mStyleCache.get(name);
        }
        return sty;
    }

    public static Style getStyleWithName(String name, String dataSrc, VisContext vc) {
        if (name == null) {
            return null;
        }
        Style sty = null;
        if (vc != null && (sty = vc.getDynamicStyle(name)) != null) {
            return sty;
        }
        if (dataSrc == null) {
            log.severe("data src name is null in getStyleWithName().");
            return null;
        }
        try {
            StyleCache mStyleCache = DSManager.get(dataSrc).getStyleCache();
            if (vc.getTemporaryStyleCache() != null) {
                mStyleCache = vc.getTemporaryStyleCache();
            }
            return mStyleCache.get(name);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    public boolean styleExists(String name) {
        StyleCache mStyleCache = this.pickStyleCache(this.vc.getMasterDataSourceName());
        Style sty = null;
        if (mStyleCache != null) {
            sty = mStyleCache.get(name);
        }
        return sty != null;
    }

    public SRS getSRS() {
        return this.vc.getSrs();
    }

    public Image renderMap(double xl, double yl, double xh, double yh) throws DataException {
        Theme t;
        this.vc.setBBox(true);
        int numThemes = this.getNumThemes();
        if (numThemes == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            log.finest("paint a blank image.");
            return this.getBlankImg(this.vc.getMapImage());
        }
        log.finest("Number of themes: " + numThemes);
        SRS mSRS = this.vc.getSrs();
        if ((mSRS == null || mSRS.getSRID() < 1) && (t = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        mSRS = this.vc.getSrs();
        this.vc.setQueryWindow(mSRS.getOptimalQueryWindow(xl, yl, xh, yh, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        Graphics2D g2 = (Graphics2D)this.vc.getMapImage().getGraphics();
        Image im = this.renderEm(g2);
        g2.dispose();
        return im;
    }

    public Image renderMap() throws DataException {
        Theme t;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            log.finest("paint a blank image.");
            return this.getBlankImg(this.vc.getMapImage());
        }
        SRS mSRS = this.vc.getSrs();
        if ((mSRS == null || mSRS.getSRID() < 1) && (t = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        this.setQueryWindow(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Graphics2D g2 = (Graphics2D)this.vc.getMapImage().getGraphics();
        Image im = this.renderEm(g2);
        g2.dispose();
        return im;
    }

    public void renderMap(Graphics2D g2) throws DataException {
        Theme t;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            log.finest("paint a blank image.");
            this.paintBlankImg(g2);
            return;
        }
        SRS mSRS = this.vc.getSrs();
        if ((mSRS == null || mSRS.getSRID() < 1) && (t = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        this.setQueryWindow(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.renderEm(g2);
    }

    public Image renderMap(Rectangle2D window) throws DataException {
        Theme t;
        if (window == null) {
            return this.renderMap();
        }
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            log.finest("paint a blank image.");
            return this.getBlankImg(this.vc.getMapImage());
        }
        SRS mSRS = this.vc.getSrs();
        if ((mSRS == null || mSRS.getSRID() < 1) && (t = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        this.setQueryWindow(window.getMinX(), window.getMinY(), window.getMaxX(), window.getMaxY());
        Graphics2D g2 = (Graphics2D)this.vc.getMapImage().getGraphics();
        Image im = this.renderEm(g2);
        g2.dispose();
        return im;
    }

    public void renderMap(double xl, double yl, double xh, double yh, Graphics2D g2) throws DataException {
        Theme t;
        this.vc.setBBox(true);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            log.finest("paint a blank image.");
            this.paintBlankImg(g2);
            return;
        }
        SRS mSRS = this.vc.getSrs();
        if ((mSRS == null || mSRS.getSRID() < 1) && (t = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        mSRS = this.vc.getSrs();
        this.vc.setQueryWindow(mSRS.getOptimalQueryWindow(xl, yl, xh, yh, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        this.renderEm(g2);
    }

    public void renderMapToFile(double xl, double yl, double xh, double yh, String filePath) throws DataException {
        this.vc.setBBox(true);
        Image img = null;
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            log.finest("paint a blank image.");
            img = this.getBlankImg(this.vc.getMapImage());
        } else {
            img = this.renderMap(xl, yl, xh, yh);
        }
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            GIFMaker gifM = new GIFMaker(fos);
            gifM.encode((BufferedImage)img);
            fos.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void renderMapToFile(String filePath) throws DataException {
        this.vc.setBBox(false);
        Image img = null;
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            log.finest("paint a blank image.");
            img = this.getBlankImg(this.vc.getMapImage());
        } else {
            Theme t = this.vc.getThemeList().getTheme(0);
            if (t != null) {
                this.vc.setMasterSRID(t.getSRID());
            }
            this.setQueryWindow(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            Graphics2D g2 = (Graphics2D)this.vc.getMapImage().getGraphics();
            img = this.renderEm(g2);
            g2.dispose();
        }
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            GIFMaker gifM = new GIFMaker(fos);
            gifM.encode((BufferedImage)img);
            fos.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Image renderMap(double cx, double cy, double size) throws DataException {
        Theme t;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            log.finest("paint a blank image.");
            return this.getBlankImg(this.vc.getMapImage());
        }
        SRS mSRS = this.vc.getSrs();
        if ((mSRS == null || mSRS.getSRID() < 1) && (t = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        mSRS = this.vc.getSrs();
        this.vc.setQueryWindow(mSRS.getOptimalQueryWindow(cx, cy, size, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        Graphics2D g2 = (Graphics2D)this.vc.getMapImage().getGraphics();
        this.renderEm(g2);
        g2.dispose();
        return this.vc.getMapImage();
    }

    public void renderMap(double cx, double cy, double size, Graphics2D g2) throws DataException {
        Theme t;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            log.finest("paint a blank image.");
            this.paintBlankImg(g2);
            return;
        }
        SRS mSRS = this.vc.getSrs();
        if ((mSRS == null || mSRS.getSRID() < 1) && (t = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        mSRS = this.vc.getSrs();
        this.vc.setQueryWindow(mSRS.getOptimalQueryWindow(cx, cy, size, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        this.renderEm(g2);
    }

    public Image renderMapWithScale(double cx, double cy, long scale) throws DataException {
        Theme t;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            log.finest("paint a blank image.");
            return this.getBlankImg(this.vc.getMapImage());
        }
        SRS mSRS = this.vc.getSrs();
        if ((mSRS == null || mSRS.getSRID() < 1) && (t = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        if ((mSRS = this.vc.getSrs()) == null) {
            log.info("Can not use ratio scale on a map without SRS.");
            return this.getBlankImg(this.vc.getMapImage());
        }
        double screeninchScale = mSRS.getScreenInchScale(scale, new Point2D.Double(cx, cy));
        log.finer("Screen inches scale: " + screeninchScale);
        if (screeninchScale == -1.0) {
            log.info("Can not convert ratio scale on a map with SRID = " + mSRS.getSRID());
            return this.getBlankImg(this.vc.getMapImage());
        }
        double size = screeninchScale * this.vc.getDeviceWindow().getHeight() / this.vc.getDPI();
        this.vc.setQueryWindow(mSRS.getOptimalQueryWindow(cx, cy, size, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        Graphics2D g2 = (Graphics2D)this.vc.getMapImage().getGraphics();
        this.renderEm(g2);
        g2.dispose();
        return this.vc.getMapImage();
    }

    public void renderMapWithScale(double cx, double cy, long scale, Graphics2D g2) throws DataException {
        Theme t;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            log.finest("paint a blank image.");
            this.paintBlankImg(g2);
            return;
        }
        SRS mSRS = this.vc.getSrs();
        if ((mSRS == null || mSRS.getSRID() < 1) && (t = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        if ((mSRS = this.vc.getSrs()) == null) {
            log.info("Can not use ratio scale on a map without SRS.");
            return;
        }
        log.finer("Ratio scale: " + scale);
        double screeninchScale = mSRS.getScreenInchScale(scale, new Point2D.Double(cx, cy));
        log.finer("Screen inches scale: " + screeninchScale);
        if (screeninchScale == -1.0) {
            log.info("Can not convert ratio scale on a map with SRID = " + mSRS.getSRID());
            return;
        }
        double size = screeninchScale * this.vc.getDeviceWindow().getHeight() / this.vc.getDPI();
        log.finer("Map Size: " + size);
        this.vc.setQueryWindow(mSRS.getOptimalQueryWindow(cx, cy, size, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        this.renderEm(g2);
    }

    public boolean inverse(int[] screenCoord, double[] dataCoord) {
        Proj prj;
        if (this.mRenderEng == null) {
            return false;
        }
        XFViewPort xfv = this.vc.getViewportTransform();
        if (xfv == null) {
            return false;
        }
        if (!xfv.inverse(screenCoord, dataCoord)) {
            return false;
        }
        if (this.vc.getLastRotation() != 0.0) {
            Point2D pt = Util.rotatePoint(dataCoord[0], dataCoord[1], this.vc.getQueryWindow().getCenterX(), this.vc.getQueryWindow().getCenterY(), this.vc.getLastRotation() * -1.0);
            dataCoord[0] = pt.getX();
            dataCoord[1] = pt.getY();
        }
        if ((prj = this.vc.getProjection()) != null) {
            Proj.P2 p = new Proj.P2();
            if (!prj.inverse(dataCoord[0], dataCoord[1], p)) {
                log.severe("Projection cannot inverse transform the coordinates.");
                return false;
            }
            dataCoord[0] = p.x;
            dataCoord[1] = p.y;
            return true;
        }
        return true;
    }

    public String getViewPortTransformInfo() {
        return this.vc.getViewportTransform().toString();
    }

    public static synchronized void addCustomImageRenderer(CustomImageRenderer cir, String format) {
        GlobalVisContext.addCustomImageRenderer(format, cir);
        log.info("added a custom image renderer for " + format);
    }

    public static CustomImageRenderer findCustomImageRenderer(String format) {
        return GlobalVisContext.findCustomImageRenderer(format);
    }

    public Vector getLiveFeatureVector() {
        return this.vc.getLiveFeatures();
    }

    public void addLiveFeature(StyledFeatureI sf) {
        this.vc.addLiveFeature(sf);
    }

    public void clearLiveFeatures() {
        this.vc.clearLiveFeatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image renderEm(Graphics2D g2) throws DataException {
        long t1 = System.currentTimeMillis();
        if (MapMaker.isSpecial(this.vc.getQueryWindow())) {
            this.clearRotation();
        }
        this.vc.setInterrupted(false);
        this.vc.setScale(this.vc.getQueryWindow(), this.vc.getDeviceWindow());
        try {
            if (!this.vc.getNoQuery()) {
                for (int i = 0; i < this.vc.getThemeList().size(); ++i) {
                    Theme t = this.vc.getThemeList().getTheme(i);
                    if (t.getDecorator().isPrepared() || !t.withinRenderScaleLimits(this.vc.getCurrentScale())) continue;
                    t.prepareData(this.vc.getQueryWindow(), this.vc);
                    t.postPreparation(this.vc);
                }
            }
        }
        finally {
            this.vc.setNoQuery(false);
        }
        if (MapMaker.isSpecial(this.vc.getQueryWindow())) {
            this.vc.setQueryWindow(this.buildDataMBR());
            this.vc.setScale(this.vc.getQueryWindow(), this.vc.getDeviceWindow());
        }
        if (this.vc.getMapCache() != null) {
            MapCache cache = this.vc.getMapCache();
            Rectangle2D mapWindow = cache.getMapBoundingBox(this.vc.getQueryWindow(), (int)this.vc.getDeviceWindow().getWidth(), (int)this.vc.getDeviceWindow().getHeight(), !this.vc.snapToCachedScale(), "unbiased");
            Image cachedImage = null;
            if (mapWindow != null) {
                try {
                    cachedImage = cache.getMap(mapWindow, (int)this.vc.getDeviceWindow().getWidth(), (int)this.vc.getDeviceWindow().getHeight(), "unbiased");
                }
                catch (Exception e) {
                    log.warning("Failed to generated cached base map!");
                    log.log(Level.WARNING, e.getMessage(), e);
                }
            }
            if (cachedImage != null) {
                this.vc.setQueryWindow(mapWindow);
                g2.drawImage(cachedImage, 0, 0, null);
                this.vc.removeBaseMapThemes();
            }
        }
        long t2 = System.currentTimeMillis();
        long mLoadTime = t2 - t1;
        log.info(" **** time spent on loading features: " + mLoadTime + "ms.");
        t1 = System.currentTimeMillis();
        this.mRenderEng.render(g2, this.vc);
        t2 = System.currentTimeMillis();
        long mRenderTime = t2 - t1;
        log.info(" **** time spent on rendering: " + mRenderTime + "ms");
        this.vc.setLastRotation(this.vc.getRotation());
        return this.vc.getMapImage();
    }

    protected Rectangle2D buildDataMBR() {
        Theme t = null;
        RectangularShape newMBR = null;
        double percent = 0.05;
        ThemeList mThemes = this.vc.getThemeList();
        for (int i = 0; i < mThemes.size(); ++i) {
            t = mThemes.getTheme(i);
            double[] tmbr = t.getDataMBR();
            if (tmbr == null) continue;
            if (newMBR == null) {
                newMBR = new Rectangle2D.Double(tmbr[0], tmbr[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)newMBR).add(tmbr[0], tmbr[1]);
            }
            ((Rectangle2D)newMBR).add(tmbr[2], tmbr[3]);
        }
        if (newMBR == null) {
            log.warning("null MBR resulted from buildDataMBR.");
            return null;
        }
        double xl = newMBR.getMinX();
        double yl = newMBR.getMinY();
        double xh = newMBR.getMaxX();
        double yh = newMBR.getMaxY();
        if (yl == yh) {
            if (xl == xh) {
                xl -= 0.05;
                yl -= 0.05;
                xh += 0.05;
                yh += 0.05;
            } else {
                xl -= (xh - xl) * percent;
                yl -= (xh - xl) * percent;
                xh += (xh - xl) * percent;
                yh += (xh - xl) * percent;
            }
        } else if (xl == xh) {
            if (yl == yh) {
                xl -= 0.05;
                yl -= 0.05;
                xh += 0.05;
                yh += 0.05;
            } else {
                xl -= (yh - yl) * percent;
                yl -= (yh - yl) * percent;
                xh += (yh - yl) * percent;
                yh += (yh - yl) * percent;
            }
        } else {
            xl -= (xh - xl) * percent;
            yl -= (yh - yl) * percent;
            xh += (xh - xl) * percent;
            yh += (yh - yl) * percent;
        }
        ((Rectangle2D)newMBR).add(xl, yl);
        ((Rectangle2D)newMBR).add(xh, yh);
        log.finest("mbr of all themes: " + newMBR);
        return newMBR;
    }

    protected Rectangle2D buildDataMBR(String[] themes, float borderMargin, boolean keepAspectRatio, Rectangle2D deviceWin) {
        Theme t = null;
        RectangularShape newMBR = null;
        double percent = borderMargin;
        ThemeList mThemes = this.vc.getThemeList();
        for (int i = 0; i < themes.length; ++i) {
            double[] tmbr;
            t = mThemes.getLastMatchingTheme(themes[i]);
            if (t == null || (tmbr = t.getDataMBR()) == null) continue;
            if (newMBR == null) {
                newMBR = new Rectangle2D.Double(tmbr[0], tmbr[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)newMBR).add(tmbr[0], tmbr[1]);
            }
            ((Rectangle2D)newMBR).add(tmbr[2], tmbr[3]);
        }
        if (newMBR == null) {
            log.warning("Null MBR resulted from buildDataMBR(themes).");
            return null;
        }
        double xl = newMBR.getMinX();
        double yl = newMBR.getMinY();
        double xh = newMBR.getMaxX();
        double yh = newMBR.getMaxY();
        double h = Math.abs(yh - yl);
        double w = Math.abs(xh - xl);
        if (keepAspectRatio) {
            double r2 = w / h;
            double r1 = deviceWin.getWidth() / deviceWin.getHeight();
            if (r2 > r1) {
                h = w / r1;
            } else if (r2 < r1) {
                w = h * r1;
            }
            double cx = (xl + xh) / 2.0;
            double cy = (yl + yh) / 2.0;
            xl = cx - w / 2.0;
            yl = cy - h / 2.0;
            xh = cx + w / 2.0;
            yh = cy + h / 2.0;
        }
        ((Rectangle2D)newMBR).add(xl -= w * percent, yl -= h * percent);
        ((Rectangle2D)newMBR).add(xh += w * percent, yh += h * percent);
        log.finest("mbr of all bounding themes: " + newMBR);
        return newMBR;
    }

    protected Rectangle2D buildDataMBR(String[] themes, double sizeHint, float borderMargin, boolean keepAspectRatio, Rectangle2D deviceWin) {
        if (sizeHint <= 0.0) {
            return this.buildDataMBR(themes, borderMargin, keepAspectRatio, deviceWin);
        }
        Theme t = null;
        RectangularShape newMBR = null;
        double percent = borderMargin;
        ThemeList mThemes = this.vc.getThemeList();
        for (int i = 0; i < themes.length; ++i) {
            double[] tmbr;
            t = mThemes.getLastMatchingTheme(themes[i]);
            if (t == null || (tmbr = t.getDataMBR()) == null) continue;
            if (newMBR == null) {
                newMBR = new Rectangle2D.Double(tmbr[0], tmbr[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)newMBR).add(tmbr[0], tmbr[1]);
            }
            ((Rectangle2D)newMBR).add(tmbr[2], tmbr[3]);
        }
        if (newMBR == null) {
            log.warning("Null MBR resulted from buildDataMBR(themes).");
            return null;
        }
        double xl = newMBR.getMinX();
        double yl = newMBR.getMinY();
        double xh = newMBR.getMaxX();
        double yh = newMBR.getMaxY();
        double h = Math.abs(yh - yl);
        double w = Math.abs(xh - xl);
        if (h == 0.0 || w == 0.0) {
            log.finer("Applying mbr size");
            double center_X = xl + w / 2.0;
            double center_Y = yl + h / 2.0;
            xl = center_X - sizeHint / 2.0;
            xh = center_X + sizeHint / 2.0;
            yl = center_Y - sizeHint / 2.0;
            yh = center_Y + sizeHint / 2.0;
            h = sizeHint;
            w = sizeHint;
        }
        if (keepAspectRatio) {
            double r2 = w / h;
            double r1 = deviceWin.getWidth() / deviceWin.getHeight();
            if (r2 > r1) {
                h = w / r1;
            } else if (r2 < r1) {
                w = h * r1;
            }
            double cx = (xl + xh) / 2.0;
            double cy = (yl + yh) / 2.0;
            xl = cx - w / 2.0;
            yl = cy - h / 2.0;
            xh = cx + w / 2.0;
            yh = cy + h / 2.0;
        }
        ((Rectangle2D)newMBR).add(xl -= w * percent, yl -= h * percent);
        ((Rectangle2D)newMBR).add(xh += w * percent, yh += h * percent);
        log.finest("mbr of all bounding themes: " + newMBR);
        return newMBR;
    }

    public AffineTransform getAffineTransform() {
        return this.vc.getAffineXF();
    }

    public void setAffineTransform(AffineTransform af) {
        this.vc.setAffineXF(af);
    }

    public static final boolean isSpecial(Rectangle2D rect) {
        if (Double.isInfinite(rect.getWidth()) || Double.isNaN(rect.getWidth()) || Double.isInfinite(rect.getHeight()) || Double.isNaN(rect.getHeight())) {
            return true;
        }
        return MapMaker.isSpecial(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY());
    }

    public static final boolean isSpecial(double xl, double yl, double xh, double yh) {
        return Double.isInfinite(xl) || Double.isNaN(xl) || Double.isInfinite(yl) || Double.isNaN(yl) || Double.isInfinite(xh) || Double.isNaN(xh) || Double.isInfinite(yh) || Double.isNaN(yh);
    }

    private Image getBlankImg(Image im) {
        if (this.getLegend() == null) {
            Color c = this.getBackgroundColor();
            if (c == null) {
                c = Color.white;
            }
            Graphics2D g2 = (Graphics2D)im.getGraphics();
            g2.setColor(c);
            Rectangle2D mDeviceWin = this.vc.getDeviceWindow();
            g2.fillRect((int)mDeviceWin.getMinX(), (int)mDeviceWin.getMinY(), (int)(mDeviceWin.getMaxX() - mDeviceWin.getMinX()), (int)(mDeviceWin.getMaxY() - mDeviceWin.getMinY()));
            this.mRenderEng.renderMapTitle(g2, this.vc);
            this.mRenderEng.renderMapFootNote(g2, this.vc);
            g2.dispose();
            return im;
        }
        Legend legend = this.getLegend();
        Rectangle2D r2 = legend.computeMBR();
        BufferedImage mLegendImg = this.vc.getLegendImage();
        if (mLegendImg != null) {
            mLegendImg.flush();
            mLegendImg = null;
        }
        mLegendImg = new BufferedImage((int)r2.getWidth() + 1, (int)r2.getHeight() + 1, this.vc.getImageType());
        Graphics2D g2 = (Graphics2D)mLegendImg.getGraphics();
        legend.paint(g2, 0, 0);
        g2.dispose();
        this.vc.setLegendImage(mLegendImg);
        return mLegendImg;
    }

    private void paintBlankImg(Graphics2D g2) {
        if (g2 == null) {
            return;
        }
        Rectangle2D mDeviceWin = this.vc.getDeviceWindow();
        Image mBackgroundImage = this.vc.getBgImage();
        if (mBackgroundImage != null) {
            g2.drawImage(mBackgroundImage, 0, 0, (int)(mDeviceWin.getMaxX() - mDeviceWin.getMinX()), (int)(mDeviceWin.getMaxY() - mDeviceWin.getMinY()), null);
        } else if (this.getLegend() == null) {
            Color c = this.getBackgroundColor();
            if (c == null) {
                c = Color.white;
            }
            g2.setColor(c);
            g2.fillRect((int)mDeviceWin.getMinX(), (int)mDeviceWin.getMinY(), (int)(mDeviceWin.getMaxX() - mDeviceWin.getMinX()), (int)(mDeviceWin.getMaxY() - mDeviceWin.getMinY()));
            this.mRenderEng.renderMapTitle(g2, this.vc);
            this.mRenderEng.renderMapFootNote(g2, this.vc);
        } else {
            Legend legend = this.getLegend();
            legend.paint(g2, 0, 0);
        }
    }

    public static void setFastUnpickle(boolean v) {
        GlobalVisContext.setFastUnpickle(v);
        if (v) {
            // empty if block
        }
    }

    public static boolean getFastUnpickle() {
        return GlobalVisContext.getFastUnpickle();
    }

    public static void setUGP(boolean v) {
        GlobalVisContext.setUgp(v);
    }

    public static boolean getUGP() {
        return GlobalVisContext.getUgp();
    }

    public static void setLocalAdjustment(boolean v) {
    }

    public static boolean getLocalAdjustment() {
        return false;
    }

    private ImageTheme getImageTheme() {
        ThemeList mThemes = this.vc.getThemeList();
        for (int i = 0; i < mThemes.size(); ++i) {
            Theme t = mThemes.getTheme(i);
            if (!(t instanceof ImageTheme) || !t.withinRenderScaleLimits(this.vc.getCurrentScale())) continue;
            return (ImageTheme)t;
        }
        return null;
    }

    private ShadedReliefTheme getShadedReliefTheme() {
        ThemeList mThemes = this.vc.getThemeList();
        for (int i = 0; i < mThemes.size(); ++i) {
            Theme t = mThemes.getTheme(i);
            if (!(t instanceof ShadedReliefTheme) || !t.withinRenderScaleLimits(this.vc.getCurrentScale())) continue;
            return (ShadedReliefTheme)t;
        }
        return null;
    }

    private GeoRasterTheme getGeoRasterTheme() {
        ThemeList mThemes = this.vc.getThemeList();
        for (int i = 0; i < mThemes.size(); ++i) {
            Theme t = mThemes.getTheme(i);
            if (!(t instanceof GeoRasterTheme) || !t.withinRenderScaleLimits(this.vc.getCurrentScale())) continue;
            return (GeoRasterTheme)t;
        }
        return null;
    }

    private void resizeQueryWindow() {
        try {
            this.vc.setScale(this.vc.getQueryWindow(), this.vc.getDeviceWindow());
            ImageTheme imt = this.getImageTheme();
            if (imt != null) {
                ImageThemeDefinition it = (ImageThemeDefinition)imt.getDefinition();
                if (it.getImageResolution() > 0.0) {
                    double newSize = it.getImageResolution() * this.vc.getDeviceWindow().getHeight();
                    double cx = this.vc.getQueryWindow().getCenterX();
                    double cy = this.vc.getQueryWindow().getCenterY();
                    this.vc.setQueryWindow(this.vc.getSrs().getOptimalQueryWindow(cx, cy, newSize, this.vc.getDeviceWindow(), this.vc));
                } else {
                    log.warning("No image_resolution set for the image theme: " + it.getName());
                    log.warning("Image will be rescaled to fit query window.");
                    this.vc.setImageScaling(true);
                }
            } else {
                GeoRasterTheme gt = this.getGeoRasterTheme();
                if (gt != null) {
                    log.warning("Currently, image scaling set to false has no effect for GeoRaster themes");
                    log.warning("GeoRaster themes will be rescaled to fit query window.");
                    this.vc.setImageScaling(true);
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public static void setShowQueryWindow(boolean v) {
        GlobalVisContext.setShowQueryWindow(v);
    }

    public Theme addCustomGeomTheme(String name, String providerId, Properties runtimeProp, String spatialColumn, String srid, String renderStyle, String labelColumn, String labelStyle, String[] hiddenInfoColumns, String[] hiddenInfoNames, String[] nonSpatialColumns, int pos) {
        name = name.toUpperCase();
        int srid_ = 0;
        try {
            srid_ = Integer.parseInt(srid);
        }
        catch (Exception e) {
            // empty catch block
        }
        CustomGeomThemeDefinition td = new CustomGeomThemeDefinition(name, providerId, runtimeProp, srid_);
        td.setSpatialColumn(spatialColumn);
        td.setFeatureStyleName(renderStyle);
        td.setLabelColumn(labelColumn);
        td.setLabelStyleName(labelStyle);
        td.setRuntimeProperties(runtimeProp);
        if (hiddenInfoColumns != null && hiddenInfoColumns.length > 0) {
            Field[] attrs = new Field[hiddenInfoColumns.length];
            for (int i = 0; i < attrs.length; ++i) {
                Field attr = new Field("").setName(hiddenInfoColumns[i]);
                attr.setDisplayName(hiddenInfoNames[i]);
                attrs[i] = attr;
            }
            td.setIdentifiableColumns(attrs);
        }
        td.setNonSpatialColumns(nonSpatialColumns);
        CustomGeomTheme theme = new CustomGeomTheme(td);
        this.addTheme(theme, pos);
        return theme;
    }

    public void clearRotation() {
        if (this.vc != null) {
            this.vc.setRotation(0.0);
            this.vc.setLastRotation(0.0);
        }
    }

    public String[] getRenderedThemes(boolean includeLocalThemes) {
        if (this.vc == null) {
            return null;
        }
        ThemeList renderThemes = this.vc.getThemeList();
        if (renderThemes == null || renderThemes.size() < 1) {
            return null;
        }
        boolean fullExtent = false;
        Rectangle2D rect = this.vc.getQueryWindow();
        if (rect == null) {
            fullExtent = true;
        } else {
            double xl = rect.getMinX();
            double yl = rect.getMinY();
            double xh = rect.getMaxX();
            double yh = rect.getMaxY();
            fullExtent = Util.isFullExtent(xl, yl, xh, yh);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int l = 0; l < renderThemes.size(); ++l) {
            Rectangle2D.Double threct;
            double[] datambr;
            Theme theme = renderThemes.getTheme(l);
            if (theme instanceof ImageTheme || theme instanceof GeoRasterTheme) {
                double[][] mbrs = null;
                if (theme instanceof ImageTheme) {
                    mbrs = theme instanceof WMTSTheme ? ((WMTSThemeProducer)theme.getProducer()).getMBRs() : ((ImageThemeProducer)theme.getProducer()).getMBRs();
                } else if (theme instanceof GeoRasterTheme) {
                    mbrs = ((GeoRasterThemeProducer)theme.getProducer()).getMBRs();
                }
                if (mbrs == null || mbrs.length <= 0) continue;
                names.add(theme.getName());
                continue;
            }
            if (theme instanceof WMSMapTheme) {
                if (((WMSMapThemeProducer)theme.getProducer()).getWMSMap() == null || ((WMSMapThemeProducer)theme.getProducer()).isErrorImage()) continue;
                names.add(theme.getName());
                continue;
            }
            StyledFeatureI[] feats = theme.getProducer().getStyledFeatures();
            if (feats == null || feats.length <= 0 || theme instanceof LocalTheme && (!includeLocalThemes || !fullExtent && ((datambr = theme.getProducer().getDataMBR()) == null || !rect.intersects(threct = new Rectangle2D.Double(datambr[0], datambr[1], datambr[2] - datambr[0], datambr[3] - datambr[1]))))) continue;
            names.add(theme.getName());
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }
}

