/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.Serializable;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.style.Style;
import oracle.sdovis.util.Util;

public class StyleRowData
implements Serializable {
    public String name = "";
    public String type = null;
    public String description = "";
    public String definition = null;
    public byte[] image = null;
    public Object geometry = null;

    public Style toStyle() {
        if (this.type == null || this.name == null) {
            return null;
        }
        int mType = StyleRowData.getTypeCode(this.type);
        if (mType == 0) {
            return null;
        }
        Style sty = StyleFactory.createStyleObject(mType, this.definition, this.image);
        return sty;
    }

    public String toXmlFileFormat() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("    <style>\n");
        sb.append("        <name>" + this.name.toUpperCase() + "</name>\n");
        sb.append("        <type>" + this.type.toUpperCase() + "</type>\n");
        sb.append("        <description>" + this.description + "</type>\n");
        sb.append("        <definition><!CDATA[" + this.definition + "]]</definition>\n");
        sb.append("        <image>" + Util.base64Encode(this.image) + "</image>\n");
        sb.append("        <geometry/>\n");
        sb.append("    </style>\n");
        return sb.toString();
    }

    public static int getTypeCode(String type) {
        int mType = 0;
        if (type.equalsIgnoreCase("AREA")) {
            mType = 4;
        } else if (type.equalsIgnoreCase("COLOR")) {
            mType = 1;
        } else if (type.equalsIgnoreCase("LINE")) {
            mType = 3;
        } else if (type.equalsIgnoreCase("MARKER")) {
            mType = 2;
        } else if (type.equalsIgnoreCase("TEXT")) {
            mType = 5;
        } else if (type.equalsIgnoreCase("ADVANCED")) {
            mType = 9;
        } else if (type.equalsIgnoreCase("TTF")) {
            mType = 99;
        }
        return mType;
    }
}

