/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.charts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Locale;
import oracle.sdovis.charts.legend.Legend2;
import oracle.sdovis.charts.types.ChartException;
import oracle.sdovis.charts.types.LegendDesc;

public class Chart
extends Component {
    private boolean test = false;
    protected BufferedImage BI = null;
    protected RenderingHints RH = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    protected boolean renderingHintsSet = false;
    protected Legend2 L2 = new Legend2();
    protected Locale ChartLocale = Locale.getDefault();
    protected int border_topbottom_default = 20;
    private int border_bottom = 20;
    private int border_top = 20;
    private int border_left = 10;
    protected int border_right_default;
    private int border_right = this.border_right_default = 10;
    private int border_vert;
    private int border_horz;
    private boolean borderLeftSet = false;
    private boolean borderRightSet = false;
    private boolean borderBottomSet = false;
    private boolean borderTopSet = false;
    private int TotalDisplay_height = 200;
    private int TotalDisplay_width = 300;
    private int lastTotalDisplay_height = 0;
    private int lastTotalDisplay_width = 0;
    Color background = new Color(200, 200, 240);
    Color EdgeColor = Color.black;
    protected int width = 200;
    protected int height = 100;
    private Font titleFont = new Font("sansserif", 1, 14);
    protected ChartLabel t = new ChartLabel("", 4, this.titleFont, 1.8, 1.3);
    private Font subTitleFont = new Font("sansserif", 0, 11);
    protected ChartLabel subt = new ChartLabel("", 4, this.subTitleFont, 1.5, 0.5);
    private Font footnoteFont = new Font("sansserif", 0, 10);
    protected ChartLabel foot = new ChartLabel("", 0, this.footnoteFont, 1.0, 1.0);
    boolean isPieChart = false;

    protected Color getDarkerColor(Color c) {
        Color d = c.darker();
        int r = d.getRed();
        int g = d.getGreen();
        int b = d.getBlue();
        int a = c.getAlpha();
        return new Color(r, g, b, a);
    }

    public void setChartAttributes(LegendDesc userLegendDesc) throws ChartException {
        this.L2.setLegendDesc(userLegendDesc);
    }

    public void setRenderingHintsChart(RenderingHints hints) {
        this.RH = hints;
        this.renderingHintsSet = true;
    }

    public RenderingHints getRenderingHintsChart() {
        return this.RH;
    }

    public boolean isSetRenderingHintsChart() {
        return this.renderingHintsSet;
    }

    protected String getFontStyle(int styleInt) {
        String style = null;
        switch (styleInt) {
            case 1: {
                style = "Font.BOLD";
                break;
            }
            case 2: {
                style = "Font.ITALIC";
                break;
            }
            case 0: {
                style = "Font.PLAIN";
            }
        }
        return style;
    }

    protected String emitFont(Font f) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("setFont(new java.awt.Font(\"");
        sbuf.append(f.getName());
        sbuf.append("\", ");
        int styleInt = f.getStyle();
        String style = this.getFontStyle(styleInt);
        if (style != null) {
            sbuf.append(style);
        } else {
            sbuf.append(styleInt);
        }
        sbuf.append(", ");
        sbuf.append(f.getSize());
        sbuf.append("));\n");
        return sbuf.toString();
    }

    protected String emitTitle() {
        StringBuffer sbuf = new StringBuffer();
        if (this.getTitle().getText() != "") {
            sbuf.append("// Title \n");
            sbuf.append("chs.getTitle().setText(\"");
            sbuf.append(this.getTitle().getText());
            sbuf.append("\");\n");
            sbuf.append("chs.getTitle().");
            sbuf.append(this.emitFont(this.getTitle().getFont()));
        }
        if (this.getSubtitle().getText() != "") {
            sbuf.append("// Subtitle \n");
            sbuf.append("chs.getSubtitle().setText(\"");
            sbuf.append(this.getSubtitle().getText());
            sbuf.append("\");\n");
            sbuf.append("chs.getSubtitle().");
            sbuf.append(this.emitFont(this.getSubtitle().getFont()));
        }
        if (this.getFootnote().getText() != "") {
            sbuf.append("// Footnote \n");
            sbuf.append("chs.getFootnote().setText(\"");
            sbuf.append(this.getFootnote().getText());
            sbuf.append("\");\n");
            sbuf.append("chs.getFootnote().");
            sbuf.append(this.emitFont(this.getFootnote().getFont()));
        }
        return sbuf.toString();
    }

    protected String emitBackground() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("chs.setBackground(");
        sbuf.append(this.emitNewColor(this.getBackground()));
        sbuf.append(");\n");
        return sbuf.toString();
    }

    protected String emitEdgeColor() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("chs.setEdgeColor(");
        sbuf.append(this.emitNewColor(this.getEdgeColor()));
        sbuf.append(");\n");
        return sbuf.toString();
    }

    protected String emitNewColor(Color c) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("new java.awt.Color(");
        sbuf.append(c.getRed());
        sbuf.append(",");
        sbuf.append(c.getGreen());
        sbuf.append(",");
        sbuf.append(c.getBlue());
        sbuf.append(",");
        sbuf.append(c.getAlpha());
        sbuf.append(")");
        return sbuf.toString();
    }

    protected String emitSize() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("chs.setSize(");
        sbuf.append(this.getWidth());
        sbuf.append(",");
        sbuf.append(this.getHeight());
        sbuf.append(");\n");
        return sbuf.toString();
    }

    protected String emitBorders() {
        StringBuffer sbuf = new StringBuffer();
        if (this.isBorderTopSet()) {
            sbuf.append("chs.setBorderTop(");
            sbuf.append(this.getBorderTop());
            sbuf.append(");\n");
        }
        if (this.isBorderBottomSet()) {
            sbuf.append("chs.setBorderBottom(");
            sbuf.append(this.getBorderBottom());
            sbuf.append(");\n");
        }
        if (this.isBorderRightSet()) {
            sbuf.append("chs.setBorderRight(");
            sbuf.append(this.getBorderRight());
            sbuf.append(");\n");
        }
        if (this.isBorderLeftSet()) {
            sbuf.append("chs.setBorderLeft(");
            sbuf.append(this.getBorderLeft());
            sbuf.append(");\n");
        }
        return sbuf.toString();
    }

    protected String emitVersion() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Version: ");
        sbuf.append(Chart.getVersion());
        sbuf.append("\n");
        sbuf.append("\n");
        return sbuf.toString();
    }

    protected void initBorderFlags() {
        this.borderLeftSet = false;
        this.borderRightSet = false;
        this.borderBottomSet = false;
        this.borderTopSet = false;
    }

    public static String getVersion() {
        return "Chart Builder 2.37";
    }

    public ChartLabel getTitle() {
        return this.t;
    }

    public ChartLabel getFootnote() {
        return this.foot;
    }

    public ChartLabel getSubtitle() {
        return this.subt;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    protected boolean isPieChart() {
        return this.isPieChart;
    }

    protected void assertPieChart() {
        this.isPieChart = true;
    }

    protected void setSizeInternal(int width, int height) {
        this.width = width;
        this.height = height;
    }

    protected void setWidthInternal(int width) {
        this.width = width;
    }

    protected void setHeightInternal(int height) {
        this.height = height;
    }

    @Override
    public Dimension getSize() {
        Dimension d = new Dimension(this.width, this.height);
        return d;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = new Dimension(this.width, this.height);
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = new Dimension(this.width, this.height);
        return d;
    }

    public void setEdgeColor(Color c) {
        this.EdgeColor = c;
    }

    public Color getEdgeColor() {
        return this.EdgeColor;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color c) {
        this.background = c;
    }

    public void setTitlesForeground(Color c) {
        this.t.foreground = c;
        this.subt.foreground = c;
        this.foot.foreground = c;
    }

    protected boolean isBorderTopSet() {
        return this.borderTopSet;
    }

    protected boolean isBorderBottomSet() {
        return this.borderBottomSet;
    }

    protected boolean isBorderRightSet() {
        return this.borderRightSet;
    }

    protected boolean isBorderLeftSet() {
        return this.borderLeftSet;
    }

    public void setBorderLeft(int left) {
        if (left >= 0) {
            this.borderLeftSet = true;
            this.border_left = left;
        }
    }

    protected void setBorderLeftInternal(int left) {
        if (left >= 0) {
            this.border_left = left;
        }
    }

    public void setBorderRight(int right) {
        if (right >= 0) {
            this.borderRightSet = true;
            this.border_right = right;
        }
    }

    protected void setBorderRightInternal(int right) {
        if (right >= 0) {
            this.border_right = right;
        }
    }

    public void setBorderTop(int top) {
        if (top >= 0) {
            this.borderTopSet = true;
            this.border_top = top;
        }
    }

    protected void setBorderTopInternal(int top) {
        if (top >= 0) {
            this.border_top = top;
        }
    }

    public void setBorderBottom(int bottom) {
        if (bottom >= 0) {
            this.borderBottomSet = true;
            this.border_bottom = bottom;
        }
    }

    protected void setBorderBottomInternal(int bottom) {
        if (bottom >= 0) {
            this.border_bottom = bottom;
        }
    }

    public int getBorderLeft() {
        return this.border_left;
    }

    public int getBorderRight() {
        return this.border_right;
    }

    public int getBorderTop() {
        return this.border_top;
    }

    public int getBorderBottom() {
        return this.border_bottom;
    }

    public class ChartLabel
    extends Component {
        private int height = 0;
        private String text = "";
        private String[] textLines;
        private boolean multipleLines = false;
        private Font font = new Font("sansserif", 0, 10);
        private int stringWidth;
        private int stringHeight = 1;
        private int characterWidth = 0;
        private double whiteSpaceFactor = 1.0;
        double yOffset = 0.5;
        public static final int LEFT = 0;
        public static final int CENTER = 1;
        public static final int RIGHT = 2;
        public static final int CENTER_PLOT = 4;
        int alignment = 0;
        Color foreground = Color.black;
        private boolean fontMetricsGot = false;
        private FontMetrics fontmet;

        @Override
        public int getHeight() {
            return this.height;
        }

        protected void setHeight(int height) {
            this.height = height;
        }

        protected ChartLabel() {
            this("", 0);
        }

        protected ChartLabel(String text) {
            this(text, 0);
        }

        @Override
        public void setForeground(Color c) {
            this.foreground = c;
        }

        protected ChartLabel(String text, int alignment) {
            this.text = text;
            this.setAlignment(alignment);
        }

        protected ChartLabel(String text, int alignment, Font f, double whiteSpaceFactor, double yOffset) {
            this.text = text;
            this.setAlignment(alignment);
            this.whiteSpaceFactor = whiteSpaceFactor;
            this.yOffset = yOffset;
            this.setFont(f);
        }

        public int getAlignment() {
            return this.alignment;
        }

        public synchronized void setAlignment(int alignment) {
            switch (alignment) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    this.alignment = alignment;
                    return;
                }
            }
            throw new IllegalArgumentException("improper alignment: " + alignment);
        }

        public void setFontMetrics(Graphics2D g2) {
            if (this.fontMetricsGot) {
                return;
            }
            this.fontmet = g2.getFontMetrics(this.font);
            this.fontMetricsGot = true;
            if (this.multipleLines) {
                this.deriveHeight(this.textLines.length);
            } else {
                this.deriveHeight();
            }
        }

        public int getLineCount() {
            if (this.multipleLines) {
                return this.textLines.length;
            }
            if (this.text == "") {
                return 0;
            }
            return 1;
        }

        public FontMetrics getFontMetrics() {
            return this.fontmet;
        }

        @Override
        public void setFont(Font f) {
            this.font = f;
            this.fontMetricsGot = false;
            if (this.multipleLines) {
                this.deriveHeight(this.textLines.length);
            } else {
                this.deriveHeight();
            }
        }

        @Override
        public Font getFont() {
            return this.font;
        }

        public void setWidth(int width) {
            super.setSize(width, this.getHeight());
        }

        public String getText() {
            if (this.multipleLines) {
                return this.textLines[0];
            }
            return this.text;
        }

        public void setText(String text) {
            if (text == null) {
                return;
            }
            this.text = text;
            if (this.multipleLines) {
                this.deriveHeight(this.textLines.length);
            } else {
                this.deriveHeight();
            }
        }

        public void setText(String[] text) {
            if (text == null) {
                return;
            }
            int numLines = text.length;
            this.multipleLines = true;
            this.textLines = new String[numLines];
            for (int i = 0; i < numLines; ++i) {
                this.textLines[i] = text[i];
            }
            this.deriveHeight(numLines);
        }

        public void setHeightFactor(double heightFactor) {
            this.whiteSpaceFactor = heightFactor;
        }

        void setYOffset(double yOffset) {
            this.yOffset = yOffset;
        }

        public int getStringWidth() {
            if (this.fontmet != null) {
                if (!this.multipleLines) {
                    this.stringWidth = this.fontmet.stringWidth(this.text);
                } else {
                    int lineWidth = 0;
                    this.stringWidth = 0;
                    for (int i = 0; i < this.textLines.length; ++i) {
                        lineWidth = this.fontmet.stringWidth(this.textLines[i]);
                        if (this.stringWidth >= lineWidth) continue;
                        this.stringWidth = lineWidth;
                    }
                }
            }
            return this.stringWidth;
        }

        private void deriveHeight() {
            int labelHeight = 0;
            if (this.fontmet != null) {
                labelHeight = this.fontmet.getHeight();
                this.stringHeight = this.fontmet.getAscent();
                this.stringWidth = this.fontmet.stringWidth(this.text);
                this.characterWidth = this.fontmet.stringWidth("#");
                int height = (int)((double)labelHeight * this.whiteSpaceFactor);
                this.setHeight(height);
            }
        }

        private void deriveHeight(int lines) {
            if (this.fontmet != null) {
                int labelHeight = this.fontmet.getHeight();
                this.stringHeight = this.fontmet.getAscent();
                this.stringWidth = this.fontmet.stringWidth(this.text);
                this.characterWidth = this.fontmet.stringWidth("#");
                int height = (int)((double)labelHeight * this.whiteSpaceFactor) + (lines - 1) * this.stringHeight;
                this.setHeight(height);
            }
        }

        private int getTextXLocation(int alignment, int stringWidth) {
            boolean debug = false;
            int x = 0;
            switch (alignment) {
                case 0: {
                    x = super.getX() + this.characterWidth;
                    break;
                }
                case 1: {
                    x = super.getX() + Chart.this.width / 2 - stringWidth / 2;
                    if (x >= super.getX()) break;
                    x = super.getX();
                    break;
                }
                case 4: {
                    x = super.getX() + Chart.this.getBorderLeft() + (Chart.this.width - Chart.this.getBorderLeft() - Chart.this.getBorderRight()) / 2 - stringWidth / 2;
                    if (x >= super.getX()) break;
                    x = super.getX();
                    break;
                }
                case 2: {
                    x = super.getX() + (Chart.this.width - stringWidth);
                    if (x >= super.getX()) break;
                    x = super.getX();
                }
            }
            return x;
        }

        public void drawBuffer(Graphics2D g2) {
            boolean debug = false;
            int x = 0;
            int y = 0;
            this.setFontMetrics(g2);
            g2.setFont(this.font);
            int labelHeight = this.fontmet.getHeight();
            g2.setColor(this.foreground);
            y = super.getY() + (int)(this.yOffset * (double)labelHeight);
            if (this.multipleLines) {
                this.deriveHeight(this.textLines.length);
                for (int i = 0; i < this.textLines.length; ++i) {
                    this.stringWidth = this.fontmet.stringWidth(this.textLines[i]);
                    if (this.stringWidth <= 0) continue;
                    x = this.getTextXLocation(this.alignment, this.stringWidth);
                    if (debug) {
                        System.out.println("drawString " + this.textLines[i] + " " + x + " " + y);
                    }
                    g2.drawString(this.textLines[i], x, y);
                    y += this.stringHeight;
                }
            } else {
                this.deriveHeight();
                this.stringWidth = this.fontmet.stringWidth(this.text);
                if (this.stringWidth > 0) {
                    x = this.getTextXLocation(this.alignment, this.stringWidth);
                    if (debug) {
                        System.out.println("drawString ." + this.text + ". w =" + this.stringWidth + "( " + x + "," + y + ")");
                    }
                    g2.drawString(this.text, x, y);
                }
            }
        }
    }
}

