/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleDataSource;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.util.Util;

public class NativeOracleDataSource
extends AbstractDBDataSource {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final int ODS_MAXIMUM_OPEN_CONNECTION_LIMIT = 256;
    private OracleDataSource ds;
    private String tnsName;
    private String host;
    private String port;
    private String sid;
    private String user;
    private String passwd;
    private String mode;
    private int maxConnections;
    private String customString = null;
    private static boolean monitoring = false;
    private static int monitoringInterval = 5;
    private MonitorThread monitoringThread = null;

    public NativeOracleDataSource(String name, String tnsName, String jdbcHost, String jdbcPort, String jdbcSid, String jdbcUser, String jdbcPasswd, String jdbcMode, int maxConn) {
        if (tnsName == null && (jdbcHost == null || jdbcPort == null || jdbcSid == null || jdbcUser == null || jdbcPasswd == null)) {
            throw new IllegalArgumentException("Illegal arguments in new NativeOracleDataSource.");
        }
        try {
            this.ds = new OracleDataSource();
            this.ds.setConnectionCachingEnabled(true);
            this.ds.setConnectionCacheName(name + "_conncache");
            if (tnsName != null) {
                this.ds.setURL("jdbc:oracle:oci8:@" + tnsName);
            } else {
                Connection mConnection = null;
                String baseURL = Util.getConnStr(jdbcMode, jdbcHost, jdbcPort, jdbcSid);
                try {
                    if (!DriverManager.getDrivers().hasMoreElements()) {
                        DriverManager.registerDriver((Driver)new OracleDriver());
                    }
                    mConnection = DriverManager.getConnection(baseURL, jdbcUser, jdbcPasswd);
                }
                catch (Exception e1) {
                    log.log(Level.WARNING, e1.getMessage(), e1);
                    log.warning("connecting to database using jdbc thin driver...");
                    baseURL = Util.getConnStr("thin", jdbcHost, jdbcPort, jdbcSid);
                    try {
                        if (!DriverManager.getDrivers().hasMoreElements()) {
                            DriverManager.registerDriver((Driver)new OracleDriver());
                        }
                        mConnection = DriverManager.getConnection(baseURL, jdbcUser, jdbcPasswd);
                        jdbcMode = "thin";
                    }
                    catch (SQLException e2) {
                        log.log(Level.SEVERE, e2.getMessage(), e2);
                        throw e2;
                    }
                }
                try {
                    mConnection.close();
                }
                catch (SQLException e3) {
                    // empty catch block
                }
                this.ds.setURL(baseURL);
            }
            this.ds.setUser(jdbcUser);
            this.ds.setPassword(jdbcPasswd);
            Properties cacheProps = new Properties();
            if (maxConn > 0) {
                cacheProps.setProperty("MaxLimit", "" + maxConn);
            } else {
                cacheProps.setProperty("MaxLimit", "256");
            }
            cacheProps.setProperty("InactivityTimeout", "300");
            cacheProps.setProperty("ConnectionWaitTimeout", "" + DSManager.getConnectionWaitTimeout());
            cacheProps.setProperty("ValidateConnection", "true");
            this.ds.setConnectionCacheProperties(cacheProps);
            this.name = name;
            if (tnsName != null) {
                this.tnsName = tnsName;
            } else {
                this.host = jdbcHost;
                this.port = jdbcPort;
                this.sid = jdbcSid;
                this.user = jdbcUser;
                this.passwd = jdbcPasswd;
                this.mode = jdbcMode;
            }
            this.closed = false;
            Connection c = this.ds.getConnection();
            this.dbProductVersion = Util.getDBVersion(c);
            this.is9i = Util.is9i(c);
            this.pre9i = Util.isPre9i(c);
            this.tenG = Util.is10g(c);
            DSUtil.createArrayTypes(c, name);
            c.close();
            if (monitoring) {
                log.info("Starting monitoring thread on data source " + name + "...");
                this.monitoringThread = new MonitorThread();
                this.monitoringThread.start();
            }
        }
        catch (Exception ne) {
            log.log(Level.SEVERE, ne.getMessage(), ne);
            throw new IllegalArgumentException("Error creating NativeOracleDataSource.");
        }
    }

    public NativeOracleDataSource(String name, String customString, String jdbcUser, String jdbcPasswd, int maxConn) {
        if (customString == null && (jdbcUser == null || jdbcPasswd == null)) {
            throw new IllegalArgumentException("Illegal arguments in new NativeOracleDataSource.");
        }
        try {
            this.ds = new OracleDataSource();
            this.ds.setConnectionCachingEnabled(true);
            this.ds.setConnectionCacheName(name + "_conncache");
            if (customString.toLowerCase().startsWith("jdbc:oracle:thin:@")) {
                this.ds.setURL(customString);
            } else {
                this.ds.setURL("jdbc:oracle:thin:@" + customString);
            }
            this.ds.setUser(jdbcUser);
            this.ds.setPassword(jdbcPasswd);
            Properties cacheProps = new Properties();
            if (maxConn > 0) {
                cacheProps.setProperty("MaxLimit", "" + maxConn);
            } else {
                cacheProps.setProperty("MaxLimit", "256");
            }
            cacheProps.setProperty("InactivityTimeout", "300");
            cacheProps.setProperty("ConnectionWaitTimeout", "" + DSManager.getConnectionWaitTimeout());
            cacheProps.setProperty("ValidateConnection", "true");
            this.ds.setConnectionCacheProperties(cacheProps);
            this.name = name;
            this.customString = customString;
            this.closed = false;
            Connection c = this.ds.getConnection();
            this.dbProductVersion = Util.getDBVersion(c);
            this.is9i = Util.is9i(c);
            this.pre9i = Util.isPre9i(c);
            this.tenG = Util.is10g(c);
            DSUtil.createArrayTypes(c, name);
            c.close();
            if (monitoring) {
                log.info("Starting monitoring thread on data source " + name + "...");
                this.monitoringThread = new MonitorThread();
                this.monitoringThread.start();
            }
        }
        catch (Exception ne) {
            log.log(Level.SEVERE, ne.getMessage(), ne);
            throw new IllegalArgumentException("Error creating NativeOracleDataSource.");
        }
    }

    public boolean matches(String jdbcHost, String jdbcPort, String jdbcSid, String jdbcUser, String jdbcPasswd, String jdbcMode) {
        boolean res = this.host != null && this.host.equalsIgnoreCase(jdbcHost) && this.port != null && this.port.equalsIgnoreCase(jdbcPort) && this.sid != null && this.sid.equalsIgnoreCase(jdbcSid) && this.user != null && this.user.equalsIgnoreCase(jdbcUser) && this.passwd != null && this.passwd.equals(jdbcPasswd);
        return res;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection c = this.ds.getConnection();
        return c;
    }

    @Override
    public Connection getConnection(String user, String passwd) throws SQLException {
        return this.ds.getConnection(user, passwd);
    }

    @Override
    public Connection getProxyConnection(String type, Properties p) throws SQLException {
        OracleConnection conn = (OracleConnection)this.ds.getConnection();
        int t = 1;
        if ("DISTINGUISHED_NAME".equals(type)) {
            t = 2;
        }
        conn.openProxySession(t, p);
        return conn;
    }

    @Override
    public void close() {
        try {
            log.info("Closing connection cache:" + this.ds.getConnectionCacheName());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.ds.close();
            this.closed = true;
            this.ds = null;
            if (this.monitoringThread != null) {
                this.monitoringThread.stopIt();
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    @Override
    public boolean supportOLS() {
        return false;
    }

    @Override
    public DataSource getUnwrappedDataSource() {
        return this.ds;
    }

    public OracleDataSource getOracleDataSource() {
        return this.ds;
    }

    public String report() {
        if (this.ds == null) {
            return null;
        }
        try {
            Properties cacheProps = this.ds.getConnectionCacheProperties();
            StringBuffer sb = new StringBuffer(1024);
            sb.append("\n----- NativeDataSrc (" + this.name + ") @ " + new Date() + " -----\n");
            sb.append("\n");
            sb.append("Connection Cache properties:" + cacheProps);
            OracleConnectionCacheManager occm = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
            sb.append("\n      # Active connections:" + occm.getNumberOfActiveConnections(this.name + "_conncache") + "\n");
            sb.append("      # Total available connections:" + occm.getNumberOfAvailableConnections(this.name + "_conncache") + "\n");
            return sb.toString();
        }
        catch (Exception ex) {
            return "Exception: " + ex.getMessage();
        }
    }

    public static void setMonitoring(boolean v, int interval) {
        monitoring = v;
        monitoringInterval = interval;
    }

    public static boolean getMonitoring() {
        return monitoring;
    }

    public String getTnsName() {
        return this.tnsName;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getSID() {
        return this.sid;
    }

    @Override
    public String getUser() {
        if (this.ds == null) {
            return null;
        }
        return this.ds.getUser();
    }

    public String getMode() {
        return this.mode;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public String getUserInfoPackageName() {
        return this.userInfoPackageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserInfoPackageName(String pkgName) {
        this.userInfoPackageName = pkgName;
        Connection conn = null;
        try {
            conn = this.getConnection();
            boolean valid = DSUtil.validPLSQLPackage(conn, pkgName);
            this.setUserIfnoPackageValid(valid);
            if (!valid) {
                log.warning("PL/SQL package " + pkgName + " will be ignored.");
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error validating pl/sql package " + pkgName + ".", e);
            this.setUserIfnoPackageValid(false);
            log.warning("PL/SQL package " + pkgName + " will be ignored.");
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    class MonitorThread
    extends Thread {
        boolean stop = false;

        MonitorThread() {
        }

        @Override
        public void run() {
            while (!this.stop) {
                String res = NativeOracleDataSource.this.report();
                if (res != null) {
                    log.info(res);
                }
                try {
                    MonitorThread.sleep(monitoringInterval * 1000);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void stopIt() {
            this.stop = true;
        }
    }
}

