/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.edit.session.store;

import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.edit.session.EditSessionDescriptor;
import oracle.sdovis.edit.session.store.EditSessionStore;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;

public class EditSessionTable
extends DBTable
implements EditSessionStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String mName = null;
    private String mDescription = null;
    private String mEditUser = null;
    private JGeometry mEditArea = null;
    private String mWorkspace = null;
    private String mStatus = null;
    private String mDefinition = null;

    public EditSessionTable(String dataSrc, String editTableName) {
        super(dataSrc, editTableName);
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setEditUser(String user) {
        this.mEditUser = user;
    }

    public void setDescription(String desc) {
        this.mDescription = desc;
    }

    public void setDefinition(String def) {
        this.mDefinition = def;
    }

    public void setEditArea(JGeometry geom) {
        this.mEditArea = geom;
    }

    public void setWorkspace(String workspace) {
        this.mWorkspace = workspace;
    }

    public void setStatus(String status) {
        this.mStatus = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EditSessionDescriptor getEditSession(String name, String user) {
        EditSessionDescriptor session = null;
        if (this.mDataSource == null || name == null || user == null) {
            return null;
        }
        try {
            String querystr = "select * from user_sdo_edit_sessions where name = '" + name.toUpperCase() + "' and editor = '" + user.toUpperCase() + "'";
            this.query(querystr);
            if (this.next()) {
                session = new EditSessionDescriptor(this.mName);
                session.setDescription(this.mDescription);
                session.setEditor(this.mEditUser);
                session.setArea(this.mEditArea);
                session.setWorkspace(this.mWorkspace);
                session.setStatus(this.mStatus);
                session.setDefinition(this.mDefinition);
                EditSessionDescriptor editSessionDescriptor = session;
                return editSessionDescriptor;
            }
            EditSessionDescriptor editSessionDescriptor = null;
            return editSessionDescriptor;
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            EditSessionDescriptor editSessionDescriptor = null;
            return editSessionDescriptor;
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (Exception ex) {}
        }
    }

    protected void finalize() {
        try {
            super.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected void initDeleteStatement() throws SQLException {
        if (this.mDeleteStatement == null) {
            this.mDeleteStatement = this.mConnection.prepareStatement("DELETE FROM " + this.mTableName + " WHERE name = ? and editor = ?");
        }
    }

    @Override
    protected void initInsertStatement() throws SQLException {
        if (this.mInsertStatement == null) {
            this.mInsertStatement = this.mConnection.prepareStatement("INSERT INTO " + this.mTableName + "(name,description,editor," + "area,workspace,status,definition)" + " VALUES(?, ?, ?, ?, ?, ?, empty_clob())");
        }
    }

    @Override
    protected void initUpdateStatement() throws SQLException {
        if (this.mUpdateStatement == null) {
            this.mUpdateStatement = this.mConnection.prepareStatement("select description, area, status, definition from USER_SDO_EDIT_SESSIONS where name = ? and editor = ? for update", 1005, 1008);
        }
    }

    @Override
    protected void updateLocalData() throws SQLException {
        this.mName = this.mResultSet.getString("NAME");
        this.mDescription = this.mResultSet.getString("DESCRIPTION");
        this.mEditUser = this.mResultSet.getString("EDITOR");
        try {
            this.mEditArea = JDBCUtil.loadGeometry(this.mResultSet, 4, false);
        }
        catch (Exception e) {
            this.mEditArea = null;
        }
        this.mWorkspace = this.mResultSet.getString("WORKSPACE");
        this.mStatus = this.mResultSet.getString("STATUS");
        try {
            CLOB mCLOBSVG = JDBCUtil.safeCastCLOB(this.mResultSet.getClob("DEFINITION"));
            StringBuffer buffer = new StringBuffer(mCLOBSVG.getSubString(1L, (int)mCLOBSVG.length()));
            this.mDefinition = buffer.toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mDefinition = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mDefinition = null;
        }
    }

    @Override
    public int delete() throws SQLException {
        DBDataSource ds = (DBDataSource)DSManager.get(this.mDataSource);
        this.mConnection = ds.getConnection();
        this.initDeleteStatement();
        this.mDeleteStatement.setString(1, this.mName.toUpperCase());
        this.mDeleteStatement.setString(2, this.mEditUser.toUpperCase());
        int res = this.mDeleteStatement.executeUpdate();
        this.mConnection.commit();
        this.close();
        this.mName = null;
        this.mDefinition = null;
        this.mEditUser = null;
        this.mEditArea = null;
        this.mWorkspace = null;
        this.mStatus = null;
        this.mDescription = null;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert() throws SQLException {
        int res = 0;
        STRUCT str = null;
        Statement stmt = null;
        boolean autoCommit = false;
        DBDataSource ds = (DBDataSource)DSManager.get(this.mDataSource);
        try {
            this.mConnection = ds.getConnection();
            autoCommit = this.mConnection.getAutoCommit();
            this.mConnection.setAutoCommit(false);
            this.initInsertStatement();
            this.mInsertStatement.setString(1, this.mName.toUpperCase());
            this.mInsertStatement.setString(2, this.mDescription);
            this.mInsertStatement.setString(3, this.mEditUser);
            try {
                if (this.mEditArea != null) {
                    str = JGeometry.store((JGeometry)this.mEditArea, (Connection)this.mConnection);
                }
            }
            catch (Exception e) {
                str = null;
            }
            if (str != null) {
                this.mInsertStatement.setObject(4, str);
            } else {
                this.mInsertStatement.setNull(4, 2002, "MDSYS.SDO_GEOMETRY");
            }
            this.mInsertStatement.setString(5, this.mWorkspace);
            this.mInsertStatement.setString(6, this.mStatus);
            res = this.mInsertStatement.executeUpdate();
            this.mConnection.commit();
            this.mConnection.setAutoCommit(false);
            stmt = ((OracleConnection)this.mConnection).createStatement();
            String s = "SELECT definition FROM " + this.mTableName + " WHERE name='" + this.mName.toUpperCase() + "' and editor='" + this.mEditUser.toUpperCase() + "' FOR UPDATE";
            log.finest("Query: " + s);
            try {
                this.mResultSet = stmt.executeQuery(s);
            }
            catch (SQLException ex) {
                log.severe(ex.getMessage());
                this.mConnection.setAutoCommit(autoCommit);
                this.close();
                this.delete();
                throw ex;
            }
            if (!this.mResultSet.next()) {
                log.severe("Cannot query " + this.mTableName + "! The inserted row is deleted.");
                this.mConnection.setAutoCommit(autoCommit);
                this.close();
                int ex = res = this.delete();
                return ex;
            }
            CLOB mCLOBSVG = JDBCUtil.safeCastCLOB(this.mResultSet.getClob("DEFINITION"));
            Util.putClobContents((Clob)mCLOBSVG, this.mDefinition);
            this.mConnection.commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            if (this.mConnection != null) {
                this.mConnection.setAutoCommit(autoCommit);
            }
            this.close();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() throws SQLException {
        STRUCT str = null;
        boolean autoCommit = false;
        ResultSet rs = null;
        DBDataSource ds = (DBDataSource)DSManager.get(this.mDataSource);
        try {
            this.mConnection = ds.getConnection();
            autoCommit = this.mConnection.getAutoCommit();
            this.mConnection.setAutoCommit(false);
            this.initUpdateStatement();
            this.mUpdateStatement.setString(1, this.mName.toUpperCase());
            this.mUpdateStatement.setString(2, this.mEditUser.toUpperCase());
            rs = this.mUpdateStatement.executeQuery();
            rs.next();
            rs.updateString(1, this.mDescription);
            try {
                if (this.mEditArea != null) {
                    str = JGeometry.store((JGeometry)this.mEditArea, (Connection)this.mConnection);
                }
            }
            catch (Exception e) {
                str = null;
            }
            rs.updateObject(2, str);
            rs.updateString(3, this.mStatus);
            CLOB clob = JDBCUtil.safeCastCLOB(rs.getClob("definition"));
            clob.trim(0L);
            Util.putClobContents((Clob)clob, this.mDefinition);
            rs.updateRow();
            this.mConnection.commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ers) {}
            if (this.mConnection != null) {
                this.mConnection.setAutoCommit(autoCommit);
            }
            this.close();
        }
        return 1;
    }
}

