/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.Ray;

public class PhongMaterial
extends Material {
    Vector3d specColor;
    double expt;

    public PhongMaterial(Vector3d diff, Vector3d spec, double exponent, Vector3d trans, Vector3d refl, double refr) {
        super(diff, trans, refl, refr);
        this.expt = exponent;
        this.specColor = spec;
    }

    @Override
    public Vector3d shade(Ray r, Hit h, Vector3d dirToLight, Vector3d lightColor) {
        Vector3d zerovec = new Vector3d();
        Vector3d color = new Vector3d();
        Vector3d liDir = dirToLight;
        Vector3d liCol = lightColor;
        Vector3d hNormal = h.getNormal();
        if (liDir.dot(hNormal) < 0.0) {
            color.add((Tuple3d)zerovec);
        } else {
            double dotprod = Math.max(0.0, liDir.dot(hNormal));
            Vector3d hDiffCol = h.getMaterial().getDiffuseColor();
            Vector3d newCol = new Vector3d(liCol.x * hDiffCol.x, liCol.y * hDiffCol.y, liCol.z * hDiffCol.z);
            newCol.scale(dotprod);
            color.add((Tuple3d)newCol);
        }
        Vector3d lrefl = new Vector3d(hNormal);
        lrefl.scale(liDir.dot(hNormal) * 2.0);
        lrefl.sub((Tuple3d)liDir);
        Vector3d viewDir = r.getDirection();
        viewDir.negate();
        this.specColor.scale(Math.pow(Math.max(0.0, viewDir.dot(lrefl)), this.expt));
        color.add((Tuple3d)this.specColor);
        return color;
    }
}

