/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stream;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.style.AreaStyleModel;
import oracle.mapviewer.share.style.LineStyleModel;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketStyleModel;
import oracle.mapviewer.share.stylex.CollectionStyleModel;
import oracle.mapviewer.share.stylex.ColorSchemeStyleModel;
import oracle.mapviewer.share.stylex.DotDensityStyleModel;
import oracle.mapviewer.share.stylex.VariableMarkerStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyleRowData;
import oracle.sdovis.StyleStore;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.stream.StyleJsonUtil;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleArea;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.CollectionStyle;
import oracle.sdovis.stylex.ColorSchemeStyle;
import oracle.sdovis.stylex.DotDensityStyle;
import oracle.sdovis.stylex.VariableMarkerStyle;

public class StyleGateway {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static StyleRowData[] getStylesData(String dataSrc) {
        StyleCache sc = DSManager.getStyleCache(dataSrc);
        if (sc == null) {
            return new StyleRowData[0];
        }
        StyleStore store = sc.getStyleStore();
        List styleNames = store.getStyleNames(null);
        if (styleNames == null || styleNames.size() == 0) {
            return new StyleRowData[0];
        }
        ArrayList<StyleRowData> res = new ArrayList<StyleRowData>(styleNames.size());
        for (int i = 0; i < styleNames.size(); ++i) {
            String name = (String)styleNames.get(i);
            try {
                StyleRowData sty = store.getStyleData(name);
                res.add(sty);
                continue;
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Cannot get style data for " + name + ".", ex);
            }
        }
        return res.toArray(new StyleRowData[res.size()]);
    }

    public static String getJSONDefinition(String dataSource, String styleName) {
        styleName = styleName.toUpperCase();
        StringBuilder res = new StringBuilder(200);
        StyleCache sc = DSManager.getStyleCache(dataSource);
        if (sc == null) {
            res.append("{error:\"Data source not found\"}");
        } else {
            res.append("{styles:[");
            Style style = sc.get(styleName);
            StyleGateway.style2JSON(style, res, styleName, sc);
            res.append("]}");
        }
        return res.toString();
    }

    public static String getXMLDefinition(String dataSource, String styleName) throws Exception {
        styleName = styleName.toUpperCase();
        StringBuilder res = new StringBuilder(200);
        ArrayList styles = StyleGateway.getRelatedStyles(dataSource, styleName);
        for (int i = 0; i < styles.size(); ++i) {
            Style style = (Style)styles.get(i);
            res.append("<style name=\"" + style.getModel().getName() + "\">");
            res.append(StyleGateway.cleanStyleXML(style.getModel().toXMLString()));
            res.append("</style>");
        }
        return res.toString();
    }

    private static void style2JSON(Style style, StringBuilder res, String name, StyleCache sc) {
        if (style == null) {
            return;
        }
        if (style instanceof StyleArea) {
            res.append(StyleJsonUtil.styleAreaToJSON((StyleArea)style, name, sc));
        } else if (style instanceof StyleColor) {
            res.append(StyleJsonUtil.styleColorToJSON((StyleColor)style, name));
        } else if (style instanceof StyleLine) {
            res.append(StyleJsonUtil.styleLineToJSON((StyleLine)style, name));
        } else if (style instanceof StyleMarker) {
            res.append(StyleJsonUtil.styleMarkerToJSON((StyleMarker)style, name));
        } else if (style instanceof StyleText) {
            res.append(StyleJsonUtil.styleTextToJSON((StyleText)style, name));
        } else if (style instanceof VariableMarkerStyle) {
            res.append(StyleJsonUtil.varirableMarkerStyleToJSON((VariableMarkerStyle)style, name, sc));
        }
    }

    private static String cleanStyleXML(String xml) {
        if (xml != null && xml.startsWith("<?xml")) {
            int idx = xml.indexOf("?>");
            return xml.substring(idx + 3);
        }
        return xml;
    }

    private static ArrayList getRelatedStyles(String dataSource, String styleName) throws Exception {
        StyleCache sc = DSManager.getStyleCache(dataSource);
        ArrayList<Style> res = new ArrayList<Style>(2);
        if (sc == null) {
            throw new Exception("Data source not found. [" + dataSource + "]");
        }
        Style style = sc.get(styleName);
        if (style == null) {
            throw new Exception("Style not found. [" + styleName + "]");
        }
        style.getModel().setName(styleName);
        if (style instanceof StyleArea) {
            String borderStyleName = ((AreaStyleModel)style.getModel()).getBorderStyleName();
            if (borderStyleName != null) {
                res.addAll(StyleGateway.getRelatedStyles(dataSource, borderStyleName));
            }
        } else if (style instanceof StyleLine) {
            String[] names;
            LineStyleModel bean = (LineStyleModel)style.getModel();
            String name = bean.getMarkerStyleName();
            if (name != null) {
                res.addAll(StyleGateway.getRelatedStyles(dataSource, name));
            }
            if ((names = bean.getMpMarkerStyles()) != null) {
                for (int i = 0; i < names.length; ++i) {
                    res.addAll(StyleGateway.getRelatedStyles(dataSource, names[i]));
                }
            }
        } else if (style instanceof CollectionStyle) {
            CollectionStyleModel bean = (CollectionStyleModel)style.getModel();
            for (int i = 0; i < bean.getNumberOfStyles(); ++i) {
                String name = bean.getStyleName(i);
                res.addAll(StyleGateway.getRelatedStyles(dataSource, name));
            }
        } else if (style instanceof ColorSchemeStyle) {
            ColorSchemeStyleModel bean = (ColorSchemeStyleModel)style.getModel();
            String defaultStyleName = bean.getBucketSeries().getDefaultRenderStyleName();
            if (defaultStyleName != null) {
                res.addAll(StyleGateway.getRelatedStyles(dataSource, defaultStyleName));
            }
        } else if (style instanceof DotDensityStyle) {
            DotDensityStyleModel bean = (DotDensityStyleModel)style.getModel();
            String markerStyleName = bean.getMarkerStyleName();
            if (markerStyleName != null) {
                res.addAll(StyleGateway.getRelatedStyles(dataSource, markerStyleName));
            }
        } else if (style instanceof VariableMarkerStyle) {
            String baseMarkerName;
            VariableMarkerStyleModel bean = (VariableMarkerStyleModel)style.getModel();
            String defaultStyleName = bean.getBucketSeries().getDefaultRenderStyleName();
            if (defaultStyleName != null) {
                res.addAll(StyleGateway.getRelatedStyles(dataSource, defaultStyleName));
            }
            if ((baseMarkerName = bean.getBaseMarkerName()) != null) {
                res.addAll(StyleGateway.getRelatedStyles(dataSource, baseMarkerName));
            }
        } else if (style instanceof BucketStyle) {
            BucketStyleModel bean = (BucketStyleModel)style.getModel();
            boolean hasCasedLineStyles = false;
            if (bean.getBucketSeries().size() != 0) {
                ArrayList list = bean.getBucketSeries().getBuckets();
                for (int i = 0; i < list.size(); ++i) {
                    Bucket bkt = (Bucket)list.get(i);
                    String name = bkt.getRenderStyleName();
                    if (name != null) {
                        res.addAll(StyleGateway.getRelatedStyles(dataSource, name));
                    }
                    if ((name = bkt.getLabelStyleName()) == null) continue;
                    res.addAll(StyleGateway.getRelatedStyles(dataSource, name));
                }
                String defaultStyleName = bean.getBucketSeries().getDefaultRenderStyleName();
                if (defaultStyleName != null) {
                    res.addAll(StyleGateway.getRelatedStyles(dataSource, defaultStyleName));
                }
                if ((defaultStyleName = bean.getBucketSeries().getDefaultLabelStyleName()) != null) {
                    res.addAll(StyleGateway.getRelatedStyles(dataSource, defaultStyleName));
                }
            }
        }
        res.add(style);
        return res;
    }
}

