/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.mapviewer.share.ext.SDataProvider;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SDataProviderMgr;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.VectorThemeDefinition;

public class CustomGeomThemeDefinition
extends VectorThemeDefinition {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String mProviderID = null;
    protected SDataProvider mDataProvider = null;
    protected Properties mRuntimeProperties = null;
    protected String mSpatialColumn = null;
    protected String mLabelColumn = null;
    protected String mFeatureStyleName = null;
    protected String mLabelStyleName = null;
    protected String mKeyColumn = null;
    protected String[] mNonSpatialColumns = null;
    protected String mQueryCondition = null;
    protected boolean mIgnoreSpatialFilter = false;
    protected ArrayList<String> encryptedParameters = new ArrayList();

    public CustomGeomThemeDefinition() {
    }

    public CustomGeomThemeDefinition(String name, String providerId, Properties runtimeProp, int srid) {
        this.name = name;
        this.mProviderID = providerId;
        this.refreshProvider();
        this.mRuntimeProperties = runtimeProp;
        this.srid = srid;
    }

    public CustomGeomThemeDefinition(String name, String providerId, Properties runtimeProp, int srid, StylingRule[] rules, String keyColumn) {
        this.name = name;
        this.mProviderID = providerId;
        this.refreshProvider();
        this.mRuntimeProperties = runtimeProp;
        this.srid = srid;
        this.mKeyColumn = keyColumn;
        if (rules != null && rules.length > 0) {
            this.setSpatialColumn(rules[0].getSpatialColumn());
            this.setFeatureStyleName(rules[0].getFeatureStyleName());
            this.setLabelColumn(rules[0].getLabelColumn());
            this.setLabelStyleName(rules[0].getLabelStyleName());
            this.mNonSpatialColumns = rules[0].getAttributeColumnsAsArray();
            this.mQueryCondition = rules[0].getFeatureCond();
            this.mIgnoreSpatialFilter = rules[0].isQueryPassThrough();
        }
    }

    public boolean refreshProvider() {
        this.mDataProvider = null;
        if (this.mProviderID != null) {
            this.mDataProvider = SDataProviderMgr.getProviderInstance(this.mProviderID);
            if (this.mDataProvider == null) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01026") + " [" + this.mProviderID + "]");
                return false;
            }
        } else {
            log.warning("Provider ID is not defined.");
            return false;
        }
        return true;
    }

    public String getProviderID() {
        return this.mProviderID;
    }

    public void setProviderID(String providerId) {
        if (this.mProviderID != null && providerId != null && this.mProviderID.equals(providerId)) {
            return;
        }
        this.mProviderID = providerId;
        this.refreshProvider();
    }

    public SDataProvider getProvider() {
        return this.mDataProvider;
    }

    public Properties getRuntimeProperties() {
        return this.mRuntimeProperties;
    }

    public String getSpatialColumn() {
        return this.mSpatialColumn;
    }

    public String getLabelColumn() {
        return this.mLabelColumn;
    }

    public String getFeatureStyleName() {
        return this.mFeatureStyleName;
    }

    public String getLabelStyleName() {
        return this.mLabelStyleName;
    }

    public void setSpatialColumn(String v) {
        this.mSpatialColumn = v;
    }

    public void setLabelColumn(String v) {
        this.mLabelColumn = v == null || v.trim().length() == 0 ? null : v;
    }

    public void setFeatureStyleName(String v) {
        this.mFeatureStyleName = v == null || v.trim().length() == 0 ? null : v;
    }

    public void setLabelStyleName(String v) {
        this.mLabelStyleName = v == null || v.trim().length() == 0 ? null : v;
    }

    public void setKeyColumn(String keyCol) {
        this.mKeyColumn = keyCol == null || keyCol.trim().length() == 0 ? null : keyCol;
    }

    @Override
    public String getKeyColumn() {
        return this.mKeyColumn;
    }

    public void setRuntimeProperties(Properties prop) {
        this.mRuntimeProperties = prop;
    }

    public String[] getNonSpatialColumns() {
        return this.mNonSpatialColumns;
    }

    public void setNonSpatialColumns(String[] columns) {
        this.mNonSpatialColumns = columns;
    }

    @Override
    public String getThemeType() {
        return "GEOM_CUSTOM";
    }

    @Override
    public String getXMLDefinition() {
        return "";
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(null);
        ti.setType("GEOM_CUSTOM");
        ti.setKeyColumn(this.getKeyColumn());
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(this.getSpatialColumn());
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        if (this.mFeatureStyleName == null) {
            return null;
        }
        String[] styleNames = new String[]{this.mFeatureStyleName.toUpperCase()};
        return styleNames;
    }

    @Override
    public String[] getLabelingStyles() {
        if (this.mLabelStyleName == null) {
            return null;
        }
        String[] styleNames = new String[]{this.mLabelStyleName.toUpperCase()};
        return styleNames;
    }

    @Override
    public String[] getHighlightStyles() {
        return null;
    }

    @Override
    public String[] getLabelColumns() {
        String[] columns = null;
        if (this.mLabelColumn != null) {
            columns = new String[]{this.mLabelColumn};
        }
        return columns;
    }

    public String getQueryCondition() {
        return this.mQueryCondition;
    }

    public void setQueryCondition(String condition) {
        this.mQueryCondition = condition;
    }

    public boolean getIgnoreSpatialFilter() {
        return this.mIgnoreSpatialFilter;
    }

    public void setIgnoreSpatialFilter(boolean asis) {
        this.mIgnoreSpatialFilter = asis;
    }

    public boolean isEncryptedParameter(String name) {
        if (name == null) {
            return false;
        }
        return this.encryptedParameters.contains(name);
    }

    public void setParameterEncrypted(String name, boolean encrypted) {
        if (name == null) {
            return;
        }
        if (encrypted && !this.encryptedParameters.contains(name)) {
            this.encryptedParameters.add(name);
        } else {
            this.encryptedParameters.remove(name);
        }
    }

    public void setEncryptedParameters(ArrayList<String> params) {
        if (params == null) {
            this.encryptedParameters.clear();
        } else {
            this.encryptedParameters = params;
        }
    }
}

