/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import oracle.dms.instrument.PhaseEvent;
import oracle.lbs.mapcache.cache.MapCache;
import oracle.lbs.mapcache.config.CacheInstanceConfig;
import oracle.lbs.mapclient.MapViewer;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.mapviewer.utils.CSTransformUtils;
import oracle.sdovis.DataException;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapCacheTheme;
import oracle.sdovis.SRS;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.ImageUtils;

public class MapCacheThemeProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent mapCacheSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "MapCache", "Producer", "Time spent preparing data");
    MapCacheTheme theme = null;
    Image themeImage = null;
    Rectangle2D window = null;
    Rectangle2D resultWindow = null;
    int mapWidth = 0;
    int mapHeight = 0;
    int responseSrid = 0;

    public MapCacheThemeProducer(MapCacheTheme theme) {
        this.theme = theme;
    }

    public Image getThemeImage() {
        return this.themeImage;
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public int size() {
        return this.themeImage == null ? 0 : 1;
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenM = 0L;
        try {
            tokenM = mapCacheSensor.start();
            if (!this.sridsAreSame(this.theme.getSRID(), vc.getMasterSRID())) {
                int n = 0;
                return n;
            }
            if (this.themeImage != null) {
                int n = 1;
                return n;
            }
            queryWin = vc.getQueryWindow();
            if (this.theme.getExternalMapViewerURL() == null && this.theme.getMapWindow() != null) {
                this.mapWidth = (int)(vc.getDeviceWindow().getWidth() * queryWin.getWidth() / this.theme.getMapWindow().getWidth());
                this.mapHeight = (int)(vc.getDeviceWindow().getHeight() * queryWin.getHeight() / this.theme.getMapWindow().getHeight());
            } else {
                this.mapWidth = (int)vc.getDeviceWindow().getWidth();
                this.mapHeight = (int)vc.getDeviceWindow().getHeight();
            }
            if (!SRS.isWrapAroundSupported(vc.getMasterSRID())) {
                vc.setWrapAround(false);
            }
            try {
                if (this.theme.getExternalMapViewerURL() == null) {
                    MapCache cache = this.theme.getCacheInstance();
                    CacheInstanceConfig config = cache.getConfig();
                    if (config.isClientSideTileAccess()) {
                        if ("mapviewer".equalsIgnoreCase(config.clientSideTileAccessType)) {
                            String tileLayer = config.getProperty("tile_layer_name");
                            int ds = tileLayer.indexOf(".");
                            if (ds > 0) {
                                String url = config.externalMapServiceURL;
                                int idx = url.indexOf("mcserver");
                                if (idx > 0) {
                                    url = url.substring(0, idx);
                                }
                                this.themeImage = this.getExternalTileMap(url, tileLayer.substring(0, ds), tileLayer.substring(ds + 1), queryWin, this.mapWidth, this.mapHeight, vc.getWrapAround(), vc.getMasterSRID());
                            } else {
                                this.themeImage = this.theme.getCacheInstance().getMap(queryWin, this.mapWidth, this.mapHeight, this.theme.getTileResizingOption());
                            }
                        } else {
                            String key = config.getProperty("key");
                            String type = this.theme.getParameter("map_type");
                            String url = config.getProperty("static_map_url");
                            String client = config.getProperty("client");
                            int zoomLevel = this.theme.getCacheInstance().getZoomLevel((Rectangle2D)queryWin, (int)this.mapWidth, (int)this.mapHeight, (boolean)false, (String)this.theme.getTileResizingOption()).level;
                            double[] lonlat = new double[2];
                            CSTransformUtils.inverseGoogleMercator(queryWin.getCenterX(), queryWin.getCenterY(), lonlat);
                            this.themeImage = "google".equalsIgnoreCase(config.clientSideTileAccessType) ? this.getStaticGoogleMap(lonlat[0], lonlat[1], this.mapWidth, this.mapHeight, zoomLevel, key, type, url, client) : ("bing".equalsIgnoreCase(config.clientSideTileAccessType) ? this.getStaticBingMap(lonlat[0], lonlat[1], this.mapWidth, this.mapHeight, zoomLevel, key, type, url) : null);
                        }
                    } else if (!vc.getWrapAround()) {
                        this.themeImage = this.theme.getCacheInstance().getMap(queryWin, this.mapWidth, this.mapHeight, this.theme.getTileResizingOption());
                    } else {
                        Properties prop = new Properties();
                        prop.setProperty("wraparound", "true");
                        prop.setProperty("srid", "" + vc.getMasterSRID());
                        this.themeImage = this.theme.getCacheInstance().getMap(queryWin, this.mapWidth, this.mapHeight, prop, this.theme.getTileResizingOption());
                    }
                } else {
                    this.themeImage = this.getExternalTileMap(this.theme.getExternalMapViewerURL(), this.theme.getDataSourceName(), this.theme.getTileLayerName(), queryWin, this.mapWidth, this.mapHeight, vc.getWrapAround(), vc.getMasterSRID());
                }
            }
            catch (Exception oe) {
                log.log(Level.WARNING, "Failed to get cached map image for theme " + this.theme.getDefinition().name + "!", oe);
            }
            int n = 1;
            return n;
        }
        finally {
            mapCacheSensor.stop(tokenM);
        }
    }

    @Override
    public void postPreparation(VisContext vc) {
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        return null;
    }

    @Override
    public double[] getDataMBR() {
        Rectangle2D rect = this.theme.getMapWindow();
        return new double[]{rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY()};
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        return null;
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        return null;
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        return null;
    }

    @Override
    public void destroy() {
        if (this.themeImage != null) {
            this.themeImage.flush();
            this.themeImage = null;
        }
    }

    @Override
    public void abort() {
    }

    private boolean sridsAreSame(int srid1, int srid2) {
        if (srid1 == srid2 || srid1 == 0 || srid2 == 0) {
            return true;
        }
        return srid1 == 8265 && srid2 == 8307 || srid1 == 8307 && srid2 == 8265;
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return null;
    }

    private Image getExternalTileMap(String url, String dataSource, String tileLayerName, Rectangle2D queryWin, int mapWidth, int mapHeight, boolean wrapAround, int srid) throws Exception {
        MapViewer mapviewer = new MapViewer(url + "omserver");
        mapviewer.setAntiAliasing(true);
        mapviewer.setBox(queryWin.getMinX(), queryWin.getMinY(), queryWin.getMaxX(), queryWin.getMaxY());
        mapviewer.setDeviceSize(new Dimension(mapWidth, mapHeight));
        mapviewer.addMapCacheTheme("tile_theme", dataSource, tileLayerName, true);
        mapviewer.setImageFormat(9);
        mapviewer.setDataSourceName(dataSource);
        mapviewer.setBackgroundColor(null);
        mapviewer.setBackgroundTransparent(true);
        mapviewer.setIsTileRequest(true);
        mapviewer.setWrapAround(wrapAround);
        mapviewer.setMapRequestSRID(srid);
        mapviewer.setTileResizingOption("tile_theme", this.theme.getTileResizingOption());
        log.log(Level.FINEST, mapviewer.getMapRequestString());
        mapviewer.run();
        double[] mbr = mapviewer.getMapMBR();
        this.responseSrid = mapviewer.getMapResponse().getSRID();
        this.resultWindow = new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]);
        return mapviewer.getGeneratedMapImage();
    }

    private Image getStaticGoogleMap(double x, double y, int mapWidth, int mapHeight, int zoomLevel, String key, String type, String url, String client) throws Exception {
        int index;
        type = type == null || type.equalsIgnoreCase("road") ? "roadmap" : (type.equalsIgnoreCase("hybrid") ? "hybrid" : (type.equalsIgnoreCase("satellite") ? "satellite" : (type.equalsIgnoreCase("shaded") ? "terrain" : "roadmap")));
        if (url == null) {
            url = "http://maps.google.com/maps/api/staticmap?sensor=false";
        }
        url = url + "&size=" + mapWidth + "x" + mapHeight;
        String signature = null;
        if (client == null && key != null) {
            url = url + "&key=" + key;
        }
        url = url + "&maptype=" + type;
        url = url + "&zoom=" + (zoomLevel + 1);
        url = url + "&center=" + y + "," + x;
        if (client != null && (index = (url = url + "&client=" + client).indexOf("//")) != -1 && (index = url.indexOf("/", index + 2)) != -1) {
            signature = this.getGoogleMapBusinessSignature(key, url.substring(index));
            if (signature != null) {
                url = url + "&signature=" + signature;
            } else {
                log.warning("Unable to get Google signature for client=" + client);
            }
        }
        log.finest(url);
        return this.loadImageFromURL(url);
    }

    private Image getStaticBingMap(double x, double y, int mapWidth, int mapHeight, int zoomLevel, String key, String type, String url) throws Exception {
        type = type == null || type.equalsIgnoreCase("road") ? "Road" : (type.equalsIgnoreCase("hybrid") ? "AerialWithLabels" : (type.equalsIgnoreCase("satellite") ? "Aerial" : "Road"));
        if (url == null) {
            url = "http://dev.virtualearth.net/REST/V1/Imagery/Map/";
        }
        url = url + type + "/";
        url = url + y + "," + x + "/";
        url = url + (zoomLevel + 1) + "?";
        url = url + "&mapSize=" + mapWidth + "," + mapHeight;
        url = url + "&key=" + key;
        System.out.println(url);
        return this.loadImageFromURL(url);
    }

    public Rectangle2D getMapWindow() {
        return this.resultWindow;
    }

    public int getResonseSrid() {
        return this.responseSrid;
    }

    private Image loadImageFromURL(String url) {
        try {
            URL wu = new URL(url);
            Image img = ImageUtils.blockingLoad(wu);
            if (img != null) {
                return img;
            }
            log.warning("cannot load background image from: " + url);
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
        }
        return null;
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return -1L;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
    }

    private String getGoogleMapBusinessSignature(String key, String url) {
        if (key == null || url == null) {
            return null;
        }
        try {
            String keyString = key.replace('-', '+');
            keyString = keyString.replace('_', '/');
            byte[] keyS = DatatypeConverter.parseBase64Binary((String)keyString);
            String resource = url;
            SecretKeySpec sha1Key = new SecretKeySpec(keyS, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(sha1Key);
            byte[] sigBytes = mac.doFinal(resource.getBytes());
            String signature = DatatypeConverter.printBase64Binary((byte[])sigBytes);
            signature = signature.replace('+', '-');
            signature = signature.replace('/', '_');
            return signature;
        }
        catch (Exception ex) {
            log.warning(ex.getMessage());
            return null;
        }
    }
}

