/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;
import oracle.dms.instrument.PhaseEvent;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.sdovis.DataException;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.Group;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.Object3d;
import oracle.sdovis.raytracing.Plane;
import oracle.sdovis.raytracing.RTRenderer;
import oracle.sdovis.raytracing.TextureMap;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.GeoRasterThemeProducer;
import oracle.sdovis.theme.ShadedReliefThemeDefinition;

public class ShadedReliefThemeProducer
extends GeoRasterThemeProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent shadedSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "ShadedRelief", "Producer", "Time spent preparing data");
    protected ShadedReliefThemeDefinition srdef;
    HashMap srRenderedImages = new HashMap();

    public ShadedReliefThemeProducer(Theme t) {
        this.owner = t;
        this.srdef = (ShadedReliefThemeDefinition)t.getDefinition();
        this.def = (GeoRasterThemeDefinition)this.srdef.getGeorDef();
    }

    public ShadedReliefThemeProducer(Theme t, Object[] bindingVars) {
        this.owner = t;
        this.srdef = (ShadedReliefThemeDefinition)t.getDefinition();
        this.def = (GeoRasterThemeDefinition)this.srdef.getGeorDef();
        super.setBindingParameters(bindingVars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenS = 0L;
        try {
            tokenS = shadedSensor.start();
            Rectangle2D screenRegion = vc.getDeviceWindow();
            int len = super.prepareData(queryWin, vc);
            int width = (int)screenRegion.getWidth();
            int height = (int)screenRegion.getHeight();
            int bounces = this.srdef.getBounces();
            int weight = this.srdef.getWeight();
            Camera cam = this.srdef.getCamera();
            double[][] mbrs = super.getMBRs();
            RTRenderer rtr = new RTRenderer();
            rtr.setCamera(cam);
            rtr.setBackgroundColor(this.srdef.getBackgroundColor());
            rtr.setAmbientLight(this.srdef.getAmbientLight());
            rtr.setLights(this.srdef.getLights());
            for (int i = 0; i < len; ++i) {
                RenderedImage nextIm = this.getRenderedImage(i);
                Raster r = nextIm.getData();
                double[][] heightMap = this.getDEMData(r);
                Vector3d diffColor = new Vector3d(0.75, 0.75, 0.75);
                Vector3d specColor = new Vector3d(0.0, 0.0, 0.0);
                Vector3d reflColor = new Vector3d(0.0, 0.0, 0.0);
                Vector3d transColor = new Vector3d(0.0, 0.0, 0.0);
                double refrIdx = 0.0;
                double exponent = 1.0;
                TextureMap mat = new TextureMap(diffColor, specColor, exponent, transColor, reflColor, refrIdx, heightMap, r.getNumBands(), r.getWidth(), r.getHeight());
                Material[] mats = new Material[]{mat};
                rtr.setMaterials(mats);
                Object3d[] list = new Object3d[1];
                Vector3d stdNormal = new Vector3d(0.0, 1.0, 0.0);
                double stdOffset = -1.0;
                list[0] = new Plane(stdNormal, stdOffset, mats[0], cam);
                Group gr = new Group(list);
                rtr.setGroup(gr);
                int[] bandOffsets = new int[]{0, 1, 2};
                ComponentSampleModel sm = new ComponentSampleModel(5, width, height, 3, 3 * width, bandOffsets);
                Point orig = new Point((int)screenRegion.getMinX(), (int)screenRegion.getMinY());
                WritableRaster resultRas = WritableRaster.createWritableRaster(sm, orig);
                RenderedImage bi = rtr.doRendering(resultRas, bounces, weight, width, height);
                this.srRenderedImages.put(String.valueOf(i), bi);
            }
            int n = len;
            return n;
        }
        finally {
            shadedSensor.stop(tokenS);
        }
    }

    public double[][] getDEMData(Raster r) {
        int numBands = r.getNumBands();
        int x0 = r.getMinX();
        int y0 = r.getMinY();
        int w = r.getWidth();
        int h = r.getHeight();
        int x1 = x0 + w - 1;
        int y1 = y0 + h - 1;
        boolean bi = false;
        boolean wi = false;
        int hi = 0;
        int wc = 0;
        boolean hc = false;
        double[][] resultbip = new double[h][w * numBands];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                for (int b = 0; b < numBands; ++b) {
                    resultbip[hi][wc] = r.getSampleDouble(x, y, b);
                    ++wc;
                }
            }
            wc = 0;
            ++hi;
        }
        return resultbip;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.srRenderedImages.size() > 0) {
            Object[] obj = this.srRenderedImages.values().toArray();
            this.renderImages.clear();
            for (int i = 0; i < obj.length; ++i) {
                if (obj[i] instanceof BufferedImage) {
                    BufferedImage bi = (BufferedImage)obj[i];
                    bi.flush();
                }
                obj[i] = null;
            }
            Object var1_1 = null;
        }
    }

    public HashMap getShadedReliefRenderedImages() {
        return this.srRenderedImages;
    }

    public RenderedImage getShadedReliefRenderedImage(int index) {
        if (this.srRenderedImages == null) {
            return null;
        }
        if (index < 0 || index > this.srRenderedImages.size() - 1) {
            return null;
        }
        return (RenderedImage)this.srRenderedImages.get(String.valueOf(index));
    }

    @Override
    public void abort() {
    }
}

