/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import oracle.lbs.wmts.v100.jaxb.Capabilities;
import oracle.lbs.wmts.v100.jaxb.ContentsType;
import oracle.lbs.wmts.v100.jaxb.DCP;
import oracle.lbs.wmts.v100.jaxb.Dimension;
import oracle.lbs.wmts.v100.jaxb.DomainType;
import oracle.lbs.wmts.v100.jaxb.HTTP;
import oracle.lbs.wmts.v100.jaxb.LayerType;
import oracle.lbs.wmts.v100.jaxb.Operation;
import oracle.lbs.wmts.v100.jaxb.RequestMethodType;
import oracle.lbs.wmts.v100.jaxb.TileMatrix;
import oracle.lbs.wmts.v100.jaxb.TileMatrixLimits;
import oracle.lbs.wmts.v100.jaxb.TileMatrixSet;
import oracle.lbs.wmts.v100.jaxb.TileMatrixSetLimits;
import oracle.lbs.wmts.v100.jaxb.TileMatrixSetLink;
import oracle.lbs.wmts.v100.jaxb.URLTemplateType;
import oracle.lbs.wmts.v100.jaxb.ValueType;
import oracle.lbs.wmts.v100.jaxb.WGS84BoundingBoxType;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.EPSG2SDO;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.util.Util;

public class WMTSThemeDefinition
extends ThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String dataSource = null;
    private String urlGetCapabilities = null;
    private String version = null;
    private String format = null;
    private String layer = null;
    private String style = null;
    private String tileMatrixSetID = null;
    private String srsName = null;
    private String urlGetTile = null;
    private HashMap<String, String> UIdimIDAndDefaults = null;
    private HashMap<String, List<String>> UIdimIDAndValues = null;
    private String[] UIdimIDs = null;
    private String[] UIdimDefaults = null;
    private String[] dimIDs = null;
    private String[] dimVals = null;
    private Capabilities capabilities = null;
    private long requestTimeout = 30000L;
    private double topLeftX = Double.NaN;
    private double topLeftY = Double.NaN;
    private String userName = null;
    private String passWord = null;
    HashMap<String, String> authenKVPs = null;
    long timeout = 0L;
    private double[] tileDenom = null;
    private double[][] topleftCorner = null;
    private int[][] tileDim = null;
    private long[][] matrixDim = null;
    private String[] tileMatrixID = null;
    private double[] lowerCorner = null;
    private double[] upperCorner = null;
    private Map tileMatrixLimitsMap = null;
    private boolean hasLimits = false;
    private boolean kvpForGetTile = true;
    private boolean kvpForGetCapbilities = true;
    String tileTemplateURL = null;

    public WMTSThemeDefinition() {
    }

    public WMTSThemeDefinition(String name_, String ds_, String urlPrefix_, String version_, String style_, String layer_, String format_, String tileMatrixSet_, String[] dimIDs_, String[] dimVals_) {
        this.createCacheGroup();
        this.setName(name_);
        this.dataSource = ds_;
        this.layer = layer_;
        this.tileMatrixSetID = tileMatrixSet_;
        this.dimIDs = dimIDs_;
        this.dimVals = dimVals_;
        if (this.dimIDs != null && this.dimVals != null && this.dimIDs.length != this.dimVals.length) {
            log.severe("Dimension parameters (IDs[], Values[]) do not have the same length.");
            return;
        }
        this.style = style_;
        this.urlGetCapabilities = urlPrefix_;
        this.version = version_;
        this.format = format_ == null ? "image/png" : format_.toLowerCase();
        this.readCapabilities(this.timeout);
    }

    private void initParameters() {
        String strsrs = this.getSupportedSrs();
        if (strsrs == null) {
            log.warning("SRS is null.");
            return;
        }
        this.setSRS(strsrs);
        if (this.kvpForGetCapbilities) {
            this.retrieveGetTileEncodingAndURL("KVP");
        } else if (!this.retrieveGetTileEncodingAndURL("RESTful")) {
            this.retrieveGetTileEncodingAndURL("KVP");
        }
        LayerType curLayer = this.getCurrentLayer();
        if (curLayer == null) {
            log.severe("Failed to retrieve layer: " + this.layer);
            return;
        }
        if (!this.kvpForGetTile) {
            this.initResourceURL(curLayer);
        }
        this.retrieveDimension(curLayer);
        this.retrieveLowerAndUpperCorners(curLayer);
        this.initTileMatrixSetElems();
        this.initTileRowColLimits();
    }

    private void retrieveLowerAndUpperCorners(LayerType curLayer) {
        List listBox = curLayer.getWGS84BoundingBox();
        if (listBox == null) {
            log.finer("No WGS84BoundingBoxType defined");
            return;
        }
        for (WGS84BoundingBoxType bt : listBox) {
            List uc;
            if (bt == null) {
                log.warning("No contexts in layer bounding box.");
                return;
            }
            BigInteger bi = bt.getDimensions();
            if (bi != null && bi.intValue() != 2) {
                log.warning("The dimension does not equal 2.");
                return;
            }
            List lc = bt.getLowerCorner();
            if (lc != null) {
                int ncount = 0;
                double[] d1 = new double[2];
                for (Double d : lc) {
                    d1[ncount++] = d;
                }
                this.lowerCorner = d1;
            }
            if ((uc = bt.getUpperCorner()) == null) continue;
            int ncount = 0;
            double[] d2 = new double[2];
            for (Double d : uc) {
                d2[ncount++] = d;
            }
            this.upperCorner = d2;
        }
    }

    private void retrieveDimension(LayerType curLayer) {
        List dimList = curLayer.getDimension();
        if (dimList != null) {
            this.UIdimIDAndDefaults = new HashMap();
            this.UIdimIDAndValues = new HashMap();
            int count = 0;
            this.UIdimIDs = new String[dimList.size()];
            this.UIdimDefaults = new String[dimList.size()];
            for (Dimension dim : dimList) {
                String strID = dim.getIdentifier().getValue();
                String strDefault = dim.getDefault();
                List tmpList = dim.getValue();
                this.UIdimIDAndDefaults.put(strID, strDefault);
                this.UIdimIDAndValues.put(strID, tmpList);
                this.UIdimIDs[count] = strID;
                this.UIdimDefaults[count] = strDefault;
                ++count;
            }
            if (this.dimIDs == null) {
                this.dimIDs = this.UIdimIDs;
                this.dimVals = this.UIdimDefaults;
            }
        }
    }

    public void setDimIDs(String[] dimIDs_) {
        this.dimIDs = dimIDs_;
    }

    public void setDimValues(String[] dimVals_) {
        this.dimVals = dimVals_;
    }

    public String[] getDimIDs() {
        return this.dimIDs;
    }

    public String[] getDimValues() {
        return this.dimVals;
    }

    private boolean retrieveGetTileEncodingAndURL(String strEncoding) {
        List listOps = this.capabilities.getOperationsMetadata().getOperation();
        for (Operation op : listOps) {
            if (!op.getName().equalsIgnoreCase("GetTile")) continue;
            List listDCPs = op.getDCP();
            for (DCP dcp : listDCPs) {
                HTTP http = dcp.getHTTP();
                List listJs = http.getGetOrPost();
                for (JAXBElement jaxreq : listJs) {
                    String tmpRef = ((RequestMethodType)jaxreq.getValue()).getHref();
                    List listDTs = ((RequestMethodType)jaxreq.getValue()).getConstraint();
                    for (DomainType dt : listDTs) {
                        if (!dt.getName().equalsIgnoreCase("getEncoding")) continue;
                        List listVs = dt.getAllowedValues().getValueOrRange();
                        for (Object o : listVs) {
                            ValueType st = (ValueType)o;
                            if (!st.getValue().equalsIgnoreCase(strEncoding)) continue;
                            if (strEncoding.equalsIgnoreCase("KVP")) {
                                this.kvpForGetTile = true;
                            } else if (strEncoding.equalsIgnoreCase("RESTful")) {
                                this.kvpForGetTile = false;
                            } else {
                                log.severe("error for retrieving GetTile encoding.");
                            }
                            this.urlGetTile = tmpRef;
                            log.fine("GetTile in " + strEncoding + " encoding.");
                            log.fine("GetTile url:" + this.urlGetTile);
                            return true;
                        }
                    }
                }
            }
        }
        log.warning("Failed to locate getTile encolding.");
        return false;
    }

    private void initResourceURL(LayerType curLayer) {
        List tmslList = curLayer.getResourceURL();
        Iterator i$ = tmslList.iterator();
        if (i$.hasNext()) {
            String tmsID;
            URLTemplateType tmsl = (URLTemplateType)i$.next();
            this.tileTemplateURL = tmsID = tmsl.getTemplate();
            if (!tmsl.getResourceType().equalsIgnoreCase("tile")) {
                log.warning("resourceType is " + tmsl.getResourceType() + ". \"tile\" is expected. ");
            }
            if (!tmsl.getFormat().equalsIgnoreCase(this.format)) {
                log.severe("format is " + tmsl.getFormat() + " in ResourceURL, but " + this.format + "was specified.");
            }
            log.finest("template: " + this.tileTemplateURL);
            return;
        }
        log.severe("ResourceURL for template was not found.");
    }

    private LayerType getCurrentLayer() {
        if (this.capabilities == null) {
            return null;
        }
        if (this.layer == null) {
            return null;
        }
        ContentsType ct = this.capabilities.getContents();
        List ddsList = ct.getDatasetDescriptionSummary();
        for (JAXBElement ddsNode : ddsList) {
            LayerType curlayer = (LayerType)ddsNode.getValue();
            String curLayerName = curlayer.getIdentifier().getValue();
            if (!curLayerName.equalsIgnoreCase(this.layer)) continue;
            return curlayer;
        }
        return null;
    }

    public void setGetTileUrlPrefix(String getTileURL) {
        this.urlGetTile = getTileURL;
    }

    public String getGetTileUrlPrefix() {
        return this.urlGetTile;
    }

    public String getTileTemplateURL() {
        return this.tileTemplateURL;
    }

    public void setWmtsVersion(String version) {
        this.version = version;
    }

    public String getWmtsVersion() {
        return this.version;
    }

    public HashMap<String, String> getKVPs() {
        return this.authenKVPs;
    }

    public void setFormat(String format_) {
        this.format = format_ == null ? "image/png" : format_.toLowerCase();
    }

    public String getFormat() {
        return this.format;
    }

    public void setLayer(String layer_) {
        this.layer = new String(layer_);
    }

    public String getLayer() {
        return this.layer;
    }

    public void setStyles(String theStyle) {
        this.style = new String(theStyle);
    }

    public String getStyle() {
        return this.style;
    }

    @Override
    public String getThemeType() {
        return "WMTS";
    }

    @Override
    public String getXMLDefinition() {
        return "";
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(this.urlGetCapabilities);
        ti.setType("WMTS");
        ti.setKeyColumn(null);
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(null);
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        return null;
    }

    @Override
    public String[] getLabelingStyles() {
        return null;
    }

    public void setCapabilitiesUrlPrefix(String capUrlPrefix) {
        this.urlGetCapabilities = capUrlPrefix;
    }

    public String getCapabilitiesUrlPrefix() {
        return this.urlGetCapabilities;
    }

    @Override
    public int getSrid() {
        return this.srid;
    }

    @Override
    public void setSrid(int s) {
        this.srid = s;
    }

    @Override
    public String[] getHighlightStyles() {
        return null;
    }

    @Override
    public String[] getLabelColumns() {
        return null;
    }

    @Override
    public Field[] getDistinctAttrColumns() {
        return null;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSource;
    }

    private void createCacheGroup() {
        CacheMgr2.createSubRegion("WMTS_URL");
        CacheMgr2.createGroup("WMTS_URL", "WMTS_CAPABILITIES");
    }

    Boolean readCapabilities(long timeout) {
        String cUrl = null;
        if (this.urlGetCapabilities == null) {
            return false;
        }
        String req = this.urlGetCapabilities;
        if (req.trim().toLowerCase().endsWith(".xml")) {
            cUrl = req.trim();
            this.kvpForGetCapbilities = false;
        } else {
            String tmpStr;
            int pos = req.indexOf(63);
            String string = tmpStr = pos == -1 ? null : req.substring(pos + 1);
            while (tmpStr != null && tmpStr.trim().length() > 3) {
                int equalSymbolPos = tmpStr.indexOf(61);
                int ampersandSymbolPos = tmpStr.indexOf(38);
                if (ampersandSymbolPos == -1) {
                    ampersandSymbolPos = tmpStr.length();
                }
                if (equalSymbolPos <= -1) continue;
                String tmpName = tmpStr.substring(0, equalSymbolPos);
                String tmpValue = tmpStr.substring(equalSymbolPos + 1, ampersandSymbolPos);
                if (!(tmpName.equalsIgnoreCase("service") || tmpName.equalsIgnoreCase("request") || tmpName.equalsIgnoreCase("version"))) {
                    if (this.authenKVPs == null) {
                        this.authenKVPs = new HashMap();
                    }
                    this.authenKVPs.put(tmpName, tmpValue);
                }
                if (ampersandSymbolPos >= tmpStr.length()) {
                    tmpStr = null;
                    break;
                }
                tmpStr = tmpStr.substring(ampersandSymbolPos + 1, tmpStr.length());
            }
            req = (pos = req.indexOf("?")) > -1 ? req.substring(0, pos + 1) : req + "?";
        }
        if (this.kvpForGetCapbilities) {
            cUrl = req + "SERVICE=WMTS&VERSION=" + this.getWmtsVersion() + "&REQUEST=GetCapabilities";
            if (this.authenKVPs != null && this.authenKVPs.size() > 0) {
                String authenParams = "";
                for (Map.Entry<String, String> kvp : this.authenKVPs.entrySet()) {
                    authenParams = authenParams + kvp.getKey() + "=" + kvp.getValue();
                }
                if (authenParams != null) {
                    cUrl = cUrl + "&" + authenParams;
                }
            }
        }
        Capabilities cap = null;
        CacheGroup cg = CacheMgr2.getGroup("WMTS_URL", "WMTS_CAPABILITIES");
        if (cg != null && (cap = (Capabilities)cg.get(this.urlGetCapabilities + this.getWmtsVersion())) != null) {
            this.capabilities = cap;
        }
        if (cap == null) {
            log.finest("getCapabilities req: " + cUrl);
            ReadXMLThread thread = new ReadXMLThread(cUrl);
            String xml = null;
            int count = 1;
            do {
                thread.start();
                try {
                    thread.join(this.requestTimeout * (long)count);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                xml = thread.getXMLData();
                if (xml != null) continue;
                log.finest("Attempt [" + count + "] of retrieving capabilities failed.");
            } while (xml == null && count < 3);
            if (xml == null) {
                return false;
            }
            long t0 = System.currentTimeMillis();
            try {
                JAXBContext jc = JAXBContext.newInstance((String)"oracle.lbs.wmts.v100.jaxb");
                Unmarshaller unmarsh = jc.createUnmarshaller();
                StringBuffer xmlStr = new StringBuffer(xml);
                Object jaxbEl = unmarsh.unmarshal((InputStream)new ByteArrayInputStream(xmlStr.toString().getBytes()));
                this.capabilities = (Capabilities)jaxbEl;
            }
            catch (Exception ex) {
                log.warning("Failed in unmarshalling XML from getCapabilites from url: " + req);
                return false;
            }
            if (cg != null) {
                cg.put(this.urlGetCapabilities + this.getWmtsVersion(), this.capabilities, 0L);
            }
            long t1 = System.currentTimeMillis();
            log.finest("Time spent on processing capabilities xml document: " + (t1 - t0) / 1000L + " sec.");
        }
        this.initParameters();
        return true;
    }

    public String getTileMatrixSetID() {
        return this.tileMatrixSetID;
    }

    public void setTileMatrixSetID(String setId) {
        this.tileMatrixSetID = setId;
    }

    String getTileMatrixID(int level) {
        return this.tileMatrixID[level];
    }

    long getTileMatrixDim(int level, int index) {
        return this.matrixDim[level][index];
    }

    int getTileDim(int level, int index) {
        return this.tileDim[level][index];
    }

    int getTileDenomLength() {
        return this.tileDenom.length;
    }

    double getTileDenom(int level) {
        return this.tileDenom[level];
    }

    double getTopleftCorner(int level, int index) {
        return this.topleftCorner[level][index];
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    Boolean setSRS(String strsrs) {
        if (strsrs == null) {
            log.warning("SRS string is null.");
            return false;
        }
        this.srsName = strsrs;
        int srsid = 0;
        int tmpindex = strsrs.indexOf("EPSG:");
        if (tmpindex > -1) {
            String strTmp = strsrs.substring(tmpindex + 5);
            srsid = Integer.parseInt(strTmp);
        } else {
            try {
                srsid = Integer.parseInt(strsrs);
            }
            catch (Exception ex) {
                log.warning("[" + strsrs + "] is snot a valid SRS ID.");
                return false;
            }
        }
        if (this.dataSource == null) {
            log.warning("dataSource is null.");
            return false;
        }
        int sdosrid = 0;
        String sridmap = EPSG2SDO.EPSGtoSDO(String.valueOf(srsid));
        log.finest("EPSG:" + srsid + " is mapped to sdo_srid " + srsid);
        sdosrid = sridmap != null ? Integer.parseInt(sridmap) : Util.EPSGsrid_To_Oraclesrid(this.dataSource, srsid);
        if (sdosrid > 0) {
            this.srid = sdosrid;
            log.info("Theme SRID set to " + this.srid);
        } else if (Util.existsOracleSRID(this.dataSource, srsid)) {
            this.srid = srsid;
            log.info("Theme SRID is set to " + this.srid);
        } else {
            log.warning("Unable to find an equivalent SDO SRID for EPSG " + srsid);
            this.srid = 0;
        }
        return true;
    }

    public void setAuthentication(String user, String pwd) {
        this.userName = user;
        this.passWord = pwd;
    }

    public boolean hasAuthentication() {
        return this.userName != null && this.passWord != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.passWord;
    }

    public double getTopLeftCornerX() {
        return this.topLeftX;
    }

    public double[] getLowerCorner() {
        return this.lowerCorner;
    }

    public double[] getUpperCorner() {
        return this.upperCorner;
    }

    public void setTopLeftCornerX(double x) {
        this.topLeftX = x;
    }

    public double getTopLeftCornerY() {
        return this.topLeftY;
    }

    public void setTopLeftCornerY(double y) {
        this.topLeftY = y;
    }

    public void setRequestTimeout(long timeout) {
        this.requestTimeout = timeout;
    }

    public String getSupportedSrs() {
        String curcrs = null;
        ContentsType ct = this.capabilities.getContents();
        List tmslist = ct.getTileMatrixSet();
        for (TileMatrixSet tms : tmslist) {
            String curMSID = tms.getIdentifier().getValue();
            if (!curMSID.equalsIgnoreCase(this.tileMatrixSetID)) continue;
            curcrs = tms.getSupportedCRS();
            break;
        }
        if (curcrs != null) {
            String tmpstr = curcrs.toUpperCase();
            if (tmpstr.endsWith(":CRS84")) {
                curcrs = "EPSG:4326";
            } else if (tmpstr.contains(":crs:OGC:") && tmpstr.endsWith(":84")) {
                curcrs = "EPSG:4326";
            } else {
                int tmpIndex1 = tmpstr.indexOf("URN:");
                int tmpIndex2 = tmpstr.indexOf("EPSG:");
                if (tmpIndex1 >= 0 && tmpIndex2 >= 0) {
                    int lastIndex = tmpstr.lastIndexOf(":");
                    curcrs = "EPSG:" + tmpstr.substring(lastIndex + 1);
                }
            }
        }
        return curcrs;
    }

    private Boolean initTileMatrixSetElems() {
        int count = 0;
        Boolean isNorthFirst = false;
        ContentsType ct = this.getCapabilities().getContents();
        List tmslist = ct.getTileMatrixSet();
        for (TileMatrixSet tms : tmslist) {
            String tmsDef = this.getTileMatrixSetID();
            String tmsCur = tms.getIdentifier().getValue();
            if (!tmsCur.equalsIgnoreCase(tmsDef)) continue;
            List tmlist = tms.getTileMatrix();
            int tmpSize = tmlist.size();
            this.tileDenom = new double[tmpSize];
            this.topleftCorner = new double[tmpSize][2];
            this.tileDim = new int[tmpSize][2];
            this.matrixDim = new long[tmpSize][2];
            this.tileMatrixID = new String[tmpSize];
            for (TileMatrix tm : tmlist) {
                tm.getMatrixHeight();
                this.tileDenom[count] = tm.getScaleDenominator();
                this.tileMatrixID[count] = tm.getIdentifier().getValue();
                List lt = tm.getTopLeftCorner();
                if (isNorthFirst.booleanValue()) {
                    this.topleftCorner[count][1] = (Double)lt.get(0);
                    this.topleftCorner[count][0] = (Double)lt.get(1);
                } else {
                    this.topleftCorner[count][0] = (Double)lt.get(0);
                    this.topleftCorner[count][1] = (Double)lt.get(1);
                }
                this.tileDim[count][0] = tm.getTileWidth().shortValue();
                this.tileDim[count][1] = tm.getTileHeight().shortValue();
                this.matrixDim[count][0] = tm.getMatrixWidth().intValue();
                this.matrixDim[count][1] = tm.getMatrixHeight().intValue();
                ++count;
            }
        }
        log.finer("[Version] " + this.getCapabilities().getVersion());
        log.finer("[Total tile levels] " + count);
        return true;
    }

    private void initTileRowColLimits() {
        LayerType lt = this.getLayerTypeElem();
        if (lt == null) {
            log.severe("Layer '" + this.layer + "' cannot be found.");
            return;
        }
        TileMatrixSetLimits tmsl = this.getTileMatrixSetLimits(lt);
        if (tmsl == null) {
            log.finest("No tile row/col limits exists for TileMatrixSet:" + this.tileMatrixSetID);
            this.hasLimits = false;
            return;
        }
        this.hasLimits = true;
        this.retrieveAndSetTileRowColLimits(tmsl);
    }

    boolean hasTileLimits() {
        return this.hasLimits;
    }

    private LayerType getLayerTypeElem() {
        ContentsType ct = this.getCapabilities().getContents();
        List ddsList = ct.getDatasetDescriptionSummary();
        for (JAXBElement ddsNode : ddsList) {
            LayerType curlayer = (LayerType)ddsNode.getValue();
            String curLayerName = curlayer.getIdentifier().getValue();
            if (!curLayerName.equals(this.getLayer())) continue;
            return curlayer;
        }
        return null;
    }

    private TileMatrixSetLimits getTileMatrixSetLimits(LayerType layertype) {
        if (layertype == null) {
            return null;
        }
        List tmslList = layertype.getTileMatrixSetLink();
        for (TileMatrixSetLink tmsl : tmslList) {
            String tmsID = tmsl.getTileMatrixSet();
            if (!tmsID.equals(this.getTileMatrixSetID())) continue;
            return tmsl.getTileMatrixSetLimits();
        }
        return null;
    }

    private void retrieveAndSetTileRowColLimits(TileMatrixSetLimits tmsl) {
        List tmlList = tmsl.getTileMatrixLimits();
        this.tileMatrixLimitsMap = new HashMap(tmlList.size());
        Iterator tmlIt = tmlList.iterator();
        int count = 0;
        while (tmlIt.hasNext()) {
            TileMatrixLimits tml = (TileMatrixLimits)tmlIt.next();
            String tileMatrixID = tml.getTileMatrix();
            long[] rcLimits = new long[]{tml.getMinTileCol().intValue(), tml.getMaxTileCol().intValue(), tml.getMinTileRow().intValue(), tml.getMaxTileRow().intValue()};
            this.tileMatrixLimitsMap.put(tileMatrixID, rcLimits);
            log.finest("TileMatrixLimits for " + tileMatrixID + ", min col:" + rcLimits[0] + ", max col:" + rcLimits[1] + ", min row:" + rcLimits[2] + ", max row:" + rcLimits[3]);
            ++count;
        }
        log.finer("Total TileMatrixLimits count:" + count);
    }

    long getTileMatrixLimitColMin(int level) {
        if (!this.hasLimits) {
            return 0L;
        }
        String tileMatrix = this.tileMatrixID[level];
        long[] limits = (long[])this.tileMatrixLimitsMap.get(tileMatrix);
        return limits[0];
    }

    long getTileMatrixLimitColMax(int level) {
        if (!this.hasLimits) {
            return this.matrixDim[level][0];
        }
        String tileMatrix = this.tileMatrixID[level];
        long[] limits = (long[])this.tileMatrixLimitsMap.get(tileMatrix);
        return limits[1];
    }

    long getTileMatrixLimitRowMin(int level) {
        if (!this.hasLimits) {
            return 0L;
        }
        String tileMatrix = this.tileMatrixID[level];
        long[] limits = (long[])this.tileMatrixLimitsMap.get(tileMatrix);
        return limits[2];
    }

    long getTileMatrixLimitRowMax(int level) {
        if (!this.hasLimits) {
            return this.matrixDim[level][1];
        }
        String tileMatrix = this.tileMatrixID[level];
        long[] limits = (long[])this.tileMatrixLimitsMap.get(tileMatrix);
        return limits[3];
    }

    boolean isInsideTileLimits(int level, long curCol, long curRow) {
        if (!this.hasLimits) {
            return true;
        }
        String tileMatrix = this.tileMatrixID[level];
        long[] limits = (long[])this.tileMatrixLimitsMap.get(tileMatrix);
        return curCol >= limits[0] && curCol <= limits[1] && curRow >= limits[2] && curRow <= limits[3];
    }

    public boolean isKVPEncoding() {
        return this.kvpForGetTile;
    }

    public class ReadXMLThread
    extends Thread {
        private String reqstr = null;
        private String xmlstr = null;

        public ReadXMLThread(String reqstr_) {
            this.reqstr = reqstr_;
        }

        @Override
        public void run() {
            try {
                long t0 = System.currentTimeMillis();
                this.xmlstr = Util.issueHttpGetRequest(this.reqstr);
                long t1 = System.currentTimeMillis();
                log.finest("Time spent on getting capabilities xml document from WMTS server: " + (t1 - t0) / 1000L + " sec.");
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }

        public String getXMLData() {
            return this.xmlstr;
        }
    }
}

