/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.sdovis.util.XMLDOMParser;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.GML;
import oracle.spatial.util.GML2;
import org.w3c.dom.Node;

public class GMLGeometryUtils {
    public static JGeometry parseGML(Node parent) throws Exception {
        String orientVector;
        String[] ov;
        if (parent == null) {
            return null;
        }
        Node gmlNode = XMLDOMParser.getSubElementStartsWith(parent, "gml");
        if (gmlNode == null) {
            return null;
        }
        JGeometry geom = null;
        geom = GML.fromNodeToGeometry((Node)gmlNode);
        Node ovNode = XMLDOMParser.getSubElement(parent, "orientation_vector");
        if (ovNode != null && (ov = (orientVector = ovNode.getTextContent().trim()).split(",")) != null) {
            int dim = geom.getDimensions();
            int srid = geom.getSRID();
            JGeometry[] elements = JGeometryUtil.getElements(geom);
            boolean modified = false;
            for (int i = 0; i < ov.length / 3; ++i) {
                int elemIndex = Integer.parseInt(ov[i * 3 + 0]);
                double[] values = new double[]{Double.parseDouble(ov[i * 3 + 1]), Double.parseDouble(ov[i * 3 + 2])};
                JGeometry elem = elements[elemIndex];
                if (!elem.isPoint()) continue;
                double[] pt = elem.getPoint();
                int[] elemInfo = new int[]{1, 1, 1, 3, 1, 0};
                double[] ords = new double[]{pt[0], pt[1], values[0], values[1]};
                elements[elemIndex] = new JGeometry(dim * 1000 + elem.getType(), srid, elemInfo, ords);
                modified = true;
            }
            if (modified) {
                geom = JGeometryUtil.append(elements, geom.getType() == 4);
            }
        }
        return geom;
    }

    public static String toGML(JGeometry geom) throws Exception {
        StringBuilder orientVector = new StringBuilder();
        StringBuilder arcVector = new StringBuilder();
        JGeometry theGeom = geom;
        if (geom.isOrientedPoint() || geom.isOrientedMultiPoint() || geom.getType() == 4) {
            int dim = geom.getDimensions();
            int srid = geom.getSRID();
            JGeometry[] elements = JGeometryUtil.getElements(geom);
            boolean modified = false;
            for (int i = 0; i < elements.length; ++i) {
                if (!elements[i].isOrientedPoint()) continue;
                double[] ords = elements[i].getOrdinatesArray();
                if (orientVector.length() > 0) {
                    orientVector.append(",");
                }
                orientVector.append(i);
                for (int j = 0; j < dim; ++j) {
                    orientVector.append("," + ords[dim + j]);
                }
                elements[i] = JGeometry.createPoint((double[])elements[i].getPoint(), (int)dim, (int)srid);
                modified = true;
            }
            if (modified) {
                theGeom = JGeometryUtil.append(elements, geom.getType() == 4);
            }
        }
        String gml = null;
        gml = GML2.to_GMLGeometry((JGeometry)theGeom);
        StringBuilder gmlSB = new StringBuilder(gml);
        if (orientVector.length() > 0) {
            gmlSB.append("\n<orientation_vector>");
            gmlSB.append((CharSequence)orientVector);
            gmlSB.append("</orientation_vector>");
        }
        if (arcVector.length() > 0) {
            gmlSB.append("\n<arc_vector>");
            gmlSB.append((CharSequence)arcVector);
            gmlSB.append("</arc_vector>");
        }
        return gmlSB.toString();
    }
}

