/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.spatial.geometry.BufGeom;
import oracle.spatial.geometry.JPoint2DD;

class SpatialSort
implements Iterable<BufGeom> {
    private ArrayList<BufGeom> mers = new ArrayList();
    private double maxMagnitude = 0.0;

    SpatialSort() {
    }

    void add(BufGeom bufGeom) {
        this.mers.add(bufGeom);
        this.maxMagnitude = Math.max(this.maxMagnitude, Math.abs(bufGeom.getMaxX()));
        this.maxMagnitude = Math.max(this.maxMagnitude, Math.abs(bufGeom.getMinX()));
        this.maxMagnitude = Math.max(this.maxMagnitude, Math.abs(bufGeom.getMaxY()));
        this.maxMagnitude = Math.max(this.maxMagnitude, Math.abs(bufGeom.getMinY()));
    }

    double getMaxMagnitude() {
        return this.maxMagnitude;
    }

    @Override
    public Iterator<BufGeom> iterator() {
        int n = this.mers.size();
        ArrayList<ArrayList<BufGeom>> arrayList = new ArrayList<ArrayList<BufGeom>>(2);
        arrayList.add(new ArrayList<BufGeom>(this.mers));
        arrayList.add(new ArrayList<BufGeom>(this.mers));
        Collections.sort((List)arrayList.get(0), new Comparator<BufGeom>(){

            @Override
            public final int compare(BufGeom bufGeom, BufGeom bufGeom2) {
                return Double.compare(bufGeom.getRepPt().x, bufGeom2.getRepPt().x);
            }
        });
        Collections.sort((List)arrayList.get(1), new Comparator<BufGeom>(){

            @Override
            public final int compare(BufGeom bufGeom, BufGeom bufGeom2) {
                return Double.compare(bufGeom.getRepPt().y, bufGeom2.getRepPt().y);
            }
        });
        this.QpatialQort(arrayList, 0, n - 1, 0);
        final ArrayList<BufGeom> arrayList2 = arrayList.get(0);
        arrayList = null;
        return new Iterator<BufGeom>(){
            int nxt = 0;

            @Override
            public boolean hasNext() {
                return this.nxt < arrayList2.size();
            }

            @Override
            public BufGeom next() {
                BufGeom bufGeom = (BufGeom)arrayList2.get(this.nxt);
                arrayList2.set(this.nxt, null);
                ++this.nxt;
                return bufGeom;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void QpatialQort(ArrayList<ArrayList<BufGeom>> arrayList, int n, int n2, int n3) {
        int n4;
        BufGeom bufGeom;
        int n5;
        int n6;
        double d;
        if (n >= n2) {
            return;
        }
        int n7 = (n + n2) / 2;
        double d2 = Math.abs(arrayList.get((int)0).get((int)n).getRepPt().x - arrayList.get((int)0).get((int)n2).getRepPt().x);
        n3 = d2 > (d = Math.abs(arrayList.get((int)1).get((int)n).getRepPt().y - arrayList.get((int)1).get((int)n2).getRepPt().y)) ? 0 : 1;
        ArrayList<BufGeom> arrayList2 = arrayList.get(n3);
        for (n6 = n; n6 <= n2; ++n6) {
            arrayList2.get((int)n6).flag = Integer.signum(n6 - n7);
        }
        n3 = 1 - n3;
        arrayList2 = arrayList.get(n3);
        n6 = n;
        int n8 = n7 + 1;
        for (n5 = n; n5 <= n2; ++n5) {
            bufGeom = arrayList2.get(n5);
            bufGeom.flag = bufGeom.flag < 0 ? n6++ : (bufGeom.flag > 0 ? n8++ : n7);
        }
        for (n5 = n; n5 <= n2; ++n5) {
            bufGeom = arrayList2.get(n5);
            n4 = bufGeom.flag;
            if (n4 == n5) continue;
            while (n4 != n5) {
                BufGeom bufGeom2 = arrayList2.get(n4);
                arrayList2.set(n4, bufGeom);
                bufGeom = bufGeom2;
                n4 = bufGeom.flag;
            }
            arrayList2.set(n5, bufGeom);
        }
        if (n7 - 1 > n) {
            this.QpatialQort(arrayList, n, n7 - 1, n3);
        }
        if (n7 + 1 < n2) {
            this.QpatialQort(arrayList, n7 + 1, n2, n3);
        }
        if (n2 - n + 1 < 4) {
            return;
        }
        double d3 = 0.0;
        for (n4 = n; n4 < n2; ++n4) {
            d3 += SpatialSort.distance(arrayList, n4, n4 + 1);
        }
        System.out.println("Before: " + d3);
        n4 = n7;
        if (SpatialSort.distance(arrayList, n7, n7 + 1) < SpatialSort.distance(arrayList, n7, n7 - 1)) {
            n4 = n7 - 1;
        }
        double d4 = SpatialSort.distance(arrayList, n4, n4 + 1);
        double d5 = SpatialSort.distance(arrayList, n, n4 + 1);
        double d6 = SpatialSort.distance(arrayList, n4, n2);
        double d7 = SpatialSort.distance(arrayList, n, n2);
        boolean bl = false;
        boolean bl2 = false;
        double d8 = d4;
        if (d5 < d8) {
            bl = true;
            bl2 = false;
            d8 = d5;
        }
        if (d6 < d8) {
            bl = false;
            bl2 = true;
            d8 = d6;
        }
        if (d7 < d8) {
            bl = true;
            bl2 = true;
            d8 = d7;
        }
        if (bl) {
            SpatialSort.reverse(arrayList, n, n4);
        }
        if (bl2) {
            SpatialSort.reverse(arrayList, n4 + 1, n2);
        }
        d3 = 0.0;
        for (int i = n; i < n2; ++i) {
            d3 += SpatialSort.distance(arrayList, i, i + 1);
        }
        System.out.println("After : " + bl + bl2 + " " + d3);
    }

    private static double distance(ArrayList<ArrayList<BufGeom>> arrayList, int n, int n2) {
        JPoint2DD jPoint2DD = arrayList.get(0).get(n).getRepPt();
        JPoint2DD jPoint2DD2 = arrayList.get(0).get(n2).getRepPt();
        return Math.sqrt((jPoint2DD.x - jPoint2DD2.x) * (jPoint2DD.x - jPoint2DD2.x) + (jPoint2DD.y - jPoint2DD2.y) * (jPoint2DD.y - jPoint2DD2.y));
    }

    private static void reverse(ArrayList<ArrayList<BufGeom>> arrayList, int n, int n2) {
        ArrayList<BufGeom> arrayList2 = arrayList.get(0);
        ArrayList<BufGeom> arrayList3 = arrayList.get(1);
        while (n < n2) {
            BufGeom bufGeom = arrayList2.get(n);
            arrayList2.set(n, arrayList2.get(n2));
            arrayList2.set(n2, bufGeom);
            bufGeom = arrayList3.get(n);
            arrayList3.set(n, arrayList3.get(n2));
            arrayList3.set(n2, bufGeom);
            ++n;
            --n2;
        }
    }
}

