/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.tablespacesets;

import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.Keyword;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.Operation;

public enum KeywordClause {
    LOGGING(Keyword.LOGGING, Keyword.NOLOGGING),
    FORCE_LOGGING(Keyword.YES, Keyword.NO),
    ENCRYPTION(Keyword.YES, Keyword.NO),
    ONLINE_STATUS(Keyword.OFFLINE, Keyword.ONLINE),
    SEGMENT_MANAGEMENT(Keyword.AUTO),
    EXTENT_MANAGEMENT(Keyword.LOCAL_SYSTEM, Keyword.LOCAL_UNIFORM),
    FLASHBACK(Keyword.YES, Keyword.NO),
    TABLE_COMPRESSION(Keyword.ENABLED_ADVANCED, Keyword.ENABLED_QUERY_LOW, Keyword.ENABLED_QUERY_HIGH, Keyword.ENABLED_ARCHIVE_LOW, Keyword.ENABLED_ARCHIVE_HIGH, Keyword.DISABLED),
    INDEX_COMPRESSION(Keyword.ENABLED_ADVANCED_HIGH, Keyword.ENABLED_ADVANCED_LOW, Keyword.DISABLED),
    INMEMORY_COMPRESSION(Keyword.FOR_DML, Keyword.FOR_QUERY, Keyword.FOR_QUERY_HIGH, Keyword.FOR_QUERY_LOW, Keyword.FOR_CAPACITY, Keyword.FOR_CAPACITY_HIGH, Keyword.FOR_CAPACITY_LOW, Keyword.NO_MEMCOMPRESS),
    INMEMORY_PRIORITY(Keyword.NONE, Keyword.LOW, Keyword.MEDIUM, Keyword.HIGH, Keyword.CRITICAL),
    INMEMORY_DISTRIBUTE(Keyword.DEFAULT, Keyword.AUTO, Keyword.BY_ROWID_RANGE),
    INMEMORY_FORSERVICE(Keyword.DEFAULT, Keyword.ALL, Keyword.NONE),
    INMEMORY_DUPLICATE(Keyword.DUPLICATE, Keyword.DUPLICATE_ALL, Keyword.NO_DUPLICATE);

    private final Keyword[] keywords;

    private KeywordClause(Keyword ... keywordArray) {
        this.keywords = keywordArray;
    }

    public Keyword[] getKeywords() {
        return this.keywords;
    }

    public Keyword getKeyword(String string) {
        if (!string.equals("")) {
            for (Keyword keyword : this.keywords) {
                if (!keyword.getNls().equals(string)) continue;
                return keyword;
            }
        }
        return null;
    }

    public String[] getUserSelectables(Operation operation) {
        String[] stringArray = operation == Operation.EDIT ? new String[this.keywords.length] : new String[1 + this.keywords.length];
        int n = 0;
        if (operation != Operation.EDIT) {
            stringArray[0] = "";
            ++n;
        }
        for (Keyword keyword : this.keywords) {
            stringArray[n++] = keyword.getNls();
        }
        return stringArray;
    }
}

