/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.tablespacesets;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.Operation;
import oracle.dbtools.raptor.utils.Connections;

public class TablespaceSetValues {
    private String tablespaceSet;
    private String shardSpace;
    private boolean dataFileSpecified;
    private int fileSize;
    private boolean autoExtend;
    private int initialSize;
    private int nextSize;
    private boolean unlimitedMaxSize;
    private int maxSize;
    private String blockSize;
    private String logging;
    private String forceLogging;
    private String encryption;
    private String encryptionAlgorith;
    private String onlineStatus;
    private String segmentSpaceManagement;
    private String extentManagement;
    private int minExtlen;
    private String flashback;
    private String defTabCompression;
    private String defIndexCompression;
    private boolean defInMemory;
    private String defInMemoryCompression;
    private String defInMemoryPriority;
    private String defInMemoryDistribute;
    private String defInMemoryService;
    private String defInMemoryDuplicate;
    private final Operation op;
    private final Function<String, String> queryGetter;

    public TablespaceSetValues(Operation operation, Function<String, String> function) {
        this.op = operation;
        this.queryGetter = function;
        this.initialSize = this.fileSize = 0x6400000;
        this.nextSize = this.fileSize;
        this.maxSize = this.fileSize;
        this.unlimitedMaxSize = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromCatalog(Connection connection, String string) {
        block8: {
            if (Connections.getInstance().lock(connection)) {
                this.tablespaceSet = string;
                ResultSet resultSet = null;
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("NAME", string);
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.queryGetter.apply("getTablespaceSet"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            this.shardSpace = resultSet.getString("SHARDSPACE");
                            this.dataFileSpecified = true;
                            this.fileSize = resultSet.getInt("FILE_SIZE");
                            this.autoExtend = resultSet.getString("AUTO_EXTEND").equals("YES");
                            this.initialSize = resultSet.getInt("INITIAL_EXTENT");
                            this.nextSize = resultSet.getInt("NEXT_SIZE");
                            this.unlimitedMaxSize = false;
                            this.maxSize = resultSet.getInt("MAX_SIZE");
                            this.blockSize = resultSet.getString("BLOCK_SIZE");
                            this.logging = resultSet.getString("LOGGING");
                            this.forceLogging = resultSet.getString("FORCE_LOGGING");
                            this.encryption = resultSet.getString("ENCRYPTED");
                            this.encryptionAlgorith = resultSet.getString("ENCRYPTIONALG");
                            this.onlineStatus = resultSet.getString("ONLINE_STATUS").equals("ONLINE") ? "ONLINE" : "OFFLINE";
                            this.segmentSpaceManagement = resultSet.getString("SEGMENT_SPACE_MANAGEMENT");
                            this.extentManagement = resultSet.getString("EXTENT_MANAGEMENT");
                            this.minExtlen = resultSet.getInt("MIN_EXTLEN");
                            this.flashback = resultSet.getString("FLASHBACK_ON");
                            this.defTabCompression = resultSet.getString("DEF_TAB_COMPRESSION");
                            this.defIndexCompression = resultSet.getString("DEF_INDEX_COMPRESSION");
                            this.defInMemory = resultSet.getString("DEF_INMEMORY").equals("ENABLED");
                            this.defInMemoryCompression = resultSet.getString("DEF_INMEMORY_COMPRESSION");
                            this.defInMemoryPriority = resultSet.getString("DEF_INMEMORY_PRIORITY");
                            this.defInMemoryDistribute = resultSet.getString("DEF_INMEMORY_DISTRIBUTE");
                            this.defInMemoryService = resultSet.getString("DEF_INMEMORY_SERVICE");
                            this.defInMemoryDuplicate = resultSet.getString("DEF_INMEMORY_DUPLICATE");
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public Operation getOperation() {
        return this.op;
    }

    public String getTablespaceSet() {
        return this.tablespaceSet;
    }

    public String getShardSpace() {
        return this.shardSpace;
    }

    public boolean isDataFileSpecified() {
        return this.dataFileSpecified;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public boolean isAutoExtend() {
        return this.autoExtend;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public int getNextSize() {
        return this.nextSize;
    }

    public boolean isUnlimitedMaxSize() {
        return this.unlimitedMaxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getBlockSize() {
        return this.blockSize;
    }

    public String getLogging() {
        return this.logging;
    }

    public String getForceLogging() {
        return this.forceLogging;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public String getEncryptionAlgorith() {
        return this.encryptionAlgorith;
    }

    public String getOnlineStatus() {
        return this.onlineStatus;
    }

    public String getSegmentSpaceManagement() {
        return this.segmentSpaceManagement;
    }

    public String getExtentManagement() {
        return this.extentManagement;
    }

    public int getMinExtlen() {
        return this.minExtlen;
    }

    public String getFlashback() {
        return this.flashback;
    }

    public String getDefTabCompression() {
        return this.defTabCompression;
    }

    public String getDefIndexCompression() {
        return this.defIndexCompression;
    }

    public boolean isDefInMemory() {
        return this.defInMemory;
    }

    public String getDefInMemoryCompression() {
        return this.defInMemoryCompression;
    }

    public String getDefInMemoryPriority() {
        return this.defInMemoryPriority;
    }

    public String getDefInMemoryDistribute() {
        return this.defInMemoryDistribute;
    }

    public String getDefInMemoryService() {
        return this.defInMemoryService;
    }

    public String getDefInMemoryDuplicate() {
        return this.defInMemoryDuplicate;
    }
}

