/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.shardconsole;

import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import oracle.dbtools.raptor.metrics.control.LayoutHelper;

public class DirectorIcon
extends Region {
    private final Circle outerCircle = new Circle();
    private final Circle innerCircle = new Circle();
    private final Path northArrow = new Path();
    private final Path southArrow = new Path();
    private final Path westArrow = new Path();
    private final Path eastArrow = new Path();

    public DirectorIcon() {
        this.getStyleClass().add((Object)"director-icon");
        this.outerCircle.getStyleClass().add((Object)"outer-circle");
        this.innerCircle.getStyleClass().add((Object)"inner-circle");
        this.northArrow.getStyleClass().add((Object)"north-arrow");
        this.southArrow.getStyleClass().add((Object)"south-arrow");
        this.westArrow.getStyleClass().add((Object)"west-arrow");
        this.eastArrow.getStyleClass().add((Object)"east-arrow");
        this.getChildren().setAll((Object[])new Node[]{this.outerCircle, this.innerCircle, this.northArrow, this.southArrow, this.westArrow, this.eastArrow});
    }

    protected double computeMaxWidth(double d) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double d) {
        return Double.MAX_VALUE;
    }

    protected void layoutChildren() {
        LayoutHelper layoutHelper = new LayoutHelper((Region)this);
        double d = layoutHelper.width();
        double d2 = layoutHelper.height();
        double d3 = 0.5 * d;
        double d4 = 0.5 * d2;
        double d5 = Math.min(d3, d4);
        this.layoutCircle(this.outerCircle, d3, d4, d5);
        this.layoutCircle(this.innerCircle, d3, d4, 0.8 * d5);
        this.layoutDownArrow(this.northArrow, d3, d4 + 0.8 * d5, 0.8 * d5);
        this.layoutUpArrow(this.southArrow, d3, d4 - 0.8 * d5, 0.8 * d5);
        this.layoutLeftArrow(this.westArrow, d3 - 0.8 * d5, d4, 0.8 * d5);
        this.layoutRightArrow(this.eastArrow, d3 + 0.8 * d5, d4, 0.8 * d5);
    }

    private void layoutCircle(Circle circle, double d, double d2, double d3) {
        circle.setCenterX(d);
        circle.setCenterY(d2);
        circle.setRadius(d3);
    }

    private void layoutDownArrow(Path path, double d, double d2, double d3) {
        double d4 = d;
        double d5 = d2 - d3;
        double d6 = d4 - 0.1 * d3;
        double d7 = d5 + 0.29 * d3;
        double d8 = d4 + 0.1 * d3;
        double d9 = d7;
        double d10 = d8;
        double d11 = d9 + 0.25 * d3;
        double d12 = d6;
        double d13 = d11;
        double d14 = d10 + 0.17 * d3;
        double d15 = d11;
        double d16 = d12 - 0.17 * d3;
        double d17 = d11;
        double d18 = d4;
        double d19 = d15 + 0.29 * d3;
        path.getElements().setAll((Object[])new PathElement[]{new MoveTo(d6, d7), new LineTo(d8, d9), new LineTo(d10, d11), new LineTo(d14, d15), new LineTo(d18, d19), new LineTo(d16, d17), new LineTo(d12, d13), new ClosePath()});
    }

    private void layoutUpArrow(Path path, double d, double d2, double d3) {
        double d4 = d;
        double d5 = d2 + d3;
        double d6 = d4 - 0.1 * d3;
        double d7 = d5 - 0.29 * d3;
        double d8 = d4 + 0.1 * d3;
        double d9 = d7;
        double d10 = d8;
        double d11 = d9 - 0.25 * d3;
        double d12 = d6;
        double d13 = d11;
        double d14 = d10 + 0.17 * d3;
        double d15 = d11;
        double d16 = d12 - 0.17 * d3;
        double d17 = d11;
        double d18 = d4;
        double d19 = d15 - 0.29 * d3;
        path.getElements().setAll((Object[])new PathElement[]{new MoveTo(d6, d7), new LineTo(d8, d9), new LineTo(d10, d11), new LineTo(d14, d15), new LineTo(d18, d19), new LineTo(d16, d17), new LineTo(d12, d13), new ClosePath()});
    }

    private void layoutLeftArrow(Path path, double d, double d2, double d3) {
        double d4 = d2;
        double d5 = d + 0.17 * d3;
        double d6 = d2 - 0.1 * d3;
        double d7 = d5;
        double d8 = d2 + 0.1 * d3;
        double d9 = d7 + 0.25 * d3;
        double d10 = d8;
        double d11 = d9;
        double d12 = d6;
        double d13 = d9;
        double d14 = d10 + 0.17 * d3;
        double d15 = d11;
        double d16 = d12 - 0.17 * d3;
        double d17 = d13 + 0.29 * d3;
        double d18 = d4;
        path.getElements().setAll((Object[])new PathElement[]{new MoveTo(d5, d6), new LineTo(d7, d8), new LineTo(d9, d10), new LineTo(d13, d14), new LineTo(d17, d18), new LineTo(d15, d16), new LineTo(d11, d12), new ClosePath()});
    }

    private void layoutRightArrow(Path path, double d, double d2, double d3) {
        double d4 = d2;
        double d5 = d - 0.17 * d3;
        double d6 = d2 - 0.1 * d3;
        double d7 = d5;
        double d8 = d2 + 0.1 * d3;
        double d9 = d7 - 0.25 * d3;
        double d10 = d8;
        double d11 = d9;
        double d12 = d6;
        double d13 = d9;
        double d14 = d10 + 0.17 * d3;
        double d15 = d11;
        double d16 = d12 - 0.17 * d3;
        double d17 = d13 - 0.29 * d3;
        double d18 = d4;
        path.getElements().setAll((Object[])new PathElement[]{new MoveTo(d5, d6), new LineTo(d7, d8), new LineTo(d9, d10), new LineTo(d13, d14), new LineTo(d17, d18), new LineTo(d15, d16), new LineTo(d11, d12), new ClosePath()});
    }
}

