/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizMain;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;

public class DpExpWizSource
extends DefaultTraversablePanel
implements LayoutControl {
    private JRadioButton _rbDatabase = new JRadioButton(DpWizardArb.getString("EXP_DATABASE"));
    private JRadioButton _rbTablespace = new JRadioButton(DpWizardArb.getString("EXP_TABLESPACE"));
    private JRadioButton _rbSchema = new JRadioButton(DpWizardArb.getString("EXP_SCHEMA"));
    private JRadioButton _rbTable = new JRadioButton(DpWizardArb.getString("EXP_TABLE"));
    private Boolean _isSYS = Boolean.FALSE;
    private ButtonGroup _bGroup = null;
    private JPanel _jp = null;
    private MetadataEnum _storeMeta = MetadataEnum.BOTH;
    private JComboBox<String> _connCombo;
    private JComboBox<String> _dataMeta;
    private DBConnectionComboBox _connSelector;
    private static final long serialVersionUID = 1L;
    private ExtractListModel _listModel;
    private boolean _wipeListModel = false;
    private Boolean _isPrivileged = Boolean.FALSE;
    private TraversableContext _dataContext;
    private ActionListener _actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DpExpWizSource.this.connectionChanged(actionEvent);
        }
    };

    public DpExpWizSource() {
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        this._rbTable.setSelected(true);
        this._rbTablespace.setSelected(false);
        this._rbSchema.setSelected(false);
        this._rbDatabase.setSelected(false);
        this._bGroup = new ButtonGroup();
        this._bGroup.add(this._rbDatabase);
        this._bGroup.add(this._rbTablespace);
        this._bGroup.add(this._rbSchema);
        this._bGroup.add(this._rbTable);
        this._dataMeta = new JComboBox<String>(new String[]{DpWizardArb.getString("EXP_DDL_COMBO_BOTH"), DpWizardArb.getString("EXP_DDL_COMBO_DATA"), DpWizardArb.getString("EXP_DDL_COMBO_DLL")});
        this._connSelector = new OracleConnectionComboBox();
        this._connCombo = this._connSelector.getJComboBox();
        this._connCombo.addActionListener(this._actionListener);
        this._jp = new JPanel();
        this._jp.setLayout(new GridBagLayout());
        this._jp.add(Box.createVerticalGlue(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.3, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._jp.add((Component)this._rbDatabase, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.PAGE_START_FULL_SUB));
        this._jp.add((Component)this._rbTablespace, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_FULL_SUB));
        this._jp.add((Component)this._rbSchema, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_FULL_SUB));
        this._jp.add((Component)this._rbTable, LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.PAGE_END_FULL_SUB));
        this._jp.add(Box.createHorizontalGlue(), LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._jp.setBorder(BorderFactory.createTitledBorder(DpWizardArb.getString("EXP_TYPE_LABEL")));
        this.add(new JLabel(DpWizardArb.getString("EXP_CONNECTION")), LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START));
        this.add(this._connCombo, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_END_LABEL2CONTROL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this.add(new JLabel(DpWizardArb.getString("EXP_DDL_LABEL")), LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START));
        this.add(this._dataMeta, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_END_LABEL2CONTROL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this.add(Box.createHorizontalGlue(), LayoutControl.GBC.gbc((int)3, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(this._jp, LayoutControl.GBC.gbc((int)0, (int)2, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.PAGE_END_FULL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(Box.createVerticalGlue(), LayoutControl.GBC.gbc((int)0, (int)3, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
    }

    public void connectionChanged(ActionEvent actionEvent) {
        String string = this._connSelector.getCurrentConnectionName();
        if (string == null || string.equals("")) {
            return;
        }
        String string2 = (String)this._listModel.getPropertyValue("KEY_CNAME");
        if (string2 != null && !string2.equals(string)) {
            this.wipeListModel();
        }
        boolean bl = false;
        if (string2 == null || !string2.equals(string)) {
            bl = true;
        }
        this._listModel.setProperty("KEY_CNAME", (Object)string);
        if (!bl) {
            return;
        }
        DatabaseQueryTask<TraversalException> databaseQueryTask = new DatabaseQueryTask<TraversalException>(DpWizardArb.getString("EXP_CALCULATE"), IRaptorTaskRunMode.MODAL, false, false){

            public void canProceedTask() throws ExecutionException {
                this.checkCanProceed();
            }

            protected TraversalException doWork() throws TaskException {
                TraversalException traversalException = null;
                try {
                    DpWizCommon.setupConnection(DpExpWizSource.this._listModel, true);
                }
                catch (TraversalException traversalException2) {
                    traversalException = traversalException2;
                }
                return traversalException;
            }

            public String getQuery() {
                return DpWizardArb.getString("EXP_GET_DATABASE_SETTINGS");
            }

            public String getConnectionName() {
                return (String)DpExpWizSource.this._listModel.getPropertyValue("KEY_CNAME");
            }
        };
        RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter((DatabaseQueryTask)databaseQueryTask){
            final /* synthetic */ DatabaseQueryTask val$task;
            {
                this.val$task = databaseQueryTask;
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TraversalException traversalException = null;
                        String string = null;
                        try {
                            traversalException = (TraversalException)((Object)val$task.getResult());
                        }
                        catch (InterruptedException interruptedException) {
                            string = DpWizardArb.getString("IMP_EXCEPTION_OCCURRED");
                            traversalException = new TraversalException(DpWizardArb.format("IMP_EXCEPTION", interruptedException.getLocalizedMessage()), string);
                        }
                        catch (ExecutionException executionException) {
                            string = DpWizardArb.getString("IMP_EXCEPTION_OCCURRED");
                            traversalException = new TraversalException(DpWizardArb.format("IMP_EXCEPTION", executionException.getLocalizedMessage()), string);
                        }
                        if (traversalException != null) {
                            traversalException.showMessageDialog((Component)((Object)DpExpWizSource.this));
                            return;
                        }
                        try {
                            DpExpWizSource.this.connectionChangedUI();
                            DpExpWizSource.this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TraversalException traversalException = new TraversalException(DpWizardArb.getString("IMP_TASK_FAILED"), DpWizardArb.getString("IMP_TASK_FAILED"));
                        traversalException.showMessageDialog((Component)((Object)DpExpWizSource.this));
                    }
                });
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TraversalException traversalException = new TraversalException(DpWizardArb.getString("IMP_TASK_CANCELLED_CANCEL_WIZARD"), DpWizardArb.getString("IMP_TASK_CANCELLED"));
                        traversalException.showMessageDialog((Component)((Object)DpExpWizSource.this));
                    }
                });
            }
        };
        this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)raptorTaskAdapter);
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
    }

    public void connectionChangedUI() {
        this._isSYS = (Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_IS_SYS", Boolean.FALSE);
        if (this._isSYS.equals(Boolean.TRUE)) {
            this._rbTablespace.setEnabled(false);
            this._rbDatabase.setEnabled(false);
            this._rbTable.setEnabled(false);
            this._rbSchema.setEnabled(false);
        } else {
            this._isPrivileged = (Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_IS_PRIV", Boolean.FALSE);
            if (this._isPrivileged.equals(Boolean.TRUE)) {
                this._rbTablespace.setEnabled(true);
                this._rbDatabase.setEnabled(true);
                this._rbTable.setEnabled(true);
                this._rbSchema.setEnabled(true);
            } else {
                this._rbTablespace.setEnabled(false);
                this._rbDatabase.setEnabled(false);
                if (this._rbTablespace.isSelected() || this._rbDatabase.isSelected()) {
                    this._rbTable.setSelected(true);
                }
                this._rbTable.setEnabled(true);
                this._rbSchema.setEnabled(true);
            }
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this._dataContext = traversableContext;
        this._listModel = (ExtractListModel)DpExpWizMain.getOrInitializeContext(traversableContext, "KEY_EXPORT_OBJECTS", new ExtractListModel());
        super.onEntry(traversableContext);
        this._rbTable.setSelected(false);
        this._rbTablespace.setSelected(false);
        this._rbSchema.setSelected(false);
        this._rbDatabase.setSelected(false);
        String string = (String)DpWizCommon.getOrInitializeList(this._listModel, "DP_KEY_BRANCH", "DP_TABLE");
        if (string.equals("DP_DATABASE")) {
            this._rbDatabase.setSelected(true);
        } else if (string.equals("DP_TABLESPACE")) {
            this._rbTablespace.setSelected(true);
        } else if (string.equals("DP_SCHEMA")) {
            this._rbSchema.setSelected(true);
        } else if (string.equals("DP_TABLE")) {
            this._rbTable.setSelected(true);
        }
        if (traversableContext.getDirection() == 1 && ((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "SKIP_TO_OSS", Boolean.FALSE)).booleanValue()) {
            this._dataContext.getWizardCallbacks().wizardSkipCurrentStep();
            return;
        }
        this._storeMeta = (MetadataEnum)((Object)DpWizCommon.getOrInitializeList(this._listModel, "DP_KEY_STOREMETA", (Object)MetadataEnum.BOTH));
        int n = 0;
        switch (this._storeMeta) {
            case BOTH: {
                n = 0;
                break;
            }
            case DATA: {
                n = 1;
                break;
            }
            case DDL: {
                n = 2;
            }
        }
        this._dataMeta.setSelectedItem(n);
        this._connCombo = this._connSelector.getJComboBox();
        String string2 = (String)this._listModel.getPropertyValue("KEY_CNAME");
        if (string2 == null) {
            Connection connection = ((DBObject)traversableContext.get("DBOBJECT")).getConnection();
            try {
                string2 = Connections.getInstance().getConnectionName(connection);
                this._connCombo.setSelectedItem(string2);
            }
            catch (Exception exception) {
                TraversalException traversalException = new TraversalException(DpWizardArb.getString("CONNECTION_NOT_AVAIL"), DpWizardArb.getString("IMP_TASK_FAILED"));
                traversalException.showMessageDialog((Component)((Object)this));
            }
        } else {
            this._connCombo.removeActionListener(this._actionListener);
            this._connCombo.addItem(string2);
            this._connCombo.setSelectedItem(string2);
            this._connCombo.addActionListener(this._actionListener);
        }
        this._connCombo.setEnabled(false);
    }

    private void wipeListModel() {
        this._listModel = new ExtractListModel();
        this._dataContext.put("KEY_EXPORT_OBJECTS", (Object)this._listModel);
        ExtractDataFormat extractDataFormat = new ExtractDataFormat(BaseDataFormat.EXPORT_WIZARD);
        extractDataFormat.setFormat(BaseDataFormat.DATAPUMP);
        extractDataFormat.isExportEnabled(true);
        this._listModel.setDataFormat(extractDataFormat);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Connection connection;
        if (traversableContext.getDirection() == 1 && ((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "SKIP_TO_OSS", Boolean.FALSE)).booleanValue()) {
            this._dataContext.getWizardCallbacks().wizardSkipCurrentStep();
            return;
        }
        if (traversableContext.getDirection() == 1 && this._isSYS.equals(Boolean.TRUE)) {
            throw new TraversalException(DpWizardArb.getString("EXP_SYS_WARNING"), DpWizardArb.getString("EXP_PRIV_ERROR"));
        }
        super.onExit(traversableContext);
        String string = this._connSelector.getCurrentConnectionName();
        if (traversableContext.getDirection() == 1 && (string == null || string.trim().equals(""))) {
            throw new TraversalException(DpWizardArb.getString("EXP_NO_CONNECTION"));
        }
        Connection connection2 = null;
        Connection connection3 = null;
        try {
            connection3 = Connections.getInstance().getConnection((String)this._listModel.getPropertyValue("KEY_CNAME"));
        }
        catch (DBException dBException) {
            throw new TraversalException(DpWizardArb.getString("EXP_NO_CONNECTION"));
        }
        connection2 = connection = connection3;
        traversableContext.put("KEY_CNAME", (Object)string);
        this._listModel.setProperty("KEY_CNAME", (Object)string);
        this._storeMeta = MetadataEnum.BOTH;
        switch (this._dataMeta.getSelectedIndex()) {
            case 0: {
                this._storeMeta = MetadataEnum.BOTH;
                break;
            }
            case 1: {
                this._storeMeta = MetadataEnum.DATA;
                break;
            }
            case 2: {
                this._storeMeta = MetadataEnum.DDL;
            }
        }
        this._listModel.setProperty("DP_KEY_STOREMETA", (Object)this._storeMeta);
        if (this._rbDatabase.isSelected()) {
            this._listModel.setProperty("DP_KEY_BRANCH", (Object)"DP_DATABASE");
        } else if (this._rbTablespace.isSelected()) {
            this._listModel.setProperty("DP_KEY_BRANCH", (Object)"DP_TABLESPACE");
        } else if (this._rbSchema.isSelected()) {
            this._listModel.setProperty("DP_KEY_BRANCH", (Object)"DP_SCHEMA");
        } else if (this._rbTable.isSelected()) {
            this._listModel.setProperty("DP_KEY_BRANCH", (Object)"DP_TABLE");
        }
        this._listModel.setProperty("DP_KEY_IS_PRIVILIGED", (Object)this._isPrivileged);
        traversableContext.put("KEY_EXPORT_OBJECTS", (Object)this._listModel);
        String string2 = (String)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_JNAME", "");
        if (string2.equals("")) {
            string2 = (String)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_GEN_NAME", "");
        }
        this._listModel.setProperty("DP_EXP_JNAME", (Object)string2);
        this.setThisSchemaOrAllTheSchemas(traversableContext);
    }

    public Object getExitTransition() {
        if (((MetadataEnum)((Object)this._listModel.getPropertyValue("DP_KEY_STOREMETA"))).equals((Object)MetadataEnum.DDL)) {
            this._listModel.clearSelectExtractData();
        }
        if (this._rbSchema.isSelected()) {
            return "TRANSSchema";
        }
        if (this._rbTablespace.isSelected()) {
            return "TRANSTablespace";
        }
        if (this._rbDatabase.isSelected()) {
            return "TRANSFilterOptions";
        }
        if (((MetadataEnum)((Object)this._listModel.getPropertyValue("DP_KEY_STOREMETA"))).equals((Object)MetadataEnum.DATA) && this._rbTable.isSelected()) {
            this._listModel.setProperty("DP_EXP_INCLUDE_EXCLUDE_DIR_FILE", new ArrayList());
            return "TRANSTableData";
        }
        return "TRANSTable";
    }

    void setThisSchemaOrAllTheSchemas(TraversableContext traversableContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = (List)this._listModel.getPropertyValue("EXP_ALL_USERS");
        if (this._listModel.getPropertyValue("DP_KEY_IS_PRIVILIGED").equals(Boolean.FALSE)) {
            list = (List)this._listModel.getPropertyValue("EXP_THIS_USER");
        }
        for (Map map : list) {
            arrayList.add((String)map.get("USERNAME"));
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        traversableContext.put("EXTRACT_SCHEMA_LIST", arrayList);
        if (this._listModel.getSchemas() != null) {
            if (DpWizCommon.compareStringList(this._listModel.getSchemas(), stringArray)) {
                traversableContext.put("EXTRACT_LIST_UPDATED", (Object)false);
            } else {
                traversableContext.put("EXTRACT_LIST_UPDATED", (Object)true);
            }
        } else {
            traversableContext.put("EXTRACT_LIST_UPDATED", (Object)false);
        }
        traversableContext.put("EXTRACT_SCHEMA_LIST", arrayList);
        this._listModel.setSchemas(stringArray);
    }

    public static enum MetadataEnum {
        BOTH,
        DATA,
        DDL;

    }
}

