/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.controlflow;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mb.flowspec.controlflow.ControlFlowGraphBuilder;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.controlflow.IControlFlowGraph;
import mb.flowspec.controlflow.ImmutableCFGNode;
import mb.flowspec.controlflow.ImmutableTransferFunctionAppl;
import mb.flowspec.controlflow.TransferFunctionAppl;
import mb.flowspec.terms.ImmutableTermIndex;
import mb.flowspec.terms.TermIndex;
import mb.flowspec.terms.TermIndexed;
import mb.nabl2.util.Tuple2;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.M;

public class ControlFlowGraphReader {
    protected final ControlFlowGraphBuilder cfg = ControlFlowGraphBuilder.of();
    protected final Map<Tuple2<ICFGNode, String>, TransferFunctionAppl> tfAppls = new HashMap<Tuple2<ICFGNode, String>, TransferFunctionAppl>();

    protected ControlFlowGraphReader() {
    }

    public static ControlFlowGraphReader build(IStrategoTerm current) {
        ControlFlowGraphReader b = new ControlFlowGraphReader();
        b.process(current);
        return b;
    }

    public IControlFlowGraph cfg() {
        return this.cfg.build();
    }

    public Map<Tuple2<ICFGNode, String>, TransferFunctionAppl> tfAppls() {
        return Collections.unmodifiableMap(this.tfAppls);
    }

    protected void process(IStrategoTerm current) {
        IStrategoList list = M.list(current);
        for (IStrategoTerm term : list) {
            switch (M.appl(term).getName()) {
                case "CFDirectEdge": {
                    IStrategoAppl appl = M.appl(term, 3);
                    ICFGNode sourceNode = ControlFlowGraphReader.cfgNode(M.at(appl, 0));
                    ICFGNode targetNode = ControlFlowGraphReader.cfgNode(M.at(appl, 1));
                    this.addCFGNode(sourceNode);
                    this.addCFGNode(targetNode);
                    this.cfg.edges().__insert((Object)sourceNode, (Object)targetNode);
                    break;
                }
                case "CTFAppl": {
                    IStrategoAppl appl = M.appl(term, 5);
                    ICFGNode cfgNode = ControlFlowGraphReader.cfgNode(M.at(appl, 0));
                    String propName = M.string(M.at(appl, 1));
                    String modName = M.string(M.at(appl, 2));
                    int offset = M.integer(M.at(appl, 3));
                    IStrategoList argsList = M.list(M.at(appl, 4));
                    List<IStrategoTerm> args = Arrays.asList(TermIndexed.excludeTermIndexFromEqual(argsList.getAllSubterms()));
                    this.tfAppls.put(Tuple2.of(cfgNode, propName), ImmutableTransferFunctionAppl.of(modName, offset, args));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unable to parse CFG constraint: " + term));
                }
            }
        }
    }

    public static ICFGNode cfgNode(IStrategoTerm term) {
        if (term instanceof ICFGNode) {
            return (ICFGNode)term;
        }
        IStrategoAppl appl = M.appl(term, "CFGNode", 3);
        TermIndex index = ControlFlowGraphReader.termIndex(M.at(appl, 0));
        String name = M.string(M.at(appl, 1));
        ICFGNode.Kind kind = ControlFlowGraphReader.kind(M.at(appl, 2));
        return ImmutableCFGNode.of(index, name, kind);
    }

    public static TermIndex termIndex(IStrategoTerm term) {
        if (term instanceof TermIndex) {
            return (TermIndex)term;
        }
        IStrategoAppl appl = M.appl(term, "TermIndex", 2);
        String resource = M.string(M.at(appl, 0));
        int id = M.integer(M.at(appl, 1));
        return ImmutableTermIndex.of(resource, id);
    }

    public static ICFGNode.Kind kind(IStrategoTerm term) {
        IStrategoAppl appl = M.appl(term, 0);
        return ICFGNode.Kind.valueOf(appl.getName());
    }

    protected void addCFGNode(ICFGNode node) {
        switch (node.getKind()) {
            case Start: {
                this.cfg.startNodes().add(node);
                break;
            }
            case End: {
                this.cfg.endNodes().add(node);
                break;
            }
            case Entry: {
                this.cfg.entryNodes().add(node);
                break;
            }
            case Exit: {
                this.cfg.exitNodes().add(node);
                break;
            }
            case Normal: {
                this.cfg.normalNodes().add(node);
            }
        }
    }
}

