/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.primitives;

import java.util.Optional;
import java.util.Set;
import mb.flowspec.controlflow.ControlFlowGraphBuilder;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.controlflow.ImmutableCFGNode;
import mb.flowspec.terms.TermIndex;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.Strategy;

abstract class RegisterNode
extends Strategy {
    private final ICFGNode.Kind kind;

    RegisterNode(ICFGNode.Kind kind) {
        this.kind = kind;
    }

    @Override
    public IStrategoTerm invoke(Context context, IStrategoTerm current) {
        Optional<TermIndex> optIndex = TermIndex.get(current);
        if (!optIndex.isPresent()) {
            return null;
        }
        TermIndex index = optIndex.get();
        String name = TermUtils.isAppl(current) ? ((IStrategoAppl)current).getName() : current.toString(0);
        ImmutableCFGNode node = ImmutableCFGNode.of(index, name, this.kind);
        this.nodes().add(node);
        return node;
    }

    public abstract Set<ICFGNode> nodes();

    public static final class RegisterEndNode
    extends RegisterNode {
        private final ControlFlowGraphBuilder builder;

        RegisterEndNode(ControlFlowGraphBuilder builder) {
            super(ICFGNode.Kind.End);
            this.builder = builder;
        }

        @Override
        public Set<ICFGNode> nodes() {
            return this.builder.endNodes();
        }
    }

    public static final class RegisterEntryNode
    extends RegisterNode {
        private final ControlFlowGraphBuilder builder;

        RegisterEntryNode(ControlFlowGraphBuilder builder) {
            super(ICFGNode.Kind.Entry);
            this.builder = builder;
        }

        @Override
        public Set<ICFGNode> nodes() {
            return this.builder.entryNodes();
        }
    }

    public static final class RegisterExitNode
    extends RegisterNode {
        private final ControlFlowGraphBuilder builder;

        RegisterExitNode(ControlFlowGraphBuilder builder) {
            super(ICFGNode.Kind.Exit);
            this.builder = builder;
        }

        @Override
        public Set<ICFGNode> nodes() {
            return this.builder.exitNodes();
        }
    }

    public static final class RegisterNormalNode
    extends Strategy {
        private static final ICFGNode.Kind kind = ICFGNode.Kind.Normal;
        private final ControlFlowGraphBuilder builder;

        RegisterNormalNode(ControlFlowGraphBuilder builder) {
            this.builder = builder;
        }

        @Override
        public IStrategoTerm invoke(Context context, IStrategoTerm current, IStrategoTerm targ1) {
            Optional<TermIndex> optIndex = TermIndex.get(current);
            if (!optIndex.isPresent()) {
                return null;
            }
            TermIndex index = optIndex.get();
            String name = TermUtils.isString(targ1) ? ((IStrategoString)targ1).stringValue().replaceFirst("^_", "") : targ1.toString(0);
            ImmutableCFGNode node = ImmutableCFGNode.of(index, name, kind);
            this.nodes().add(node);
            return node;
        }

        public Set<ICFGNode> nodes() {
            return this.builder.normalNodes();
        }
    }

    public static final class RegisterStartNode
    extends RegisterNode {
        private final ControlFlowGraphBuilder builder;

        RegisterStartNode(ControlFlowGraphBuilder builder) {
            super(ICFGNode.Kind.Start);
            this.builder = builder;
        }

        @Override
        public Set<ICFGNode> nodes() {
            return this.builder.startNodes();
        }
    }
}

