/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import io.usethesource.capsule.Set;
import mb.flowspec.runtime.interpreter.UnreachableException;
import mb.flowspec.runtime.interpreter.expressions.CompPredicateNode;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.patterns.PatternNode;
import mb.flowspec.runtime.interpreter.values.Set;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class SetCompNode
extends ExpressionNode {
    public final ExpressionNode expression;
    public final PatternNode[] sourcePatterns;
    public final ExpressionNode[] sources;
    public final CompPredicateNode[] predicates;

    public SetCompNode(ExpressionNode expression, PatternNode[] sourcePatterns, ExpressionNode[] sources, CompPredicateNode[] predicates) {
        this.expression = expression;
        this.sourcePatterns = sourcePatterns;
        this.sources = sources;
        this.predicates = predicates;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        try {
            return this.executeISet(frame);
        }
        catch (UnexpectedResultException e) {
            throw new UnreachableException((Exception)((Object)e));
        }
    }

    @Override
    public IStrategoTerm executeIStrategoTerm(VirtualFrame frame) {
        try {
            return this.executeISet(frame);
        }
        catch (UnexpectedResultException e) {
            throw new UnreachableException((Exception)((Object)e));
        }
    }

    public Set<IStrategoTerm> executeISet(VirtualFrame frame) throws UnexpectedResultException {
        Set.Immutable<IStrategoTerm> set = this.sources[0].executeISet(frame).getSet();
        Set.Transient result = Set.Transient.of();
        for (Object value : set) {
            boolean keep = this.sourcePatterns[0].matchGeneric(frame, value);
            CompPredicateNode[] compPredicateNodeArray = this.predicates;
            int n = this.predicates.length;
            int n2 = 0;
            while (n2 < n) {
                CompPredicateNode pred = compPredicateNodeArray[n2];
                keep &= pred.executeBoolean(frame);
                ++n2;
            }
            if (!keep) continue;
            result.__insert((Object)this.expression.executeIStrategoTerm(frame));
        }
        return new Set<IStrategoTerm>(result.freeze());
    }
}

