/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.expressions.SetUnionNode;
import mb.flowspec.runtime.interpreter.values.EmptyMapOrSet;
import mb.flowspec.runtime.interpreter.values.IMap;
import mb.flowspec.runtime.interpreter.values.ISet;
import mb.flowspec.terms.IStrategoAppl2;

@GeneratedBy(value=SetUnionNode.class)
public final class SetUnionNodeGen
extends SetUnionNode {
    @Node.Child
    private ExpressionNode left_;
    @Node.Child
    private ExpressionNode right_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private SetUnionNodeGen(ExpressionNode left, ExpressionNode right) {
        this.left_ = left;
        this.right_ = right;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        IStrategoAppl2 leftValue__;
        int state = this.state_;
        Object leftValue_ = this.left_.executeGeneric(frameValue);
        Object rightValue_ = this.right_.executeGeneric(frameValue);
        if ((state & 1) != 0 && leftValue_ instanceof EmptyMapOrSet) {
            leftValue__ = (EmptyMapOrSet)leftValue_;
            if (rightValue_ instanceof EmptyMapOrSet) {
                EmptyMapOrSet rightValue__ = (EmptyMapOrSet)rightValue_;
                return this.union((EmptyMapOrSet)leftValue__, rightValue__);
            }
        }
        if ((state & 2) != 0 && leftValue_ instanceof ISet) {
            leftValue__ = (ISet)leftValue_;
            if (rightValue_ instanceof ISet) {
                ISet rightValue__ = (ISet)rightValue_;
                return this.union((ISet)leftValue__, rightValue__);
            }
        }
        if ((state & 4) != 0 && leftValue_ instanceof IMap) {
            leftValue__ = (IMap)leftValue_;
            if (rightValue_ instanceof IMap) {
                IMap rightValue__ = (IMap)rightValue_;
                return this.union((IMap)leftValue__, rightValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftValue_, rightValue_);
    }

    private IStrategoAppl2 executeAndSpecialize(Object leftValue, Object rightValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            IStrategoAppl2 leftValue_;
            if (leftValue instanceof EmptyMapOrSet) {
                leftValue_ = (EmptyMapOrSet)leftValue;
                if (rightValue instanceof EmptyMapOrSet) {
                    EmptyMapOrSet rightValue_ = (EmptyMapOrSet)rightValue;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    EmptyMapOrSet emptyMapOrSet = this.union((EmptyMapOrSet)leftValue_, rightValue_);
                    return emptyMapOrSet;
                }
            }
            if (leftValue instanceof ISet) {
                leftValue_ = (ISet)leftValue;
                if (rightValue instanceof ISet) {
                    ISet rightValue_ = (ISet)rightValue;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    ISet iSet = this.union((ISet)leftValue_, rightValue_);
                    return iSet;
                }
            }
            if (leftValue instanceof IMap) {
                leftValue_ = (IMap)leftValue;
                if (rightValue instanceof IMap) {
                    IMap rightValue_ = (IMap)rightValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    IMap iMap = this.union((IMap)leftValue_, rightValue_);
                    return iMap;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static SetUnionNode create(ExpressionNode left, ExpressionNode right) {
        return new SetUnionNodeGen(left, right);
    }
}

