/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.scopegraph;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.scopegraph.ACGDirectEdge;
import mb.nabl2.scopegraph.terms.Label;
import mb.nabl2.terms.ITerm;

public final class CGDirectEdge
extends ACGDirectEdge
implements Serializable {
    private final ITerm sourceScope;
    private final Label label;
    private final ITerm targetScope;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CGDirectEdge(ITerm sourceScope, Label label, ITerm targetScope, IMessageInfo messageInfo) {
        this.sourceScope = Objects.requireNonNull(sourceScope, "sourceScope");
        this.label = Objects.requireNonNull(label, "label");
        this.targetScope = Objects.requireNonNull(targetScope, "targetScope");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CGDirectEdge(CGDirectEdge original, ITerm sourceScope, Label label, ITerm targetScope, IMessageInfo messageInfo) {
        this.sourceScope = sourceScope;
        this.label = label;
        this.targetScope = targetScope;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getSourceScope() {
        return this.sourceScope;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public ITerm getTargetScope() {
        return this.targetScope;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CGDirectEdge withSourceScope(ITerm value) {
        if (this.sourceScope == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "sourceScope");
        return new CGDirectEdge(this, newValue, this.label, this.targetScope, this.messageInfo);
    }

    public final CGDirectEdge withLabel(Label value) {
        if (this.label == value) {
            return this;
        }
        Label newValue = Objects.requireNonNull(value, "label");
        return new CGDirectEdge(this, this.sourceScope, newValue, this.targetScope, this.messageInfo);
    }

    public final CGDirectEdge withTargetScope(ITerm value) {
        if (this.targetScope == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "targetScope");
        return new CGDirectEdge(this, this.sourceScope, this.label, newValue, this.messageInfo);
    }

    public final CGDirectEdge withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CGDirectEdge(this, this.sourceScope, this.label, this.targetScope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CGDirectEdge && this.equalTo((CGDirectEdge)another);
    }

    private boolean equalTo(CGDirectEdge another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.sourceScope.equals(another.sourceScope) && this.label.equals(another.label) && this.targetScope.equals(another.targetScope) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.sourceScope.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.targetScope.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CGDirectEdge of(ITerm sourceScope, Label label, ITerm targetScope, IMessageInfo messageInfo) {
        return new CGDirectEdge(sourceScope, label, targetScope, messageInfo);
    }

    public static CGDirectEdge copyOf(ACGDirectEdge instance) {
        if (instance instanceof CGDirectEdge) {
            return (CGDirectEdge)instance;
        }
        return CGDirectEdge.of(instance.getSourceScope(), instance.getLabel(), instance.getTargetScope(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CGDirectEdge(this, this.sourceScope, this.label, this.targetScope, this.messageInfo);
    }
}

