/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.scopegraph;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.scopegraph.ACGImportEdge;
import mb.nabl2.scopegraph.terms.Label;
import mb.nabl2.terms.ITerm;

public final class CGImportEdge
extends ACGImportEdge
implements Serializable {
    private final ITerm scope;
    private final Label label;
    private final ITerm reference;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CGImportEdge(ITerm scope, Label label, ITerm reference, IMessageInfo messageInfo) {
        this.scope = Objects.requireNonNull(scope, "scope");
        this.label = Objects.requireNonNull(label, "label");
        this.reference = Objects.requireNonNull(reference, "reference");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CGImportEdge(CGImportEdge original, ITerm scope, Label label, ITerm reference, IMessageInfo messageInfo) {
        this.scope = scope;
        this.label = label;
        this.reference = reference;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getScope() {
        return this.scope;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public ITerm getReference() {
        return this.reference;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CGImportEdge withScope(ITerm value) {
        if (this.scope == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "scope");
        return new CGImportEdge(this, newValue, this.label, this.reference, this.messageInfo);
    }

    public final CGImportEdge withLabel(Label value) {
        if (this.label == value) {
            return this;
        }
        Label newValue = Objects.requireNonNull(value, "label");
        return new CGImportEdge(this, this.scope, newValue, this.reference, this.messageInfo);
    }

    public final CGImportEdge withReference(ITerm value) {
        if (this.reference == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "reference");
        return new CGImportEdge(this, this.scope, this.label, newValue, this.messageInfo);
    }

    public final CGImportEdge withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CGImportEdge(this, this.scope, this.label, this.reference, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CGImportEdge && this.equalTo((CGImportEdge)another);
    }

    private boolean equalTo(CGImportEdge another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.scope.equals(another.scope) && this.label.equals(another.label) && this.reference.equals(another.reference) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.reference.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CGImportEdge of(ITerm scope, Label label, ITerm reference, IMessageInfo messageInfo) {
        return new CGImportEdge(scope, label, reference, messageInfo);
    }

    public static CGImportEdge copyOf(ACGImportEdge instance) {
        if (instance instanceof CGImportEdge) {
            return (CGImportEdge)instance;
        }
        return CGImportEdge.of(instance.getScope(), instance.getLabel(), instance.getReference(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CGImportEdge(this, this.scope, this.label, this.reference, this.messageInfo);
    }
}

