/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.scopegraph;

import mb.nabl2.constraints.messages.MessageInfo;
import mb.nabl2.constraints.scopegraph.CGDecl;
import mb.nabl2.constraints.scopegraph.CGDirectEdge;
import mb.nabl2.constraints.scopegraph.CGExportEdge;
import mb.nabl2.constraints.scopegraph.CGImportEdge;
import mb.nabl2.constraints.scopegraph.CGRef;
import mb.nabl2.constraints.scopegraph.IScopeGraphConstraint;
import mb.nabl2.scopegraph.terms.Label;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.substitution.ISubstitution;
import org.metaborg.util.functions.Function1;

public final class ScopeGraphConstraints {
    private static final String CG_DECL = "CGDecl";
    private static final String CG_DIRECT_EDGE = "CGDirectEdge";
    private static final String CG_EXPORT_EDGE = "CGAssoc";
    private static final String CG_IMPORT_EDGE = "CGNamedEdge";
    private static final String CG_REF = "CGRef";

    public static TermMatch.IMatcher<IScopeGraphConstraint> matcher() {
        return TermMatch.M.cases(TermMatch.M.appl3(CG_DECL, TermMatch.M.term(), TermMatch.M.term(), MessageInfo.matcherOnlyOriginTerm(), (c, decl, scope, origin) -> CGDecl.of(scope, decl, origin)), TermMatch.M.appl3(CG_REF, TermMatch.M.term(), TermMatch.M.term(), MessageInfo.matcherOnlyOriginTerm(), (c, ref, scope, origin) -> CGRef.of(ref, scope, origin)), TermMatch.M.appl4(CG_DIRECT_EDGE, TermMatch.M.term(), Label.matcher(), TermMatch.M.term(), MessageInfo.matcherOnlyOriginTerm(), (c, scope1, label, scope2, origin) -> CGDirectEdge.of(scope1, label, scope2, origin)), TermMatch.M.appl4(CG_EXPORT_EDGE, TermMatch.M.term(), Label.matcher(), TermMatch.M.term(), MessageInfo.matcherOnlyOriginTerm(), (c, decl, label, scope, origin) -> CGExportEdge.of(decl, label, scope, origin)), TermMatch.M.appl4(CG_IMPORT_EDGE, TermMatch.M.term(), Label.matcher(), TermMatch.M.term(), MessageInfo.matcherOnlyOriginTerm(), (c, ref, label, scope, origin) -> CGImportEdge.of(scope, label, ref, origin)));
    }

    public static ITerm build(IScopeGraphConstraint constraint) {
        return constraint.match(IScopeGraphConstraint.Cases.of(decl -> TermBuild.B.newAppl(CG_DECL, decl.getDeclaration(), decl.getScope(), MessageInfo.buildOnlyOriginTerm(decl.getMessageInfo())), ref -> TermBuild.B.newAppl(CG_REF, ref.getReference(), ref.getScope(), MessageInfo.buildOnlyOriginTerm(ref.getMessageInfo())), edge -> TermBuild.B.newAppl(CG_DIRECT_EDGE, edge.getSourceScope(), edge.getLabel(), edge.getTargetScope(), MessageInfo.buildOnlyOriginTerm(edge.getMessageInfo())), exp -> TermBuild.B.newAppl(CG_EXPORT_EDGE, exp.getDeclaration(), exp.getLabel(), exp.getScope(), MessageInfo.buildOnlyOriginTerm(exp.getMessageInfo())), imp -> TermBuild.B.newAppl(CG_IMPORT_EDGE, imp.getReference(), imp.getLabel(), imp.getScope(), MessageInfo.buildOnlyOriginTerm(imp.getMessageInfo()))));
    }

    public static IScopeGraphConstraint substitute(IScopeGraphConstraint constraint, ISubstitution.Immutable subst) {
        return constraint.match(IScopeGraphConstraint.Cases.of(decl -> CGDecl.of(subst.apply(decl.getScope()), subst.apply(decl.getDeclaration()), decl.getMessageInfo().apply(subst::apply)), ref -> CGRef.of(subst.apply(ref.getReference()), subst.apply(ref.getScope()), ref.getMessageInfo().apply(subst::apply)), edge -> CGDirectEdge.of(subst.apply(edge.getSourceScope()), edge.getLabel(), subst.apply(edge.getTargetScope()), edge.getMessageInfo().apply(subst::apply)), exp -> CGExportEdge.of(subst.apply(exp.getDeclaration()), exp.getLabel(), subst.apply(exp.getScope()), exp.getMessageInfo().apply(subst::apply)), imp -> CGImportEdge.of(subst.apply(imp.getScope()), imp.getLabel(), subst.apply(imp.getReference()), imp.getMessageInfo().apply(subst::apply))));
    }

    public static IScopeGraphConstraint transform(IScopeGraphConstraint constraint, Function1<ITerm, ITerm> map) {
        return constraint.match(IScopeGraphConstraint.Cases.of(decl -> CGDecl.of((ITerm)map.apply(decl.getScope()), (ITerm)map.apply(decl.getDeclaration()), decl.getMessageInfo().apply(map::apply)), ref -> CGRef.of((ITerm)map.apply(ref.getReference()), (ITerm)map.apply(ref.getScope()), ref.getMessageInfo().apply(map::apply)), edge -> CGDirectEdge.of((ITerm)map.apply(edge.getSourceScope()), edge.getLabel(), (ITerm)map.apply(edge.getTargetScope()), edge.getMessageInfo().apply(map::apply)), exp -> CGExportEdge.of((ITerm)map.apply(exp.getDeclaration()), exp.getLabel(), (ITerm)map.apply(exp.getScope()), exp.getMessageInfo().apply(map::apply)), imp -> CGImportEdge.of((ITerm)map.apply(imp.getScope()), imp.getLabel(), (ITerm)map.apply(imp.getReference()), imp.getMessageInfo().apply(map::apply))));
    }
}

