/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.regexp;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mb.nabl2.regexp.Deriver;
import mb.nabl2.regexp.IAlphabet;
import mb.nabl2.regexp.IRegExp;
import mb.nabl2.regexp.IRegExpMatcher;
import mb.nabl2.regexp.impl.RegExpNormalizingBuilder;
import mb.nabl2.regexp.impl.RegExps;

public class RegExpMatcher<S>
implements IRegExpMatcher<S>,
Serializable {
    private static final long serialVersionUID = 42L;
    private final IRegExp<S> state;
    private final Map<IRegExp<S>, Map<S, IRegExp<S>>> stateTransitions;
    private final Map<IRegExp<S>, IRegExp<S>> defaultTransitions;
    private final Set<IRegExp<S>> nonFinal;
    private final Set<IRegExp<S>> isNullable;

    private RegExpMatcher(IRegExp<S> state, Map<IRegExp<S>, Map<S, IRegExp<S>>> stateTransitions, Map<IRegExp<S>, IRegExp<S>> defaultTransitions, Set<IRegExp<S>> nonFinal, Set<IRegExp<S>> isNullable) {
        this.state = state;
        this.stateTransitions = stateTransitions;
        this.defaultTransitions = defaultTransitions;
        this.nonFinal = nonFinal;
        this.isNullable = isNullable;
    }

    @Override
    public IRegExp<S> regexp() {
        return this.state;
    }

    @Override
    public RegExpMatcher<S> match(S symbol) {
        Map<S, IRegExp<S>> transitions = this.stateTransitions.get(this.state);
        IRegExp<S> newState = transitions.getOrDefault(symbol, this.defaultTransitions.get(this.state));
        return new RegExpMatcher<S>(newState, this.stateTransitions, this.defaultTransitions, this.nonFinal, this.isNullable);
    }

    @Override
    public IRegExpMatcher<S> match(Iterable<S> symbols) {
        IRegExpMatcher<S> matcher = this;
        for (S symbol : symbols) {
            matcher = matcher.match((Object)symbol);
        }
        return matcher;
    }

    @Override
    public boolean isAccepting() {
        return this.isNullable.contains(this.state);
    }

    @Override
    public boolean isFinal() {
        return !this.nonFinal.contains(this.state);
    }

    public String toString() {
        return this.state.toString();
    }

    public static <S> IRegExpMatcher<S> create(IRegExp<S> initial) {
        IAlphabet alphabet = RegExps.alphabet(initial);
        RegExpNormalizingBuilder builder = new RegExpNormalizingBuilder(alphabet);
        Object empty = builder.emptySet();
        ArrayList derivers = Lists.newArrayList();
        for (Object symbol : alphabet) {
            derivers.add(new Deriver(symbol, builder));
        }
        Deriver<Object> defaultDeriver = new Deriver<Object>(null, builder);
        HashMap stateTransitions = Maps.newHashMap();
        HashMap defaultTransitions = Maps.newHashMap();
        HashMap reverseTransitions = Maps.newHashMap();
        ArrayDeque worklist = Queues.newArrayDeque();
        worklist.push(initial);
        worklist.push(empty);
        while (!worklist.isEmpty()) {
            IRegExp state = (IRegExp)worklist.pop();
            HashMap transitions = Maps.newHashMapWithExpectedSize((int)derivers.size());
            if (stateTransitions.containsKey(state)) continue;
            for (Deriver deriver : derivers) {
                IRegExp nextState = (IRegExp)builder.apply((IRegExp)deriver.apply(state));
                Set reverseStates = (Set)reverseTransitions.get(nextState);
                if (reverseStates == null) {
                    reverseStates = Sets.newHashSet();
                    reverseTransitions.put(nextState, reverseStates);
                }
                reverseStates.add(state);
                transitions.put(deriver.getSymbol(), nextState);
                worklist.push(nextState);
            }
            IRegExp defaultState = (IRegExp)builder.apply((IRegExp)defaultDeriver.apply(state));
            Set reverseStates = (Set)reverseTransitions.get(defaultState);
            if (reverseStates == null) {
                reverseStates = Sets.newHashSet();
                reverseTransitions.put(defaultState, reverseStates);
            }
            reverseStates.add(state);
            defaultTransitions.put(state, defaultState);
            worklist.push(defaultState);
            stateTransitions.put(state, transitions);
        }
        for (IRegExp state : stateTransitions.keySet()) {
            if (!RegExps.isNullable(state)) continue;
            worklist.push(state);
        }
        HashSet visited = Sets.newHashSet();
        HashSet nonFinal = Sets.newHashSet();
        while (!worklist.isEmpty()) {
            IRegExp state = (IRegExp)worklist.pop();
            if (visited.contains(state)) continue;
            visited.add(state);
            if (!reverseTransitions.containsKey(state)) continue;
            for (IRegExp nextState : (Set)reverseTransitions.get(state)) {
                nonFinal.add(nextState);
                worklist.push(nextState);
            }
        }
        Set isNullable = (Set)stateTransitions.keySet().stream().filter(RegExps::isNullable).collect(ImmutableSet.toImmutableSet());
        return new RegExpMatcher<S>(initial, stateTransitions, defaultTransitions, nonFinal, isNullable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegExpMatcher that = (RegExpMatcher)o;
        return Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }
}

