/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.regexp.impl;

import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.regexp.IRegExp;
import mb.nabl2.regexp.impl.AAnd;

final class And<S>
extends AAnd<S>
implements Serializable {
    private final IRegExp<S> left;
    private final IRegExp<S> right;
    private static final long serialVersionUID = 42L;

    private And(IRegExp<S> left, IRegExp<S> right) {
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
    }

    private And(And<S> original, IRegExp<S> left, IRegExp<S> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public IRegExp<S> getLeft() {
        return this.left;
    }

    @Override
    public IRegExp<S> getRight() {
        return this.right;
    }

    public final And<S> withLeft(IRegExp<S> value) {
        if (this.left == value) {
            return this;
        }
        IRegExp<S> newValue = Objects.requireNonNull(value, "left");
        return new And<S>(this, newValue, this.right);
    }

    public final And<S> withRight(IRegExp<S> value) {
        if (this.right == value) {
            return this;
        }
        IRegExp<S> newValue = Objects.requireNonNull(value, "right");
        return new And<S>(this, this.left, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof And && this.equalTo((And)another);
    }

    private boolean equalTo(And<?> another) {
        return this.left.equals(another.left) && this.right.equals(another.right);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.right.hashCode();
        return h;
    }

    public static <S> And<S> of(IRegExp<S> left, IRegExp<S> right) {
        return new And<S>(left, right);
    }

    public static <S> And<S> copyOf(AAnd<S> instance) {
        if (instance instanceof And) {
            return (And)instance;
        }
        return And.of(instance.getLeft(), instance.getRight());
    }
}

