/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.regexp.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mb.nabl2.regexp.IAlphabet;

public final class FiniteAlphabet<S>
implements IAlphabet<S>,
Serializable {
    private static final long serialVersionUID = 42L;
    private final ImmutableList<S> symbols;

    @SafeVarargs
    public FiniteAlphabet(S ... symbols) {
        this((Iterable<S>)Arrays.asList(symbols));
    }

    public FiniteAlphabet(Iterable<S> alphabet) {
        this.symbols = ImmutableList.copyOf((Collection)ImmutableSet.copyOf(alphabet));
    }

    @Override
    public Iterator<S> iterator() {
        return this.symbols.iterator();
    }

    @Override
    public boolean contains(S s) {
        return this.symbols.contains(s);
    }

    @Override
    public int indexOf(S s) {
        if (!this.contains(s)) {
            throw new IllegalArgumentException("Symbol not in alphabet.");
        }
        return this.symbols.indexOf(s);
    }

    @Override
    public List<S> symbols() {
        return this.symbols;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.symbols.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FiniteAlphabet other = (FiniteAlphabet)obj;
        return this.symbols.equals(other.symbols);
    }

    public String toString() {
        return this.symbols.toString();
    }
}

