/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.regexp.impl;

import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.regexp.IRegExp;
import mb.nabl2.regexp.impl.AOr;

final class Or<S>
extends AOr<S>
implements Serializable {
    private final IRegExp<S> left;
    private final IRegExp<S> right;
    private static final long serialVersionUID = 42L;

    private Or(IRegExp<S> left, IRegExp<S> right) {
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
    }

    private Or(Or<S> original, IRegExp<S> left, IRegExp<S> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public IRegExp<S> getLeft() {
        return this.left;
    }

    @Override
    public IRegExp<S> getRight() {
        return this.right;
    }

    public final Or<S> withLeft(IRegExp<S> value) {
        if (this.left == value) {
            return this;
        }
        IRegExp<S> newValue = Objects.requireNonNull(value, "left");
        return new Or<S>(this, newValue, this.right);
    }

    public final Or<S> withRight(IRegExp<S> value) {
        if (this.right == value) {
            return this;
        }
        IRegExp<S> newValue = Objects.requireNonNull(value, "right");
        return new Or<S>(this, this.left, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Or && this.equalTo((Or)another);
    }

    private boolean equalTo(Or<?> another) {
        return this.left.equals(another.left) && this.right.equals(another.right);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.right.hashCode();
        return h;
    }

    public static <S> Or<S> of(IRegExp<S> left, IRegExp<S> right) {
        return new Or<S>(left, right);
    }

    public static <S> Or<S> copyOf(AOr<S> instance) {
        if (instance instanceof Or) {
            return (Or)instance;
        }
        return Or.of(instance.getLeft(), instance.getRight());
    }
}

