/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations;

import mb.nabl2.relations.RelationDescription;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ARelationDescription {
    public static final RelationDescription PARTIAL_ORDER = RelationDescription.of(Reflexivity.REFLEXIVE, Symmetry.ANTI_SYMMETRIC, Transitivity.TRANSITIVE);
    public static final RelationDescription STRICT_PARTIAL_ORDER = RelationDescription.of(Reflexivity.IRREFLEXIVE, Symmetry.ANTI_SYMMETRIC, Transitivity.TRANSITIVE);

    @Value.Parameter
    public abstract Reflexivity getReflexivity();

    @Value.Parameter
    public abstract Symmetry getSymmetry();

    @Value.Parameter
    public abstract Transitivity getTransitivity();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getReflexivity());
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append((Object)this.getTransitivity());
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append((Object)this.getSymmetry());
        return sb.toString();
    }

    public static enum Reflexivity {
        REFLEXIVE("refl"),
        IRREFLEXIVE("irrefl"),
        NON_REFLEXIVE("");

        private final String name;

        private Reflexivity(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Symmetry {
        SYMMETRIC("sym"),
        ANTI_SYMMETRIC("anti-sym"),
        NON_SYMMETRIC("");

        private final String name;

        private Symmetry(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Transitivity {
        TRANSITIVE("trans"),
        ANTI_TRANSITIVE("anti-trans"),
        NON_TRANSITIVE("");

        private final String name;

        private Transitivity(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

