/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations;

import io.usethesource.capsule.Set;
import java.util.Optional;
import java.util.stream.Stream;
import mb.nabl2.relations.RelationDescription;
import mb.nabl2.relations.RelationException;
import mb.nabl2.util.Tuple2;
import mb.nabl2.util.collections.IRelation2;

public interface IRelation<T> {
    public RelationDescription getDescription();

    public Set.Immutable<T> smaller(T var1);

    public Set.Immutable<T> larger(T var1);

    public boolean contains(T var1, T var2);

    public IRelation2<T, T> entries();

    public Optional<T> leastUpperBound(T var1, T var2);

    public Optional<T> greatestLowerBound(T var1, T var2);

    public Stream<Tuple2<T, T>> stream();

    public static interface Immutable<T>
    extends IRelation<T> {
        public Transient<T> melt();
    }

    public static interface Transient<T>
    extends IRelation<T> {
        public boolean add(T var1, T var2) throws RelationException;

        default public boolean addAll(IRelation<T> other) throws RelationException {
            boolean change = false;
            for (Tuple2 pair : other.stream()::iterator) {
                change |= this.add(pair._1(), pair._2());
            }
            return change;
        }

        public Immutable<T> freeze();
    }
}

