/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations;

import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.relations.ARelationDescription;

public final class RelationDescription
extends ARelationDescription
implements Serializable {
    private final ARelationDescription.Reflexivity reflexivity;
    private final ARelationDescription.Symmetry symmetry;
    private final ARelationDescription.Transitivity transitivity;
    private static final long serialVersionUID = 42L;

    private RelationDescription(ARelationDescription.Reflexivity reflexivity, ARelationDescription.Symmetry symmetry, ARelationDescription.Transitivity transitivity) {
        this.reflexivity = Objects.requireNonNull(reflexivity, "reflexivity");
        this.symmetry = Objects.requireNonNull(symmetry, "symmetry");
        this.transitivity = Objects.requireNonNull(transitivity, "transitivity");
    }

    private RelationDescription(RelationDescription original, ARelationDescription.Reflexivity reflexivity, ARelationDescription.Symmetry symmetry, ARelationDescription.Transitivity transitivity) {
        this.reflexivity = reflexivity;
        this.symmetry = symmetry;
        this.transitivity = transitivity;
    }

    @Override
    public ARelationDescription.Reflexivity getReflexivity() {
        return this.reflexivity;
    }

    @Override
    public ARelationDescription.Symmetry getSymmetry() {
        return this.symmetry;
    }

    @Override
    public ARelationDescription.Transitivity getTransitivity() {
        return this.transitivity;
    }

    public final RelationDescription withReflexivity(ARelationDescription.Reflexivity value) {
        if (this.reflexivity == value) {
            return this;
        }
        ARelationDescription.Reflexivity newValue = Objects.requireNonNull(value, "reflexivity");
        if (this.reflexivity.equals((Object)newValue)) {
            return this;
        }
        return new RelationDescription(this, newValue, this.symmetry, this.transitivity);
    }

    public final RelationDescription withSymmetry(ARelationDescription.Symmetry value) {
        if (this.symmetry == value) {
            return this;
        }
        ARelationDescription.Symmetry newValue = Objects.requireNonNull(value, "symmetry");
        if (this.symmetry.equals((Object)newValue)) {
            return this;
        }
        return new RelationDescription(this, this.reflexivity, newValue, this.transitivity);
    }

    public final RelationDescription withTransitivity(ARelationDescription.Transitivity value) {
        if (this.transitivity == value) {
            return this;
        }
        ARelationDescription.Transitivity newValue = Objects.requireNonNull(value, "transitivity");
        if (this.transitivity.equals((Object)newValue)) {
            return this;
        }
        return new RelationDescription(this, this.reflexivity, this.symmetry, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RelationDescription && this.equalTo((RelationDescription)another);
    }

    private boolean equalTo(RelationDescription another) {
        return this.reflexivity.equals((Object)another.reflexivity) && this.symmetry.equals((Object)another.symmetry) && this.transitivity.equals((Object)another.transitivity);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.reflexivity.hashCode();
        h += (h << 5) + this.symmetry.hashCode();
        h += (h << 5) + this.transitivity.hashCode();
        return h;
    }

    public static RelationDescription of(ARelationDescription.Reflexivity reflexivity, ARelationDescription.Symmetry symmetry, ARelationDescription.Transitivity transitivity) {
        return new RelationDescription(reflexivity, symmetry, transitivity);
    }

    public static RelationDescription copyOf(ARelationDescription instance) {
        if (instance instanceof RelationDescription) {
            return (RelationDescription)instance;
        }
        return RelationDescription.of(instance.getReflexivity(), instance.getSymmetry(), instance.getTransitivity());
    }
}

