/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.terms;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMultiset;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import mb.nabl2.relations.terms.FunctionName;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;

final class ExtFunction
extends FunctionName.AExtFunction
implements Serializable {
    private final ImmutableClassToInstanceMap<Object> attachments;
    private final String name;
    private volatile transient long lazyInitBitmap;
    private static final long ARITY_LAZY_INIT_BIT = 1L;
    private transient int arity;
    private static final long GROUND_LAZY_INIT_BIT = 2L;
    private transient boolean ground;
    private static final long VARS_LAZY_INIT_BIT = 4L;
    private transient ImmutableMultiset<ITermVar> vars;
    private static final long OP_LAZY_INIT_BIT = 8L;
    private transient String op;
    private static final long ARGS_LAZY_INIT_BIT = 16L;
    private transient List<ITerm> args;
    private static final long serialVersionUID = 42L;

    private ExtFunction(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private ExtFunction(ImmutableClassToInstanceMap<Object> attachments, String name) {
        this.attachments = attachments;
        this.name = name;
    }

    @Override
    public ImmutableClassToInstanceMap<Object> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final ExtFunction withAttachments(ImmutableClassToInstanceMap<Object> value) {
        if (this.attachments == value) {
            return this;
        }
        ImmutableClassToInstanceMap<Object> newValue = Objects.requireNonNull(value, "attachments");
        return new ExtFunction(newValue, this.name);
    }

    public final ExtFunction withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ExtFunction(this.attachments, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getArity() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ExtFunction extFunction = this;
            synchronized (extFunction) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.arity = super.getArity();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.arity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGround() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ExtFunction extFunction = this;
            synchronized (extFunction) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.ground = super.isGround();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.ground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMultiset<ITermVar> getVars() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ExtFunction extFunction = this;
            synchronized (extFunction) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.vars = Objects.requireNonNull(super.getVars(), "vars");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.vars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOp() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            ExtFunction extFunction = this;
            synchronized (extFunction) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.op = Objects.requireNonNull(super.getOp(), "op");
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITerm> getArgs() {
        if ((this.lazyInitBitmap & 0x10L) == 0L) {
            ExtFunction extFunction = this;
            synchronized (extFunction) {
                if ((this.lazyInitBitmap & 0x10L) == 0L) {
                    this.args = Objects.requireNonNull(super.getArgs(), "args");
                    this.lazyInitBitmap |= 0x10L;
                }
            }
        }
        return this.args;
    }

    public static ExtFunction of(String name) {
        return new ExtFunction(name);
    }

    public static ExtFunction copyOf(FunctionName.AExtFunction instance) {
        if (instance instanceof ExtFunction) {
            return (ExtFunction)instance;
        }
        return ExtFunction.of(instance.getName()).withAttachments((ImmutableClassToInstanceMap)instance.getAttachments());
    }
}

