/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.terms;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import mb.nabl2.relations.ARelationDescription;
import mb.nabl2.relations.RelationDescription;
import mb.nabl2.relations.terms.NamedRelation;
import mb.nabl2.relations.terms.RelationOptions;
import mb.nabl2.relations.terms.VariantMatchers;
import mb.nabl2.relations.variants.IVariantMatcher;
import mb.nabl2.relations.variants.VariantRelationDescription;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.util.Tuple3;

public class RelationTerms {
    public static TermMatch.IMatcher<Map<String, VariantRelationDescription<ITerm>>> relations() {
        return TermMatch.M.listElems(RelationTerms.relationDef(), (l, defs) -> {
            ImmutableMap.Builder relations = ImmutableMap.builder();
            for (Tuple3 def : defs) {
                relations.put((Object)((String)def._1()), VariantRelationDescription.of((RelationDescription)def._2(), (List)def._3()));
            }
            return relations.build();
        });
    }

    public static TermMatch.IMatcher<Tuple3<String, RelationDescription, List<IVariantMatcher<ITerm>>>> relationDef() {
        return TermMatch.M.tuple3(NamedRelation.matcher(), RelationTerms.relationDescription(), TermMatch.M.listElems(VariantMatchers.matcher()), (t, name, relationDescription, matchers) -> Tuple3.of(name.getName(), relationDescription, matchers));
    }

    private static TermMatch.IMatcher<RelationDescription> relationDescription() {
        return (term, unifier) -> TermMatch.M.listElems(TermMatch.M.term(), (l, properties) -> {
            ARelationDescription.Reflexivity refl = ARelationDescription.Reflexivity.NON_REFLEXIVE;
            ARelationDescription.Symmetry sym = ARelationDescription.Symmetry.NON_SYMMETRIC;
            ARelationDescription.Transitivity trans = ARelationDescription.Transitivity.NON_TRANSITIVE;
            for (ITerm propTerm : properties) {
                refl = RelationOptions.reflexivity().match(propTerm, unifier).orElse(refl);
                sym = RelationOptions.symmetry().match(propTerm, unifier).orElse(sym);
                trans = RelationOptions.transitivity().match(propTerm, unifier).orElse(trans);
            }
            return RelationDescription.of(refl, sym, trans);
        }).match(term, unifier);
    }
}

