/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.variants;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import mb.nabl2.relations.RelationDescription;
import mb.nabl2.relations.variants.AVariantRelationDescription;
import mb.nabl2.relations.variants.IVariantMatcher;

public final class VariantRelationDescription<T>
extends AVariantRelationDescription<T>
implements Serializable {
    private final RelationDescription relationDescription;
    private final ImmutableList<IVariantMatcher<T>> variantMatchers;
    private static final long serialVersionUID = 42L;

    private VariantRelationDescription(RelationDescription relationDescription, Iterable<? extends IVariantMatcher<T>> variantMatchers) {
        this.relationDescription = Objects.requireNonNull(relationDescription, "relationDescription");
        this.variantMatchers = ImmutableList.copyOf(variantMatchers);
    }

    private VariantRelationDescription(VariantRelationDescription<T> original, RelationDescription relationDescription, ImmutableList<IVariantMatcher<T>> variantMatchers) {
        this.relationDescription = relationDescription;
        this.variantMatchers = variantMatchers;
    }

    @Override
    public RelationDescription relationDescription() {
        return this.relationDescription;
    }

    @Override
    public ImmutableList<IVariantMatcher<T>> variantMatchers() {
        return this.variantMatchers;
    }

    public final VariantRelationDescription<T> withRelationDescription(RelationDescription value) {
        if (this.relationDescription == value) {
            return this;
        }
        RelationDescription newValue = Objects.requireNonNull(value, "relationDescription");
        return new VariantRelationDescription<T>(this, newValue, this.variantMatchers);
    }

    @SafeVarargs
    public final VariantRelationDescription<T> withVariantMatchers(IVariantMatcher<T> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new VariantRelationDescription<T>(this, this.relationDescription, newValue);
    }

    public final VariantRelationDescription<T> withVariantMatchers(Iterable<? extends IVariantMatcher<T>> elements) {
        if (this.variantMatchers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new VariantRelationDescription<T>(this, this.relationDescription, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof VariantRelationDescription && this.equalTo((VariantRelationDescription)another);
    }

    private boolean equalTo(VariantRelationDescription<?> another) {
        return this.relationDescription.equals(another.relationDescription) && this.variantMatchers.equals(another.variantMatchers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relationDescription.hashCode();
        h += (h << 5) + this.variantMatchers.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"VariantRelationDescription").omitNullValues().add("relationDescription", (Object)this.relationDescription).add("variantMatchers", this.variantMatchers).toString();
    }

    public static <T> VariantRelationDescription<T> of(RelationDescription relationDescription, List<IVariantMatcher<T>> variantMatchers) {
        return VariantRelationDescription.of(relationDescription, variantMatchers);
    }

    public static <T> VariantRelationDescription<T> of(RelationDescription relationDescription, Iterable<? extends IVariantMatcher<T>> variantMatchers) {
        return new VariantRelationDescription<T>(relationDescription, variantMatchers);
    }

    public static <T> VariantRelationDescription<T> copyOf(AVariantRelationDescription<T> instance) {
        if (instance instanceof VariantRelationDescription) {
            return (VariantRelationDescription)instance;
        }
        return VariantRelationDescription.of(instance.relationDescription(), instance.variantMatchers());
    }
}

