/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.scopegraph;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.scopegraph.ILabel;
import mb.nabl2.scopegraph.IOccurrence;
import mb.nabl2.scopegraph.IScope;
import mb.nabl2.scopegraph.esop.IEsopScopeGraph;
import mb.nabl2.scopegraph.esop.reference.EsopScopeGraph;
import org.metaborg.util.iterators.Iterables2;

public final class ScopeGraphCommon<S extends IScope, L extends ILabel, O extends IOccurrence, V> {
    private final IEsopScopeGraph<S, L, O, V> scopeGraph;

    public ScopeGraphCommon(IEsopScopeGraph<S, L, O, V> scopeGraph) {
        this.scopeGraph = scopeGraph;
    }

    public Set<O> reachingReferences(S scope) {
        return this.reachingScopes(scope).stream().flatMap(s -> this.scopeGraph.getRefs().inverse().get(s).stream()).collect(Collectors.toSet());
    }

    public Set<S> reachingScopes(S scope) {
        HashSet reaches = Sets.newHashSet((Object[])new IScope[]{scope});
        ArrayDeque worklist = Queues.newArrayDeque(Iterables2.singleton(scope));
        while (!worklist.isEmpty()) {
            IScope current = (IScope)worklist.pop();
            this.scopeGraph.getDirectEdges().inverse().get(current).stream().map(Map.Entry::getValue).filter(next -> !reaches.contains(next)).forEach(next -> {
                reaches.add(next);
                worklist.add(next);
            });
        }
        return reaches;
    }

    public Set<O> reachableDecls(S scope) {
        return this.reachableScopes(scope).stream().flatMap(s -> this.scopeGraph.getDecls().inverse().get(s).stream()).collect(Collectors.toSet());
    }

    public Set<S> reachableScopes(S scope) {
        HashSet reachable = Sets.newHashSet((Object[])new IScope[]{scope});
        ArrayDeque worklist = Queues.newArrayDeque(Iterables2.singleton(scope));
        while (!worklist.isEmpty()) {
            IScope current = (IScope)worklist.pop();
            this.scopeGraph.getDirectEdges().get(current).stream().map(Map.Entry::getValue).filter(next -> !reachable.contains(next)).forEach(next -> {
                reachable.add(next);
                worklist.add(next);
            });
        }
        return reachable;
    }

    public IEsopScopeGraph<S, L, O, V> summarize(S scope) {
        EsopScopeGraph.Transient summaryGraph = EsopScopeGraph.Transient.of();
        this.summarize((O)scope, (IEsopScopeGraph.Transient<S, L, O, V>)summaryGraph, (Set<Object>)Sets.newHashSet());
        return summaryGraph.freeze();
    }

    private void summarize(S scope, IEsopScopeGraph.Transient<S, L, O, V> summaryGraph, Set<Object> visited) {
        if (!visited.contains(scope)) {
            visited.add(scope);
            for (IOccurrence iOccurrence : this.scopeGraph.getDecls().inverse().get(scope)) {
                summaryGraph.addDecl((IScope)scope, iOccurrence);
                this.summarize((O)iOccurrence, (IEsopScopeGraph.Transient<S, L, O, V>)summaryGraph, visited);
            }
            for (Map.Entry entry : this.scopeGraph.getDirectEdges().get(scope)) {
                summaryGraph.addDirectEdge((IScope)scope, (ILabel)entry.getKey(), (IScope)entry.getValue());
                this.summarize((O)((IScope)entry.getValue()), (IEsopScopeGraph.Transient<S, L, O, V>)summaryGraph, visited);
            }
        }
    }

    public IEsopScopeGraph<S, L, O, V> summarize(O decl) {
        EsopScopeGraph.Transient summaryGraph = EsopScopeGraph.Transient.of();
        this.summarize(decl, (IEsopScopeGraph.Transient<S, L, O, V>)summaryGraph, (Set<Object>)Sets.newHashSet());
        return summaryGraph.freeze();
    }

    private void summarize(O decl, IEsopScopeGraph.Transient<S, L, O, V> summaryGraph, Set<Object> visited) {
        if (!visited.contains(decl)) {
            visited.add(decl);
            for (Map.Entry next : this.scopeGraph.getExportEdges().get(decl)) {
                summaryGraph.addExportEdge(decl, (ILabel)next.getKey(), (IScope)next.getValue());
                this.summarize((O)((IScope)next.getValue()), (IEsopScopeGraph.Transient<S, L, O, V>)summaryGraph, visited);
            }
        }
    }
}

