/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.scopegraph.esop.lazy;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import mb.nabl2.scopegraph.ILabel;
import mb.nabl2.scopegraph.IOccurrence;
import mb.nabl2.scopegraph.IScope;
import mb.nabl2.scopegraph.esop.CriticalEdgeException;
import mb.nabl2.scopegraph.esop.lazy.IEsopEnv;
import mb.nabl2.scopegraph.path.IDeclPath;
import mb.nabl2.scopegraph.path.IPath;
import mb.nabl2.scopegraph.path.IResolutionPath;
import mb.nabl2.scopegraph.terms.path.Paths;
import mb.nabl2.util.CapsuleUtil;
import org.metaborg.util.functions.CheckedFunction0;
import org.metaborg.util.functions.Function0;

public class EsopEnvs {
    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> guarded(final CheckedFunction0<IEsopEnv<S, L, O, P>, CriticalEdgeException> provider) {
        return new IEsopEnv<S, L, O, P>(){
            private static final long serialVersionUID = 42L;
            private IEsopEnv<S, L, O, P> env = null;

            private IEsopEnv<S, L, O, P> env() throws CriticalEdgeException {
                if (this.env == null) {
                    this.env = (IEsopEnv)provider.apply();
                }
                return this.env;
            }

            @Override
            public Collection<P> get() throws CriticalEdgeException {
                return this.env().get();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("#");
                try {
                    sb.append(this.env().toString());
                }
                catch (CriticalEdgeException e) {
                    sb.append("?");
                }
                return sb.toString();
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> lazy(final Function0<IEsopEnv<S, L, O, P>> provider) {
        return new IEsopEnv<S, L, O, P>(){
            private static final long serialVersionUID = 42L;
            private IEsopEnv<S, L, O, P> env = null;

            private IEsopEnv<S, L, O, P> env() {
                if (this.env == null) {
                    this.env = (IEsopEnv)provider.apply();
                }
                return this.env;
            }

            @Override
            public Collection<P> get() throws CriticalEdgeException {
                return this.env().get();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("~");
                sb.append(this.env());
                return sb.toString();
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> init(Iterable<P> paths) {
        return new IEsopEnv<S, L, O, P>(paths){
            private static final long serialVersionUID = 42L;
            private Collection<P> _paths;
            {
                this._paths = CapsuleUtil.toSet(iterable);
            }

            @Override
            public Collection<P> get() {
                return this._paths;
            }

            public String toString() {
                return this._paths.toString();
            }
        };
    }

    @SafeVarargs
    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> shadow(final IEsopEnv.Filter<S, L, O, P> filter, IEsopEnv<S, L, O, P> ... envs) {
        return new IEsopEnv<S, L, O, P>(envs){
            private static final long serialVersionUID = 42L;
            private final Deque<IEsopEnv<S, L, O, P>> _envs;
            private final Collection<Object> _shadowed;
            private final Set.Transient<P> _paths;
            private Collection<P> paths;
            {
                this._envs = Lists.newLinkedList(Arrays.asList(iEsopEnvArray));
                this._shadowed = Sets.newHashSet();
                this._paths = Set.Transient.of();
                this.paths = null;
            }

            private Collection<P> env() throws CriticalEdgeException {
                if (this.paths != null) {
                    return this.paths;
                }
                Iterator it = this._envs.iterator();
                while (it.hasNext()) {
                    IEsopEnv env = it.next();
                    Collection pts = env.get();
                    for (IPath p : pts) {
                        if (this._shadowed.contains(filter.matchToken(p))) continue;
                        this._paths.__insert((Object)p);
                    }
                    for (IPath p : pts) {
                        this._shadowed.add(filter.matchToken(p));
                    }
                    it.remove();
                    if (filter.shortCircuit() && !this._paths.isEmpty()) break;
                }
                this.paths = this._paths.freeze();
                return this.paths;
            }

            @Override
            public Collection<P> get() throws CriticalEdgeException {
                return this.env();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("(");
                sb.append(this.paths != null ? this.paths : this._paths);
                this._envs.stream().forEach(e -> {
                    sb.append(" <| ");
                    sb.append(e);
                });
                sb.append(")");
                return sb.toString();
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> union(Iterable<IEsopEnv<S, L, O, P>> envs) {
        return new IEsopEnv<S, L, O, P>(envs){
            private static final long serialVersionUID = 42L;
            private final LinkedList<IEsopEnv<S, L, O, P>> _envs;
            private final Set.Transient<P> _paths;
            private Collection<P> paths;
            {
                this._envs = Lists.newLinkedList((Iterable)iterable);
                this._paths = Set.Transient.of();
                this.paths = null;
            }

            private Collection<P> env() throws CriticalEdgeException {
                if (this.paths != null) {
                    return this.paths;
                }
                ArrayList es = Lists.newArrayList();
                Iterator it = this._envs.iterator();
                while (it.hasNext()) {
                    IEsopEnv env = (IEsopEnv)it.next();
                    try {
                        Collection pts = env.get();
                        for (IPath p : pts) {
                            this._paths.__insert((Object)p);
                        }
                        it.remove();
                    }
                    catch (CriticalEdgeException e) {
                        es.add(e);
                    }
                }
                if (!es.isEmpty()) {
                    throw CriticalEdgeException.of(es);
                }
                this.paths = this._paths.freeze();
                return this.paths;
            }

            @Override
            public Collection<P> get() throws CriticalEdgeException {
                return this.env();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("(");
                sb.append(this.paths != null ? this.paths : this._paths);
                this._envs.stream().forEach(e -> {
                    sb.append(" U ");
                    sb.append(e);
                });
                sb.append(")");
                return sb.toString();
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> empty() {
        return new IEsopEnv<S, L, O, P>(){
            private static final long serialVersionUID = 42L;

            @Override
            public Collection<P> get() {
                return Collections.emptyList();
            }

            public String toString() {
                return "{}";
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> IEsopEnv.Filter<S, L, O, IResolutionPath<S, L, O>> resolutionFilter(final O ref) {
        return new IEsopEnv.Filter<S, L, O, IResolutionPath<S, L, O>>(){
            private static final long serialVersionUID = 42L;

            @Override
            public Optional<IResolutionPath<S, L, O>> test(IDeclPath<S, L, O> path) {
                return Paths.resolve(ref, path);
            }

            @Override
            public Object matchToken(IResolutionPath<S, L, O> p) {
                return p.getDeclaration().getSpacedName();
            }

            @Override
            public boolean shortCircuit() {
                return true;
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> IEsopEnv.Filter<S, L, O, IDeclPath<S, L, O>> envFilter() {
        return new IEsopEnv.Filter<S, L, O, IDeclPath<S, L, O>>(){
            private static final long serialVersionUID = 42L;

            @Override
            public Optional<IDeclPath<S, L, O>> test(IDeclPath<S, L, O> path) {
                return Optional.of(path);
            }

            @Override
            public Object matchToken(IDeclPath<S, L, O> p) {
                return p.getDeclaration().getSpacedName();
            }

            @Override
            public boolean shortCircuit() {
                return false;
            }
        };
    }
}

