/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.scopegraph.esop.lazy;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.regexp.IRegExpMatcher;
import mb.nabl2.regexp.RegExpMatcher;
import mb.nabl2.relations.IRelation;
import mb.nabl2.relations.RelationDescription;
import mb.nabl2.relations.impl.Relation;
import mb.nabl2.scopegraph.ILabel;
import mb.nabl2.scopegraph.IOccurrence;
import mb.nabl2.scopegraph.IResolutionParameters;
import mb.nabl2.scopegraph.IScope;
import mb.nabl2.scopegraph.esop.CriticalEdgeException;
import mb.nabl2.scopegraph.esop.IEsopNameResolution;
import mb.nabl2.scopegraph.esop.IEsopScopeGraph;
import mb.nabl2.scopegraph.esop.lazy.EnvL;
import mb.nabl2.scopegraph.esop.lazy.EsopEnvs;
import mb.nabl2.scopegraph.esop.lazy.IEsopEnv;
import mb.nabl2.scopegraph.path.IDeclPath;
import mb.nabl2.scopegraph.path.IPath;
import mb.nabl2.scopegraph.path.IResolutionPath;
import mb.nabl2.scopegraph.path.IScopePath;
import mb.nabl2.scopegraph.terms.path.Paths;
import org.metaborg.util.functions.CheckedFunction0;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Predicate2;

public class EsopNameResolution<S extends IScope, L extends ILabel, O extends IOccurrence>
implements IEsopNameResolution<S, L, O> {
    private final IEsopScopeGraph<S, L, O, ?> scopeGraph;
    private final Set<L> labels;
    private final L labelD;
    private final L labelR;
    private final IRegExpMatcher<L> wf;
    private final IRelation.Immutable<L> order;
    private final IRelation<L> noOrder;
    private final Predicate2<S, L> isEdgeClosed;
    private final Map.Transient<O, Collection<IResolutionPath<S, L, O>>> resolution;
    private final Map.Transient<S, Collection<O>> visibility;
    private final Map.Transient<S, Collection<O>> reachability;
    private final Map<O, IEsopEnv<S, L, O, IResolutionPath<S, L, O>>> pendingResolution;
    private final Map<S, IEsopEnv<S, L, O, IDeclPath<S, L, O>>> pendingVisibility;
    private final Map<S, IEsopEnv<S, L, O, IDeclPath<S, L, O>>> pendingReachability;
    private final Map<IRelation<L>, EnvL<S, L, O>> stagedEnv_L;

    public EsopNameResolution(IResolutionParameters<L> params, IEsopScopeGraph<S, L, O, ?> scopeGraph, Predicate2<S, L> isEdgeClosed, Map.Transient<O, Collection<IResolutionPath<S, L, O>>> resolution, Map.Transient<S, Collection<O>> visibility, Map.Transient<S, Collection<O>> reachability) {
        this.scopeGraph = scopeGraph;
        this.labels = ImmutableSet.copyOf(params.getLabels());
        this.labelD = params.getLabelD();
        this.labelR = params.getLabelR();
        this.wf = RegExpMatcher.create(params.getPathWf());
        this.order = params.getSpecificityOrder();
        assert (this.order.getDescription().equals(RelationDescription.STRICT_PARTIAL_ORDER)) : "Label specificity order must be a strict partial order";
        this.noOrder = Relation.Immutable.of(RelationDescription.STRICT_PARTIAL_ORDER);
        this.isEdgeClosed = isEdgeClosed;
        this.resolution = resolution;
        this.visibility = visibility;
        this.reachability = reachability;
        this.pendingResolution = Maps.newHashMap();
        this.pendingVisibility = Maps.newHashMap();
        this.pendingReachability = Maps.newHashMap();
        this.stagedEnv_L = Maps.newHashMap();
    }

    @Override
    public boolean addCached(IEsopNameResolution.ResolutionCache<S, L, O> cache) {
        boolean change = false;
        change |= this.resolution.__putAll(cache.resolutionEntries());
        change |= this.visibility.__putAll(cache.visibilityEntries());
        return change |= this.reachability.__putAll(cache.reachabilityEntries());
    }

    @Override
    public ResolutionCache<S, L, O> toCache() {
        return new ResolutionCache(this.resolution.freeze(), this.visibility.freeze(), this.reachability.freeze());
    }

    @Override
    public Set<O> getResolvedRefs() {
        return Collections.unmodifiableSet(this.resolution.keySet());
    }

    @Override
    public Collection<IResolutionPath<S, L, O>> resolve(O ref) throws CriticalEdgeException {
        if (this.resolution.containsKey(ref)) {
            return (Collection)this.resolution.get(ref);
        }
        IEsopEnv env = this.pendingResolution.computeIfAbsent(ref, r -> this.resolveEnv(Set.Immutable.of(), ref));
        Collection<IResolutionPath<S, L, O>> result = env.get();
        this.resolution.put(ref, result);
        this.pendingResolution.remove(ref);
        return result;
    }

    @Override
    public Set<Map.Entry<O, Collection<IResolutionPath<S, L, O>>>> resolutionEntries() {
        return Collections.unmodifiableSet(this.resolution.entrySet());
    }

    @Override
    public Collection<O> decls(S scope) throws CriticalEdgeException {
        if (!this.isEdgeClosed.test(scope, this.labelD)) {
            throw new CriticalEdgeException((IScope)scope, (ILabel)this.labelD);
        }
        return this.scopeGraph.getDecls().inverse().get(scope);
    }

    @Override
    public Collection<O> refs(S scope) throws CriticalEdgeException {
        if (!this.isEdgeClosed.test(scope, this.labelR)) {
            throw new CriticalEdgeException((IScope)scope, (ILabel)this.labelR);
        }
        return this.scopeGraph.getRefs().inverse().get(scope);
    }

    @Override
    public Collection<O> visible(S scope) throws CriticalEdgeException {
        if (this.visibility.containsKey(scope)) {
            return (Collection)this.visibility.get(scope);
        }
        IEsopEnv env = this.pendingVisibility.computeIfAbsent(scope, s -> this.visibleEnv(scope));
        Collection result = env.get();
        ImmutableSet.Builder declsBuilder = ImmutableSet.builder();
        result.stream().map(IDeclPath::getDeclaration).forEach(arg_0 -> ((ImmutableSet.Builder)declsBuilder).add(arg_0));
        ImmutableSet decls = declsBuilder.build();
        this.visibility.put(scope, (Object)decls);
        this.pendingVisibility.remove(scope);
        return decls;
    }

    @Override
    public Collection<O> reachable(S scope) throws CriticalEdgeException {
        if (this.reachability.containsKey(scope)) {
            return (Collection)this.reachability.get(scope);
        }
        IEsopEnv env = this.pendingReachability.computeIfAbsent(scope, s -> this.reachableEnv(scope));
        Collection result = env.get();
        ImmutableSet.Builder declsBuilder = ImmutableSet.builder();
        result.stream().map(IDeclPath::getDeclaration).forEach(arg_0 -> ((ImmutableSet.Builder)declsBuilder).add(arg_0));
        ImmutableSet decls = declsBuilder.build();
        this.reachability.put(scope, (Object)decls);
        this.pendingReachability.remove(scope);
        return decls;
    }

    private IEsopEnv<S, L, O, IDeclPath<S, L, O>> visibleEnv(S scope) {
        return this.env(Set.Immutable.of(), this.order, this.wf, Paths.empty(scope), EsopEnvs.envFilter());
    }

    private IEsopEnv<S, L, O, IDeclPath<S, L, O>> reachableEnv(S scope) {
        return this.env(Set.Immutable.of(), this.noOrder, this.wf, Paths.empty(scope), EsopEnvs.envFilter());
    }

    private IEsopEnv<S, L, O, IResolutionPath<S, L, O>> resolveEnv(Set.Immutable<O> seenI, O ref) {
        return this.scopeGraph.getRefs().get(ref).map(scope -> this.env(seenI.__insert((Object)ref), this.order, this.wf, Paths.empty(scope), EsopEnvs.resolutionFilter(ref))).orElseGet(() -> EsopEnvs.empty());
    }

    private <P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> env(Set.Immutable<O> seenImports, IRelation<L> lt2, IRegExpMatcher<L> re, IScopePath<S, L, O> path, IEsopEnv.Filter<S, L, O, P> filter) {
        if (re.isEmpty()) {
            return EsopEnvs.empty();
        }
        return this.env_L(this.labels, seenImports, lt2, re, path, filter);
    }

    private <P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> env_l(Set.Immutable<O> seenImports, IRelation<L> lt2, IRegExpMatcher<L> re, L l, IScopePath<S, L, O> path, IEsopEnv.Filter<S, L, O, P> filter) {
        return EsopEnvs.guarded((CheckedFunction0<IEsopEnv, E> & Serializable)() -> {
            Object s = path.getTarget();
            if (this.scopeGraph.isOpen(s, (ILabel)l) || !this.isEdgeClosed.test(s, l)) {
                throw new CriticalEdgeException((IScope)s, (ILabel)l);
            }
            IEsopEnv env = l.equals(this.labelD) ? this.env_D(re, path, filter) : this.env_nonD(seenImports, lt2, re, l, path, filter);
            return env;
        });
    }

    private <P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> env_D(IRegExpMatcher<L> re, IScopePath<S, L, O> path, IEsopEnv.Filter<S, L, O, P> filter) {
        if (!re.isAccepting()) {
            return EsopEnvs.empty();
        }
        ArrayList paths = Lists.newArrayList();
        for (IOccurrence decl : this.scopeGraph.getDecls().inverse().get(path.getTarget())) {
            filter.test(Paths.decl(path, decl)).ifPresent(paths::add);
        }
        return EsopEnvs.init(paths);
    }

    private <P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> env_nonD(Set.Immutable<O> seenImports, IRelation<L> lt2, IRegExpMatcher<L> re, L l, IScopePath<S, L, O> path, IEsopEnv.Filter<S, L, O, P> filter) {
        Function1<IScopePath, IEsopEnv> & Serializable getter = (Function1<IScopePath, IEsopEnv> & Serializable)p -> this.env(seenImports, lt2, (IRegExpMatcher<L>)re.match(l), (IScopePath<S, L, O>)p, filter);
        return EsopEnvs.union(Iterables.concat(this.directScopes(l, path, getter), this.importScopes(seenImports, l, path, getter)));
    }

    private <P extends IPath<S, L, O>> Iterable<IEsopEnv<S, L, O, P>> directScopes(L l, IScopePath<S, L, O> path, Function1<IScopePath<S, L, O>, IEsopEnv<S, L, O, P>> getter) {
        ArrayList envs = Lists.newArrayList();
        for (IScope nextScope : this.scopeGraph.getDirectEdges().get(path.getTarget(), l)) {
            Paths.append(path, Paths.direct(path.getTarget(), l, nextScope)).map(getter::apply).ifPresent(envs::add);
        }
        return envs;
    }

    private <P extends IPath<S, L, O>> Iterable<IEsopEnv<S, L, O, P>> importScopes(Set.Immutable<O> seenImports, L l, IScopePath<S, L, O> path, Function1<IScopePath<S, L, O>, IEsopEnv<S, L, O, P>> getter) {
        ArrayList envs = Lists.newArrayList();
        for (IOccurrence ref : this.scopeGraph.getImportEdges().get(path.getTarget(), l)) {
            if (seenImports.contains((Object)ref)) continue;
            IEsopEnv<S, L, IOccurrence, IResolutionPath<S, L, IOccurrence>> env = this.resolveEnv(seenImports, ref);
            envs.add(EsopEnvs.guarded((CheckedFunction0<IEsopEnv, E> & Serializable)() -> {
                Collection paths = env.get();
                ArrayList importEnvs = Lists.newArrayList();
                for (IResolutionPath importPath : paths) {
                    for (IScope nextScope : this.scopeGraph.getExportEdges().get(importPath.getDeclaration(), (ILabel)l)) {
                        Paths.append(path, Paths.named(path.getTarget(), l, importPath, nextScope)).map(getter::apply).ifPresent(importEnvs::add);
                    }
                }
                return EsopEnvs.union(importEnvs);
            }));
        }
        return envs;
    }

    private <P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> env_L(Set<L> L2, Set.Immutable<O> seenImports, IRelation<L> lt2, IRegExpMatcher<L> re, IScopePath<S, L, O> path, IEsopEnv.Filter<S, L, O, P> filter) {
        return this.stagedEnv_L.computeIfAbsent(lt2, lo -> this.stageEnv_L(L2, lt2)).apply(seenImports, re, path, filter, Maps.newHashMap());
    }

    private EnvL<S, L, O> stageEnv_L(Set<L> L2, final IRelation<L> lt2) {
        final ArrayList stagedEnvs = Lists.newArrayList();
        for (final ILabel l : this.max(lt2, L2)) {
            final EnvL<S, ILabel, O> smallerEnv = this.stageEnv_L(this.smaller(lt2, L2, l), lt2);
            stagedEnvs.add(new EnvL<S, L, O>(){

                @Override
                public <P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> apply(Set.Immutable<O> seenI, IRegExpMatcher<L> re, IScopePath<S, L, O> path, IEsopEnv.Filter<S, L, O, P> filter, Map<L, IEsopEnv<S, L, O, P>> env_lCache) {
                    IEsopEnv env_l = EsopEnvs.lazy((Function0<IEsopEnv> & Serializable)() -> env_lCache.computeIfAbsent(l, ll -> EsopNameResolution.this.env_l(seenI, lt2, re, l, path, filter)));
                    return EsopEnvs.shadow(filter, smallerEnv.apply(seenI, re, path, filter, env_lCache), env_l);
                }
            });
        }
        return new EnvL<S, L, O>(){

            @Override
            public <P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> apply(Set.Immutable<O> seenI, IRegExpMatcher<L> re, IScopePath<S, L, O> path, IEsopEnv.Filter<S, L, O, P> filter, Map<L, IEsopEnv<S, L, O, P>> env_lCache) {
                return EsopEnvs.union(stagedEnvs.stream().map(se -> se.apply(seenI, re, path, filter, env_lCache)).collect(Collectors.toList()));
            }
        };
    }

    private Set<L> max(IRelation<L> lt2, Set<L> L2) {
        ImmutableSet.Builder maxL = ImmutableSet.builder();
        block0: for (ILabel l : L2) {
            for (ILabel larger : lt2.larger(l)) {
                if (L2.contains(larger)) continue block0;
            }
            maxL.add((Object)l);
        }
        return maxL.build();
    }

    private Set<L> smaller(IRelation<L> lt2, Set<L> L2, L l) {
        ImmutableSet.Builder smallerL = ImmutableSet.builder();
        for (ILabel smaller : lt2.smaller(l)) {
            if (!L2.contains(smaller)) continue;
            smallerL.add((Object)smaller);
        }
        return smallerL.build();
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> EsopNameResolution<S, L, O> of(IResolutionParameters<L> params, IEsopScopeGraph<S, L, O, ?> scopeGraph, Predicate2<S, L> isEdgeClosed) {
        return new EsopNameResolution<S, L, O>(params, scopeGraph, isEdgeClosed, Map.Transient.of(), Map.Transient.of(), Map.Transient.of());
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> EsopNameResolution<S, L, O> of(IResolutionParameters<L> params, IEsopScopeGraph<S, L, O, ?> scopeGraph, Predicate2<S, L> isEdgeClosed, IEsopNameResolution.ResolutionCache<S, L, O> cache) {
        return new EsopNameResolution<S, L, O>(params, scopeGraph, isEdgeClosed, cache.resolutionEntries().asTransient(), cache.visibilityEntries().asTransient(), cache.reachabilityEntries().asTransient());
    }

    public static class ResolutionCache<S extends IScope, L extends ILabel, O extends IOccurrence>
    implements IEsopNameResolution.ResolutionCache<S, L, O>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final Map.Immutable<O, Collection<IResolutionPath<S, L, O>>> resolutionCache;
        private final Map.Immutable<S, Collection<O>> visibilityCache;
        private final Map.Immutable<S, Collection<O>> reachabilityCache;

        private ResolutionCache(Map.Immutable<O, Collection<IResolutionPath<S, L, O>>> resolutionCache, Map.Immutable<S, Collection<O>> visibilityCache, Map.Immutable<S, Collection<O>> reachabilityCache) {
            this.resolutionCache = resolutionCache;
            this.visibilityCache = visibilityCache;
            this.reachabilityCache = reachabilityCache;
        }

        @Override
        public Map.Immutable<O, Collection<IResolutionPath<S, L, O>>> resolutionEntries() {
            return this.resolutionCache;
        }

        @Override
        public Map.Immutable<S, Collection<O>> visibilityEntries() {
            return this.visibilityCache;
        }

        @Override
        public Map.Immutable<S, Collection<O>> reachabilityEntries() {
            return this.reachabilityCache;
        }

        public static <S extends IScope, L extends ILabel, O extends IOccurrence> ResolutionCache<S, L, O> of() {
            return new ResolutionCache<S, L, O>(Map.Immutable.of(), Map.Immutable.of(), Map.Immutable.of());
        }
    }
}

