/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.scopegraph.terms;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mb.nabl2.scopegraph.ILabel;
import mb.nabl2.scopegraph.terms.Label;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AbstractApplTerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.functions.Function1;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ALabel
extends AbstractApplTerm
implements ILabel,
IApplTerm {
    private static final String D_OP = "D";
    private static final String R_OP = "R";
    private static final String I_OP = "I";
    private static final String P_OP = "P";
    private static final String Q_OP = "?";
    private static final String OP = "Label";
    public static final Label D = Label.of("D");
    public static final Label R = Label.of("R");
    public static final Label I = Label.of("I");
    public static final Label P = Label.of("P");
    public static final Label Q = Label.of("?");

    @Override
    @Value.Parameter
    public abstract String getName();

    @Override
    @Value.Lazy
    public String getOp() {
        switch (this.getName()) {
            case "?": 
            case "D": 
            case "I": 
            case "P": 
            case "R": {
                return this.getName();
            }
        }
        return OP;
    }

    @Override
    @Value.Lazy
    public List<ITerm> getArgs() {
        switch (this.getName()) {
            case "?": 
            case "D": 
            case "I": 
            case "P": 
            case "R": {
                return ImmutableList.of();
            }
        }
        return ImmutableList.of((Object)TermBuild.B.newString(this.getName()));
    }

    public static TermMatch.IMatcher<Label> matcher() {
        return ALabel.matcher(l -> l);
    }

    public static <R> TermMatch.IMatcher<R> matcher(Function1<Label, R> f) {
        return TermMatch.M.cases(TermMatch.M.appl0(D_OP, t -> f.apply(D)), TermMatch.M.appl0(R_OP, t -> f.apply(R)), TermMatch.M.appl0(I_OP, t -> f.apply(I)), TermMatch.M.appl0(P_OP, t -> f.apply(P)), TermMatch.M.appl0(Q_OP, t -> f.apply(Q)), TermMatch.M.appl1(OP, TermMatch.M.stringValue(), (t, l) -> f.apply(Label.of(l))));
    }

    @Override
    @Value.Check
    protected ALabel check() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Label)) {
            return super.equals(other);
        }
        Label that = (Label)other;
        return this.getName().equals(that.getName());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

