/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.scopegraph.terms;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mb.nabl2.scopegraph.INameResolution;
import mb.nabl2.scopegraph.IScopeGraph;
import mb.nabl2.scopegraph.esop.CriticalEdgeException;
import mb.nabl2.scopegraph.path.IResolutionPath;
import mb.nabl2.scopegraph.terms.Label;
import mb.nabl2.scopegraph.terms.Occurrence;
import mb.nabl2.scopegraph.terms.Scope;
import mb.nabl2.scopegraph.terms.path.Paths;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;

public final class NameResolutionTerms {
    private final IScopeGraph<Scope, Label, Occurrence> scopeGraph;
    private final INameResolution<Scope, Label, Occurrence> nameResolution;

    private NameResolutionTerms(IScopeGraph<Scope, Label, Occurrence> scopeGraph, INameResolution<Scope, Label, Occurrence> nameResolution) {
        this.scopeGraph = scopeGraph;
        this.nameResolution = nameResolution;
    }

    private ITerm build() throws InterruptedException {
        ArrayList resolutions = Lists.newArrayList();
        for (Occurrence ref : this.scopeGraph.getAllRefs()) {
            resolutions.add(this.buildRef(ref));
        }
        return TermBuild.B.newAppl("NameResolution", TermBuild.B.newList(resolutions));
    }

    private ITerm buildRef(Occurrence ref) throws InterruptedException {
        Object paths;
        try {
            paths = (List)this.nameResolution.resolve(ref).stream().map(this::buildPath).collect(ImmutableList.toImmutableList());
        }
        catch (CriticalEdgeException e) {
            paths = ImmutableList.of();
        }
        IApplTerm result = paths.isEmpty() ? TermBuild.B.newAppl("NoResolution", new ITerm[0]) : TermBuild.B.newAppl("Resolution", TermBuild.B.newList((Iterable<? extends ITerm>)paths));
        return TermBuild.B.newTuple(ref, result);
    }

    private ITerm buildPath(IResolutionPath<Scope, Label, Occurrence> path) {
        return TermBuild.B.newTuple((ITerm)path.getDeclaration(), Paths.toTerm(path));
    }

    public static ITerm build(IScopeGraph<Scope, Label, Occurrence> scopeGraph, INameResolution<Scope, Label, Occurrence> nameResolution) throws InterruptedException {
        return new NameResolutionTerms(scopeGraph, nameResolution).build();
    }
}

