/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.scopegraph.terms;

import com.google.common.base.MoreObjects;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.regexp.IAlphabet;
import mb.nabl2.regexp.IRegExp;
import mb.nabl2.relations.IRelation;
import mb.nabl2.scopegraph.terms.AResolutionParameters;
import mb.nabl2.scopegraph.terms.Label;

public final class ResolutionParameters
extends AResolutionParameters
implements Serializable {
    private final IAlphabet<Label> labels;
    private final Label labelD;
    private final Label labelR;
    private final IRegExp<Label> pathWf;
    private final IRelation.Immutable<Label> specificityOrder;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private ResolutionParameters(IAlphabet<Label> labels, Label labelD, Label labelR, IRegExp<Label> pathWf, IRelation.Immutable<Label> specificityOrder) {
        this.labels = Objects.requireNonNull(labels, "labels");
        this.labelD = Objects.requireNonNull(labelD, "labelD");
        this.labelR = Objects.requireNonNull(labelR, "labelR");
        this.pathWf = Objects.requireNonNull(pathWf, "pathWf");
        this.specificityOrder = Objects.requireNonNull(specificityOrder, "specificityOrder");
        this.hashCode = this.computeHashCode();
    }

    private ResolutionParameters(ResolutionParameters original, IAlphabet<Label> labels, Label labelD, Label labelR, IRegExp<Label> pathWf, IRelation.Immutable<Label> specificityOrder) {
        this.labels = labels;
        this.labelD = labelD;
        this.labelR = labelR;
        this.pathWf = pathWf;
        this.specificityOrder = specificityOrder;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public IAlphabet<Label> getLabels() {
        return this.labels;
    }

    @Override
    public Label getLabelD() {
        return this.labelD;
    }

    @Override
    public Label getLabelR() {
        return this.labelR;
    }

    @Override
    public IRegExp<Label> getPathWf() {
        return this.pathWf;
    }

    @Override
    public IRelation.Immutable<Label> getSpecificityOrder() {
        return this.specificityOrder;
    }

    public final ResolutionParameters withLabels(IAlphabet<Label> value) {
        if (this.labels == value) {
            return this;
        }
        IAlphabet<Label> newValue = Objects.requireNonNull(value, "labels");
        return ResolutionParameters.validate(new ResolutionParameters(this, newValue, this.labelD, this.labelR, this.pathWf, this.specificityOrder));
    }

    public final ResolutionParameters withLabelD(Label value) {
        if (this.labelD == value) {
            return this;
        }
        Label newValue = Objects.requireNonNull(value, "labelD");
        return ResolutionParameters.validate(new ResolutionParameters(this, this.labels, newValue, this.labelR, this.pathWf, this.specificityOrder));
    }

    public final ResolutionParameters withLabelR(Label value) {
        if (this.labelR == value) {
            return this;
        }
        Label newValue = Objects.requireNonNull(value, "labelR");
        return ResolutionParameters.validate(new ResolutionParameters(this, this.labels, this.labelD, newValue, this.pathWf, this.specificityOrder));
    }

    public final ResolutionParameters withPathWf(IRegExp<Label> value) {
        if (this.pathWf == value) {
            return this;
        }
        IRegExp<Label> newValue = Objects.requireNonNull(value, "pathWf");
        return ResolutionParameters.validate(new ResolutionParameters(this, this.labels, this.labelD, this.labelR, newValue, this.specificityOrder));
    }

    public final ResolutionParameters withSpecificityOrder(IRelation.Immutable<Label> value) {
        if (this.specificityOrder == value) {
            return this;
        }
        IRelation.Immutable<Label> newValue = Objects.requireNonNull(value, "specificityOrder");
        return ResolutionParameters.validate(new ResolutionParameters(this, this.labels, this.labelD, this.labelR, this.pathWf, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ResolutionParameters && this.equalTo((ResolutionParameters)another);
    }

    private boolean equalTo(ResolutionParameters another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.labels.equals(another.labels) && this.labelD.equals(another.labelD) && this.labelR.equals(another.labelR) && this.pathWf.equals(another.pathWf) && this.specificityOrder.equals(another.specificityOrder);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + this.labelD.hashCode();
        h += (h << 5) + this.labelR.hashCode();
        h += (h << 5) + this.pathWf.hashCode();
        h += (h << 5) + this.specificityOrder.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ResolutionParameters").omitNullValues().add("labels", this.labels).add("labelD", (Object)this.labelD).add("labelR", (Object)this.labelR).add("pathWf", this.pathWf).add("specificityOrder", this.specificityOrder).toString();
    }

    public static ResolutionParameters of(IAlphabet<Label> labels, Label labelD, Label labelR, IRegExp<Label> pathWf, IRelation.Immutable<Label> specificityOrder) {
        return ResolutionParameters.validate(new ResolutionParameters(labels, labelD, labelR, pathWf, specificityOrder));
    }

    private static ResolutionParameters validate(ResolutionParameters instance) {
        instance.check();
        return instance;
    }

    public static ResolutionParameters copyOf(AResolutionParameters instance) {
        if (instance instanceof ResolutionParameters) {
            return (ResolutionParameters)instance;
        }
        return ResolutionParameters.of(instance.getLabels(), instance.getLabelD(), instance.getLabelR(), instance.getPathWf(), instance.getSpecificityOrder());
    }

    private Object readResolve() throws ObjectStreamException {
        return ResolutionParameters.validate(new ResolutionParameters(this, this.labels, this.labelD, this.labelR, this.pathWf, this.specificityOrder));
    }
}

