/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.scopegraph.terms;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mb.nabl2.constraints.namebinding.DeclProperties;
import mb.nabl2.scopegraph.esop.IEsopScopeGraph;
import mb.nabl2.scopegraph.terms.Label;
import mb.nabl2.scopegraph.terms.Occurrence;
import mb.nabl2.scopegraph.terms.Scope;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.util.Tuple2;
import mb.nabl2.util.collections.IProperties;

public final class ScopeGraphTerms {
    private static final String NO_TYPE = "NoType";
    private static final String TYPE = "Type";
    private final IEsopScopeGraph<Scope, Label, Occurrence, ? extends ITerm> scopeGraph;
    private final IProperties<Occurrence, ITerm, ITerm> properties;
    private final IUnifier unifier;

    private ScopeGraphTerms(IEsopScopeGraph<Scope, Label, Occurrence, ? extends ITerm> scopeGraph, IProperties<Occurrence, ITerm, ITerm> properties, IUnifier unifier) {
        this.scopeGraph = scopeGraph;
        this.properties = properties;
        this.unifier = unifier;
    }

    private ITerm build() {
        List scopes = (List)this.scopeGraph.getAllScopes().stream().map(this::buildScope).collect(ImmutableList.toImmutableList());
        return TermBuild.B.newAppl("ScopeGraph", TermBuild.B.newList(scopes));
    }

    private ITerm buildScope(Scope scope) {
        List exportEdges;
        List importEdges;
        List directEdges;
        List refs;
        ArrayList parts = Lists.newArrayList();
        List decls = (List)this.scopeGraph.getDecls().inverse().get(scope).stream().map(this::buildDecl).collect(ImmutableList.toImmutableList());
        if (!decls.isEmpty()) {
            parts.add(TermBuild.B.newAppl("Decls", TermBuild.B.newList(decls)));
        }
        if (!(refs = (List)this.scopeGraph.getRefs().inverse().get(scope).stream().map(this::buildRef).collect(ImmutableList.toImmutableList())).isEmpty()) {
            parts.add(TermBuild.B.newAppl("Refs", TermBuild.B.newList(refs)));
        }
        if (!(directEdges = Stream.concat(this.scopeGraph.getDirectEdges().get(scope).stream(), this.scopeGraph.incompleteDirectEdges().stream().filter(e -> ((Scope)((Tuple2)e.getKey())._1()).equals(scope)).map(e -> Tuple2.of((Label)((Tuple2)e.getKey())._2(), (ITerm)e.getValue()))).map(this::buildDirectEdge).collect(Collectors.toList())).isEmpty()) {
            parts.add(TermBuild.B.newAppl("DirectEdges", TermBuild.B.newList(directEdges)));
        }
        if (!(importEdges = Stream.concat(this.scopeGraph.getImportEdges().get(scope).stream(), this.scopeGraph.incompleteImportEdges().stream().filter(e -> ((Scope)((Tuple2)e.getKey())._1()).equals(scope)).map(e -> Tuple2.of((Label)((Tuple2)e.getKey())._2(), (ITerm)e.getValue()))).map(this::buildImportEdge).collect(Collectors.toList())).isEmpty()) {
            parts.add(TermBuild.B.newAppl("ImportEdges", TermBuild.B.newList(importEdges)));
        }
        if (!(exportEdges = this.scopeGraph.getExportEdges().inverse().get(scope).stream().map(this::buildExportEdge).collect(Collectors.toList())).isEmpty()) {
            parts.add(TermBuild.B.newAppl("AssocEdges", TermBuild.B.newList(exportEdges)));
        }
        return TermBuild.B.newAppl("Scope", scope, TermBuild.B.newList(parts));
    }

    private ITerm buildDecl(Occurrence decl) {
        return TermBuild.B.newAppl("Decl", decl, this.buildType(this.properties.getValue(decl, DeclProperties.TYPE_KEY)));
    }

    private ITerm buildType(Optional<ITerm> type) {
        return type.map(this.unifier::findRecursive).map(t -> TermBuild.B.newAppl(TYPE, (ITerm)t)).orElseGet(() -> TermBuild.B.newAppl(NO_TYPE, new ITerm[0]));
    }

    private ITerm buildRef(Occurrence ref) {
        return TermBuild.B.newAppl("Ref", ref);
    }

    private ITerm buildDirectEdge(Map.Entry<Label, ? extends ITerm> edge) {
        return TermBuild.B.newAppl("DirectEdge", edge.getKey(), edge.getValue());
    }

    private ITerm buildImportEdge(Map.Entry<Label, ? extends ITerm> edge) {
        return TermBuild.B.newAppl("ImportEdge", edge.getKey(), edge.getValue());
    }

    private ITerm buildExportEdge(Map.Entry<Label, Occurrence> edge) {
        return TermBuild.B.newAppl("AssocEdge", edge.getKey(), edge.getValue());
    }

    public static ITerm build(IEsopScopeGraph<Scope, Label, Occurrence, ? extends ITerm> scopeGraph, IProperties<Occurrence, ITerm, ITerm> properties, IUnifier unifier) {
        return new ScopeGraphTerms(scopeGraph, properties, unifier).build();
    }
}

