/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.scopegraph.terms.path;

import io.usethesource.capsule.Set;
import javax.annotation.Nullable;
import mb.nabl2.scopegraph.ILabel;
import mb.nabl2.scopegraph.IOccurrence;
import mb.nabl2.scopegraph.IScope;
import mb.nabl2.scopegraph.path.IResolutionPath;
import mb.nabl2.scopegraph.path.IScopePath;
import mb.nabl2.util.collections.ConsList;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

@Value.Immutable
@Serial.Version(value=42L)
abstract class AResolutionPath<S extends IScope, L extends ILabel, O extends IOccurrence>
implements IResolutionPath<S, L, O> {
    AResolutionPath() {
    }

    @Override
    @Value.Parameter
    public abstract O getReference();

    @Override
    @Value.Parameter
    public abstract IScopePath<S, L, O> getPath();

    @Override
    @Value.Parameter
    public abstract O getDeclaration();

    @Nullable
    @Value.Check
    public AResolutionPath<S, L, O> check() {
        if (!IOccurrence.match(this.getReference(), this.getDeclaration())) {
            return null;
        }
        if (this.getPath().getImports().contains(this.getReference())) {
            return null;
        }
        return this;
    }

    @Override
    @Value.Lazy
    public Set.Immutable<O> getImports() {
        return this.getPath().getImports();
    }

    @Override
    @Value.Lazy
    public Set.Immutable<S> getScopes() {
        return this.getPath().getScopes();
    }

    @Override
    @Value.Lazy
    public ConsList<L> getLabels() {
        return this.getPath().getLabels();
    }

    @Override
    public Iterable<IResolutionPath<S, L, O>> getImportPaths() {
        return this.getPath().getImportPaths();
    }

    @Value.Lazy
    public abstract int hashCode();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReference());
        sb.append(" ");
        sb.append("R");
        sb.append(" ");
        sb.append(this.getPath());
        sb.append(" ");
        sb.append("D");
        sb.append(" ");
        sb.append(this.getDeclaration());
        return sb.toString();
    }
}

