/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.scopegraph.terms.path;

import java.util.Iterator;
import java.util.NoSuchElementException;
import mb.nabl2.scopegraph.ILabel;
import mb.nabl2.scopegraph.IOccurrence;
import mb.nabl2.scopegraph.IScope;
import mb.nabl2.scopegraph.path.IScopePath;
import mb.nabl2.scopegraph.path.IStep;
import mb.nabl2.scopegraph.terms.path.ComposedScopePath;
import mb.nabl2.scopegraph.terms.path.EmptyScopePath;

public class PathIterator<S extends IScope, L extends ILabel, O extends IOccurrence>
implements Iterator<IStep<S, L, O>> {
    private IStep<S, L, O> next;
    private IScopePath<S, L, O> path;

    public PathIterator(IScopePath<S, L, O> path) {
        this.path = path;
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.next != null;
    }

    @Override
    public IStep<S, L, O> next() {
        this.findNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        IStep<S, L, O> result = this.next;
        this.next = null;
        return result;
    }

    private void findNext() {
        IScopePath<S, L, O> p;
        if (this.next != null) {
            return;
        }
        if (this.path instanceof EmptyScopePath) {
            p = null;
            this.path = null;
        } else if (this.path instanceof ComposedScopePath) {
            ComposedScopePath q = (ComposedScopePath)this.path;
            p = q.getLeft();
            this.path = q.getRight();
        } else {
            p = this.path;
            this.path = null;
        }
        if (p == null) {
            return;
        }
        if (!(p instanceof IStep)) {
            throw new IllegalStateException();
        }
        this.next = (IStep)p;
    }
}

