/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.sets;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.sets.IElement;
import mb.nabl2.sets.ISetProducer;
import mb.nabl2.sets.SetTerms;
import mb.nabl2.terms.matching.TermMatch;
import org.metaborg.util.iterators.Iterables2;

public class SetEvaluator {
    public static <T> TermMatch.IMatcher<ISetProducer<T>> matcher(TermMatch.IMatcher<ISetProducer<T>> elemMatcher) {
        return TermMatch.M.casesFix(m -> Iterables2.from(elemMatcher, TermMatch.M.appl0("EmptySet", t -> () -> Sets.newHashSet()), TermMatch.M.appl2("Union", m, m, (t, leftSet, rightSet) -> () -> {
            HashSet result = Sets.newHashSet();
            result.addAll(leftSet.apply());
            result.addAll(rightSet.apply());
            return result;
        }), TermMatch.M.appl3("Isect", m, SetTerms.projectionMatcher(), m, (t, leftSet, proj, rightSet) -> () -> {
            Multimap leftProj = SetEvaluator.project(leftSet.apply(), proj);
            Multimap rightProj = SetEvaluator.project(rightSet.apply(), proj);
            HashMultimap result = HashMultimap.create();
            result.putAll(leftProj);
            result.putAll(rightProj);
            result.keySet().retainAll(rightProj.keySet());
            result.keySet().retainAll(leftProj.keySet());
            return Sets.newHashSet((Iterable)result.values());
        }), TermMatch.M.appl3("Lsect", m, SetTerms.projectionMatcher(), m, (t, leftSet, proj, rightSet) -> () -> {
            Multimap leftProj = SetEvaluator.project(leftSet.apply(), proj);
            Multimap rightProj = SetEvaluator.project(rightSet.apply(), proj);
            HashMultimap result = HashMultimap.create();
            result.putAll(leftProj);
            result.keySet().retainAll(rightProj.keySet());
            return Sets.newHashSet((Iterable)result.values());
        }), TermMatch.M.appl3("Diff", m, SetTerms.projectionMatcher(), m, (t, leftSet, proj, rightSet) -> () -> {
            Multimap leftProj = SetEvaluator.project(leftSet.apply(), proj);
            Multimap rightProj = SetEvaluator.project(rightSet.apply(), proj);
            HashMultimap result = HashMultimap.create();
            result.putAll(leftProj);
            result.keySet().removeAll(rightProj.keySet());
            return Sets.newHashSet((Iterable)result.values());
        })));
    }

    public static <T> Multimap<Object, IElement<T>> project(Set<IElement<T>> elems, Optional<String> proj) {
        HashMultimap result = HashMultimap.create();
        for (IElement elem : elems) {
            result.put(proj.map(p -> elem.project((String)p)).orElseGet(() -> elem.getValue()), elem);
        }
        return result;
    }
}

