/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.relations.variants.IVariantRelation;
import mb.nabl2.relations.variants.VariantRelations;
import mb.nabl2.scopegraph.esop.IEsopNameResolution;
import mb.nabl2.scopegraph.esop.IEsopScopeGraph;
import mb.nabl2.scopegraph.esop.lazy.EsopNameResolution;
import mb.nabl2.scopegraph.esop.reference.EsopScopeGraph;
import mb.nabl2.scopegraph.terms.Label;
import mb.nabl2.scopegraph.terms.Occurrence;
import mb.nabl2.scopegraph.terms.OccurrenceIndex;
import mb.nabl2.scopegraph.terms.Scope;
import mb.nabl2.solver.ISolution;
import mb.nabl2.solver.Solution;
import mb.nabl2.solver.SolverConfig;
import mb.nabl2.solver.messages.IMessages;
import mb.nabl2.solver.messages.Messages;
import mb.nabl2.symbolic.ISymbolicConstraints;
import mb.nabl2.symbolic.SymbolicConstraints;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.unification.Unifiers;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.util.collections.IProperties;
import mb.nabl2.util.collections.Properties;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

@Value.Immutable(builder=true)
@Serial.Version(value=1L)
public abstract class ASolution
implements ISolution {
    @Override
    @Value.Parameter
    public abstract SolverConfig config();

    @Override
    @Value.Parameter
    public abstract IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties();

    @Override
    @Value.Parameter
    public abstract IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph();

    @Override
    @Value.Lazy
    public Multimap<OccurrenceIndex, Occurrence> astDecls() {
        ImmutableMultimap.Builder astDecls = ImmutableMultimap.builder();
        this.scopeGraph().getAllDecls().forEach(o -> astDecls.put((Object)o.getIndex(), o));
        return astDecls.build();
    }

    @Override
    @Value.Lazy
    public Multimap<OccurrenceIndex, Occurrence> astRefs() {
        ImmutableMultimap.Builder astRefs = ImmutableMultimap.builder();
        this.scopeGraph().getAllRefs().forEach(o -> astRefs.put((Object)o.getIndex(), o));
        return astRefs.build();
    }

    @Override
    public IEsopNameResolution<Scope, Label, Occurrence> nameResolution() {
        EsopNameResolution<Scope, Label, Occurrence> nr = EsopNameResolution.of(this.config().getResolutionParams(), this.scopeGraph(), (s, l) -> true, this.nameResolutionCache());
        return nr;
    }

    @Override
    @Value.Default
    public IEsopNameResolution.ResolutionCache<Scope, Label, Occurrence> nameResolutionCache() {
        return EsopNameResolution.ResolutionCache.of();
    }

    @Override
    @Value.Parameter
    public abstract IProperties.Immutable<Occurrence, ITerm, ITerm> declProperties();

    @Override
    @Value.Parameter
    public abstract Map<String, IVariantRelation.Immutable<ITerm>> relations();

    @Override
    @Value.Parameter
    public abstract IUnifier.Immutable unifier();

    @Override
    @Value.Parameter
    public abstract ISymbolicConstraints symbolic();

    @Override
    @Value.Parameter
    public abstract IMessages.Immutable messages();

    @Override
    @Value.Parameter
    public abstract Set<IConstraint> constraints();

    public static ISolution of(SolverConfig config) {
        return Solution.of(config, Properties.Immutable.of(), EsopScopeGraph.Immutable.of(), Properties.Immutable.of(), VariantRelations.immutableOf(config.getRelations()), (IUnifier.Immutable)Unifiers.Immutable.of(), (ISymbolicConstraints)SymbolicConstraints.of(), (IMessages.Immutable)Messages.Immutable.of(), Collections.emptySet());
    }
}

